/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.util.ArrayList;
import java.util.List;
import org.olap4j.Axis;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.CompoundId;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpVisitor;

public class QueryAxis
extends AbstractExp {
    private static final long serialVersionUID = 9064412375948950770L;
    private Axis axis;
    private Exp exp;
    private boolean nonEmpty;
    private List<CompoundId> dimensionProperties = new ArrayList<CompoundId>();

    public QueryAxis() {
    }

    public QueryAxis(Axis axis, Exp exp) {
        this(axis, exp, false);
    }

    public QueryAxis(Axis axis, Exp exp, boolean nonEmpty) {
        this.axis = axis;
        this.exp = exp;
        this.nonEmpty = nonEmpty;
    }

    public Exp getExp() {
        return this.exp;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setExp(Exp exp) {
        this.exp = exp;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public List<CompoundId> getDimensionProperties() {
        return this.dimensionProperties;
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        if (this.exp != null) {
            if (this.nonEmpty) {
                sb.append("NON EMPTY ");
            }
            if (this.exp != null) {
                sb.append(this.exp.toMdx());
            }
            if (!this.dimensionProperties.isEmpty()) {
                sb.append(" DIMENSION PROPERTIES ");
                boolean isFollow = false;
                for (CompoundId property : this.dimensionProperties) {
                    if (isFollow) {
                        sb.append(',');
                    } else {
                        isFollow = true;
                    }
                    sb.append(property.toMdx());
                }
            }
            sb.append(" ON ");
            if (this.axis != null) {
                sb.append(this.axis.name());
            }
        }
        return sb.toString();
    }

    @Override
    public QueryAxis copy() {
        QueryAxis clone = new QueryAxis();
        clone.axis = this.axis;
        clone.nonEmpty = this.nonEmpty;
        if (this.exp != null) {
            clone.exp = this.exp.copy();
        }
        for (CompoundId property : this.dimensionProperties) {
            clone.dimensionProperties.add(property.copy());
        }
        return clone;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitQueryAxis(this);
        if (this.exp != null) {
            this.exp.accept(visitor);
        }
        for (CompoundId property : this.dimensionProperties) {
            property.accept(visitor);
        }
    }
}

