/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.ExpVisitor;

public class Literal
extends AbstractExp {
    private static final long serialVersionUID = 3137892085820716628L;
    private int type;
    private Object o;
    public static final Literal EMPTY_STRING = new Literal("", false);
    public static final Literal ZERO = new Literal(0);
    public static final Literal ONE = new Literal(1);
    public static final Literal DOUBLE_ZERO = new Literal(0.0);
    public static final Literal DOUBLE_ONE = new Literal(1.0);
    public static final int TYPE_SYMBOL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_NUMERIC = 3;

    private Literal(String s, boolean isSymbol) {
        this.o = s;
        this.type = isSymbol ? 1 : 2;
    }

    public static Literal createString(String s) {
        if (s.equals("")) {
            return EMPTY_STRING;
        }
        return new Literal(s, false);
    }

    public static Literal createSymbol(String s) {
        return new Literal(s, true);
    }

    private Literal(Double d) {
        this.o = d;
        this.type = 3;
    }

    public static Literal create(Double d) {
        if (d == 0.0) {
            return DOUBLE_ZERO;
        }
        if (d == 1.0) {
            return DOUBLE_ONE;
        }
        return new Literal(d);
    }

    private Literal(Integer i) {
        this.o = i;
        this.type = 3;
    }

    public static Literal create(Integer i) {
        if (i == 0) {
            return ZERO;
        }
        if (i == 1) {
            return ONE;
        }
        return new Literal(i);
    }

    @Override
    public String toMdx() {
        return this.o.toString();
    }

    @Override
    public final Literal copy() {
        return this;
    }

    public String stringValue() {
        if (this.type == 2) {
            String str = (String)this.o;
            return str.substring(1, str.length() - 1);
        }
        return this.o.toString();
    }

    public Object getValueObject() {
        return this.o;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitLiteral(this);
    }
}

