/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.util.ArrayList;
import java.util.List;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpVisitor;
import org.pivot4j.mdx.Syntax;

public class FunCall
extends AbstractExp {
    private static final long serialVersionUID = -1747077227822699594L;
    private Syntax type;
    private String function;
    private List<Exp> args = new ArrayList<Exp>();

    public FunCall() {
    }

    public FunCall(String function) {
        this(function, Syntax.Function);
    }

    public FunCall(String function, Syntax type) {
        this(function, type, null);
    }

    public FunCall(String function, Syntax type, List<Exp> args) {
        this.function = function;
        this.type = type;
        if (args != null) {
            this.args.addAll(args);
        }
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public Syntax getType() {
        return this.type;
    }

    public void setType(Syntax type) {
        this.type = type;
    }

    public List<Exp> getArgs() {
        return this.args;
    }

    @Override
    public String toMdx() {
        return this.type.toMdx(this.function, this.args);
    }

    @Override
    public FunCall copy() {
        ArrayList<Exp> cloneArgs = new ArrayList<Exp>(this.args.size());
        for (Exp arg : this.args) {
            cloneArgs.add(arg.copy());
        }
        return new FunCall(this.function, this.type, cloneArgs);
    }

    public boolean isCallTo(String fName) {
        return fName.compareToIgnoreCase(this.function) == 0;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitFunCall(this);
        for (Exp arg : this.args) {
            arg.accept(visitor);
        }
    }
}

