/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.util.ArrayList;
import java.util.List;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.CompoundId;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpVisitor;

public class Formula
extends AbstractExp {
    private static final long serialVersionUID = 4575864552263862759L;
    private CompoundId name;
    private Exp exp;
    private Type type;
    private List<Property> properties = new ArrayList<Property>();

    public Formula() {
    }

    public Formula(CompoundId name, Exp exp, Type type) {
        this.name = name;
        this.exp = exp;
        this.type = type;
    }

    public CompoundId getName() {
        return this.name;
    }

    public void setName(CompoundId name) {
        this.name = name;
    }

    public Exp getExp() {
        return this.exp;
    }

    public void setExp(Exp exp) {
        this.exp = exp;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type.name());
            sb.append(' ');
        }
        if (this.name != null) {
            sb.append(this.name.toMdx());
        }
        sb.append(" AS '");
        if (this.exp != null) {
            sb.append(this.exp.toMdx());
        }
        sb.append('\'');
        for (Property property : this.properties) {
            sb.append(',');
            sb.append(property.toMdx());
        }
        return sb.toString();
    }

    @Override
    public Formula copy() {
        Formula clone = new Formula();
        clone.type = this.type;
        if (this.name != null) {
            clone.name = this.name.copy();
        }
        if (this.exp != null) {
            clone.exp = this.exp.copy();
        }
        for (Property property : this.properties) {
            clone.properties.add(property.copy());
        }
        return clone;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitFormula(this);
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.exp != null) {
            this.exp.accept(visitor);
        }
        for (Property property : this.properties) {
            property.accept(visitor);
        }
    }

    public static class Property
    extends AbstractExp {
        private static final long serialVersionUID = 519325113391951347L;
        private String name;
        private Exp exp;

        public Property() {
        }

        public Property(String name, Exp exp) {
            this.name = name;
            this.exp = exp;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Exp getExp() {
            return this.exp;
        }

        public void setExp(Exp exp) {
            this.exp = exp;
        }

        @Override
        public String toMdx() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name);
            }
            sb.append(" = ");
            if (this.exp != null) {
                sb.append(this.exp.toMdx());
            }
            return sb.toString();
        }

        @Override
        public Property copy() {
            Property clone = new Property();
            clone.name = this.name;
            if (this.exp != null) {
                clone.exp = this.exp.copy();
            }
            return clone;
        }

        @Override
        public void accept(ExpVisitor visitor) {
            visitor.visitFormulaProperty(this);
            if (this.exp != null) {
                this.exp.accept(visitor);
            }
        }
    }

    public static enum Type {
        MEMBER,
        SET;

    }
}

