/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.OlapException;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.pivot4j.PivotException;
import org.pivot4j.impl.SetExp;
import org.pivot4j.impl.UnknownExpressionException;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.metadata.DimensionExp;
import org.pivot4j.mdx.metadata.LevelExp;
import org.pivot4j.mdx.metadata.MemberExp;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.OlapUtils;

public class QuaxUtil {
    private Cube cube;
    private MemberHierarchyCache cache;
    private OlapUtils olapUtils;

    public QuaxUtil(Cube cube) {
        this(cube, null);
    }

    public QuaxUtil(Cube cube, MemberHierarchyCache cache) {
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        this.cube = cube;
        this.cache = cache == null ? new MemberHierarchyCache(cube) : cache;
        this.olapUtils = new OlapUtils(cube);
        this.olapUtils.setMemberHierarchyCache(cache);
    }

    protected Cube getCube() {
        return this.cube;
    }

    protected OlapUtils getOlapUtils() {
        return this.olapUtils;
    }

    public boolean isMember(Exp oExp) {
        return oExp instanceof MemberExp;
    }

    public boolean isFunCall(Exp oExp) {
        return oExp instanceof FunCall;
    }

    public boolean equalMember(Exp oExp, Member member) {
        return OlapUtils.equals((MetadataElement)member, (MetadataElement)this.memberForExp(oExp));
    }

    public boolean isFunCallTo(Exp oExp, String function) {
        return this.isFunCall(oExp) && ((FunCall)oExp).isCallTo(function);
    }

    public boolean checkParent(Member pMember, Exp cMembObj) {
        Member child = this.memberForExp(cMembObj);
        return child != null && OlapUtils.equals((MetadataElement)pMember, (MetadataElement)this.cache.getParentMember(child));
    }

    public boolean checkChild(Member cMember, Exp pMembObj) {
        Member parent = this.memberForExp(pMembObj);
        return parent != null && OlapUtils.equals((MetadataElement)parent, (MetadataElement)this.cache.getParentMember(cMember));
    }

    public boolean checkDescendantM(Member aMember, Member dMember) {
        return dMember.getAncestorMembers().contains(dMember);
    }

    public boolean isMemberInFunCall(Exp oExp, Member member) throws UnknownExpressionException {
        if (!this.isFunCall(oExp)) {
            return false;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            return this.isMemberInChildren(f, member);
        }
        if (f.isCallTo("Descendants")) {
            return this.isMemberInDescendants(f, member);
        }
        if (f.isCallTo("Members")) {
            return this.isMemberInLevel(f, member);
        }
        if (f.isCallTo("Union")) {
            return this.isMemberInUnion(f, member);
        }
        if (f.isCallTo("{}")) {
            return this.isMemberInSet(f, member);
        }
        throw new UnknownExpressionException(f.getFunction());
    }

    public boolean isChildOfMemberInFunCall(Exp oExp, Member member) throws UnknownExpressionException {
        if (!this.isFunCall(oExp) || member.isCalculated()) {
            return false;
        }
        Member mem = this.olapUtils.wrapRaggedIfNecessary(member);
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            return OlapUtils.equals((MetadataElement)mem, (MetadataElement)this.memberForExp(f.getArgs().get(0)));
        }
        if (f.isCallTo("Descendants")) {
            Member ancestor = this.memberForExp(f.getArgs().get(0));
            Level level = this.levelForExp(f.getArgs().get(1));
            Level parentLevel = this.getParentLevel(level);
            if (parentLevel != null && OlapUtils.equals((MetadataElement)mem.getLevel(), (MetadataElement)parentLevel)) {
                int ancestorLevelNumber = ancestor.getLevel().getDepth();
                while (ancestorLevelNumber < mem.getLevel().getDepth()) {
                    mem = this.cache.getParentMember(mem);
                }
                return OlapUtils.equals((MetadataElement)mem, (MetadataElement)ancestor);
            }
            return false;
        }
        if (f.isCallTo("Members")) {
            Level level = this.levelForExp(f.getArgs().get(0));
            Level parentLevel = null;
            if (level.getDepth() > 0) {
                NamedList levels = level.getHierarchy().getLevels();
                for (Level l : levels) {
                    if (l.getDepth() != level.getDepth() - 1) continue;
                    parentLevel = l;
                    break;
                }
            }
            return parentLevel != null && OlapUtils.equals((MetadataElement)mem.getLevel(), parentLevel);
        }
        if (f.isCallTo("Union")) {
            return this.isChildOfMemberInFunCall(f.getArgs().get(0), mem) || this.isChildOfMemberInFunCall(f.getArgs().get(1), mem);
        }
        if (f.isCallTo("{}")) {
            for (Exp exp : f.getArgs()) {
                Member mm = this.memberForExp(exp);
                Member mmp = this.olapUtils.getTopLevelRaggedMember(mm);
                if (mmp == null || !OlapUtils.equals((MetadataElement)this.olapUtils.wrapRaggedIfNecessary(mmp), (MetadataElement)mem)) continue;
                return true;
            }
            return false;
        }
        throw new UnknownExpressionException(f.getFunction());
    }

    public boolean isDescendantOfMemberInFunCall(Exp oExp, Member member) throws UnknownExpressionException {
        if (!this.isFunCall(oExp) || member.isCalculated()) {
            return false;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            Member mExp = this.memberForExp(f.getArgs().get(0));
            return OlapUtils.equals((MetadataElement)member, (MetadataElement)mExp) || this.isDescendant(member, mExp);
        }
        if (f.isCallTo("Descendants")) {
            Member mExp = this.memberForExp(f.getArgs().get(0));
            return OlapUtils.equals((MetadataElement)member, (MetadataElement)mExp) || this.isDescendant(member, mExp);
        }
        if (f.isCallTo("Members")) {
            Level levExp = this.levelForExp(f.getArgs().get(0));
            return levExp.getDepth() > member.getLevel().getDepth();
        }
        if (f.isCallTo("Union")) {
            if (this.isDescendantOfMemberInFunCall(f.getArgs().get(0), member)) {
                return true;
            }
            return this.isDescendantOfMemberInFunCall(f.getArgs().get(1), member);
        }
        if (f.isCallTo("{}")) {
            for (Exp arg : f.getArgs()) {
                Member mExp = this.memberForExp(arg);
                if (OlapUtils.equals((MetadataElement)member, (MetadataElement)mExp) || !this.isDescendant(member, mExp)) continue;
                return true;
            }
            return false;
        }
        throw new UnknownExpressionException(f.getFunction());
    }

    public boolean isDescendant(Member ancestor, Exp descendant) {
        Member member = this.memberForExp(descendant);
        if (member == null) {
            return false;
        }
        return this.isDescendant(ancestor, member);
    }

    public boolean isDescendant(Member ancestor, Member descendant) {
        if (descendant.isCalculated()) {
            return false;
        }
        if (OlapUtils.equals((MetadataElement)ancestor, (MetadataElement)descendant)) {
            return false;
        }
        int ancestorLevelNumber = ancestor.getDepth();
        Member mm = descendant;
        while (mm != null && ancestorLevelNumber < mm.getDepth()) {
            mm = this.cache.getParentMember(mm);
        }
        return OlapUtils.equals((MetadataElement)mm, (MetadataElement)ancestor);
    }

    public boolean isFunCallNotTopLevel(Exp oExp) throws UnknownExpressionException {
        if (!this.isFunCall(oExp)) {
            return false;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            return true;
        }
        if (f.isCallTo("Descendants")) {
            return true;
        }
        if (f.isCallTo("Members")) {
            Level level = this.levelForExp(f.getArgs().get(0));
            return level.getDepth() > 0;
        }
        if (f.isCallTo("Union")) {
            if (this.isFunCallNotTopLevel(f.getArgs().get(0))) {
                return true;
            }
            return this.isFunCallNotTopLevel(f.getArgs().get(1));
        }
        if (f.isCallTo("{}")) {
            for (Exp exp : f.getArgs()) {
                if (this.isMemberOnToplevel(exp)) continue;
                return true;
            }
            return false;
        }
        throw new UnknownExpressionException(f.getFunction());
    }

    public boolean isMemberOnToplevel(Exp oMem) {
        Member member = this.memberForExp(oMem);
        return member.getLevel().getDepth() <= 0;
    }

    public boolean canHandle(Exp oExp) {
        if (this.isMember(oExp)) {
            return true;
        }
        if (this.isFunCall(oExp)) {
            FunCall f = (FunCall)oExp;
            if (f.isCallTo("children")) {
                return true;
            }
            if (f.isCallTo("descendants")) {
                return true;
            }
            if (f.isCallTo("members")) {
                return true;
            }
            if (f.isCallTo("{}")) {
                return true;
            }
            if (f.isCallTo("union")) {
                for (Exp exp : f.getArgs()) {
                    if (this.canHandle(exp)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Member getParentMember(Exp oExp) {
        return this.cache.getParentMember(this.memberForExp(oExp));
    }

    public List<Exp> getChildMembers(Exp oParent) {
        NamedList members;
        Member parent = this.memberForExp(oParent);
        if (parent == null) {
            return Collections.emptyList();
        }
        try {
            members = parent.getChildMembers();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        ArrayList<Exp> children = new ArrayList<Exp>(members.size());
        for (Member member : members) {
            children.add(this.expForMember(member));
        }
        return children;
    }

    public Member memberForExp(Exp oExp) {
        FunCall func;
        if (oExp instanceof MemberExp) {
            return (Member)((MemberExp)oExp).getMetadata(this.cube);
        }
        if (oExp instanceof FunCall && this.isFunCallTo(oExp, "{}") && !(func = (FunCall)oExp).getArgs().isEmpty()) {
            return this.memberForExp(func.getArgs().get(0));
        }
        return null;
    }

    public Level levelForExp(Exp oExp) {
        if (oExp instanceof DimensionExp) {
            return (Level)((LevelExp)oExp).getMetadata(this.cube);
        }
        return null;
    }

    public StringBuilder funString(Exp oExp) {
        FunCall f = (FunCall)oExp;
        StringBuilder sb = new StringBuilder();
        if (f.isCallTo("Children")) {
            Member m = this.memberForExp(f.getArgs().get(0));
            sb.append(m.getUniqueName());
            sb.append(".Children");
        } else if (f.isCallTo("Descendants")) {
            Member m = this.memberForExp(f.getArgs().get(0));
            Level lev = this.levelForExp(f.getArgs().get(1));
            sb.append("Descendants(");
            sb.append(m.getUniqueName());
            sb.append(",");
            sb.append(lev.getUniqueName());
            sb.append(")");
        } else if (f.isCallTo("members")) {
            Level lev = this.levelForExp(f.getArgs().get(0));
            sb.append(lev.getUniqueName());
            sb.append(".Members");
        } else if (f.isCallTo("Union")) {
            sb.append("Union(");
            FunCall f1 = (FunCall)f.getArgs().get(0);
            sb.append((CharSequence)this.funString(f1));
            sb.append(",");
            FunCall f2 = (FunCall)f.getArgs().get(1);
            sb.append((CharSequence)this.funString(f2));
            sb.append(")");
        } else if (f.isCallTo("{}")) {
            sb.append("{");
            boolean isFollow = false;
            for (Exp exp : f.getArgs()) {
                if (isFollow) {
                    sb.append(",");
                } else {
                    isFollow = true;
                }
                Member m = this.memberForExp(exp);
                sb.append(m.getUniqueName());
            }
            sb.append("}");
        } else if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent")) {
            sb.append(f.getFunction());
            sb.append("(");
            FunCall f1 = (FunCall)f.getArgs().get(0);
            sb.append((CharSequence)this.funString(f1));
            sb.append(")");
        }
        return sb;
    }

    public String getMemberUniqueName(Exp oExp) {
        Member member = this.memberForExp(oExp);
        return member.getUniqueName();
    }

    public Exp expForMember(Member member) {
        return new MemberExp(this.olapUtils.wrapRaggedIfNecessary(member));
    }

    public Exp expForDim(Dimension dimension) {
        return new DimensionExp(dimension);
    }

    public Exp expForLevel(Level level) {
        return new LevelExp(level);
    }

    public String memberString(List<Member> path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Member member : path) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(member.getUniqueName());
            ++i;
        }
        return sb.toString();
    }

    public Exp createMemberSet(List<Member> members) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        if (members.size() == 1) {
            return this.expForMember(members.get(0));
        }
        ArrayList<Exp> remExps = new ArrayList<Exp>(members.size());
        for (Member member : members) {
            remExps.add(this.expForMember(member));
        }
        return new FunCall("{}", Syntax.Braces, remExps);
    }

    public int levelDepthForMember(Exp oExp) {
        Member member = this.memberForExp(oExp);
        Level level = member.getLevel();
        return level.getDepth();
    }

    public Hierarchy hierForExp(Exp oExp) throws UnknownExpressionException {
        if (this.isMember(oExp)) {
            return this.memberForExp(oExp).getHierarchy();
        }
        if (oExp instanceof SetExp) {
            SetExp set = (SetExp)oExp;
            return set.getHierarchy();
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children") || f.isCallTo("Descendants") || f.isCallTo("{}")) {
            Member member = this.memberForExp(f.getArgs().get(0));
            return member.getHierarchy();
        }
        if (f.isCallTo("Members")) {
            Level level = this.levelForExp(f.getArgs().get(0));
            return level.getHierarchy();
        }
        if (f.isCallTo("Union")) {
            return this.hierForExp(f.getArgs().get(0));
        }
        if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent") || f.isCallTo("Filter")) {
            return this.hierForExp(f.getArgs().get(0));
        }
        throw new UnknownExpressionException(f.getFunction());
    }

    public Exp topLevelMembers(Hierarchy hierarchy, boolean expandAllMember) {
        List topMembers;
        Member mAll;
        NamedList levels = hierarchy.getLevels();
        if (levels.isEmpty()) {
            return null;
        }
        Level topLevel = (Level)hierarchy.getLevels().get(0);
        if (!topLevel.isVisible()) {
            return null;
        }
        try {
            mAll = hierarchy.getDefaultMember();
            if (!mAll.isAll()) {
                mAll = null;
                for (Member m : hierarchy.getRootMembers()) {
                    if (!m.isAll()) continue;
                    mAll = m;
                    break;
                }
            }
            if (mAll != null && !OlapUtils.isVisible(mAll)) {
                mAll = null;
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        if (mAll != null) {
            ArrayList<Exp> memar = new ArrayList<Exp>();
            memar.add(this.expForMember(mAll));
            FunCall mAllSet = new FunCall("{}", Syntax.Braces, memar);
            if (!expandAllMember) {
                return (Exp)memar.get(0);
            }
            FunCall mAllChildren = new FunCall("children", Syntax.Property, memar);
            FunCall union = new FunCall("Union", Syntax.Function);
            union.getArgs().add(mAllSet);
            union.getArgs().add(mAllChildren);
            return union;
        }
        try {
            topMembers = topLevel.getMembers();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        ArrayList<Exp> topExp = new ArrayList<Exp>(topMembers.size());
        for (Member member : topMembers) {
            if (!OlapUtils.isVisible(member)) continue;
            topExp.add(this.expForMember(member));
        }
        if (topExp.size() == 1) {
            return (Exp)topExp.get(0);
        }
        return new FunCall("{}", Syntax.Braces, topExp);
    }

    public int funCallArgCount(Exp oFun) {
        FunCall f = (FunCall)oFun;
        return f.getArgs().size();
    }

    public String funCallName(Exp oFun) {
        return ((FunCall)oFun).getFunction();
    }

    public Exp funCallArg(Exp oFun, int index) {
        return ((FunCall)oFun).getArgs().get(index);
    }

    public void addMemberUncles(List<Exp> list, Member member, int[] maxLevel) {
        int parentLevel = member.getLevel().getDepth() - 1;
        if (parentLevel < maxLevel[0]) {
            return;
        }
        if (parentLevel > maxLevel[0]) {
            maxLevel[0] = parentLevel;
            list.clear();
        }
        if (parentLevel > 0) {
            Member parent = this.cache.getParentMember(member);
            Member grandPa = this.cache.getParentMember(parent);
            for (Exp exp : list) {
                FunCall f;
                if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !OlapUtils.equals((MetadataElement)this.memberForExp(f.getArgs().get(0)), (MetadataElement)grandPa)) continue;
                return;
            }
            FunCall uncles = new FunCall("Children", Syntax.Property);
            uncles.getArgs().add(this.expForMember(grandPa));
            list.add(uncles);
        }
    }

    public void addMemberSiblings(List<Exp> list, Member member, int[] maxLevel) {
        int level = member.getLevel().getDepth();
        if (level < maxLevel[0]) {
            return;
        }
        if (level > maxLevel[0]) {
            maxLevel[0] = level;
            list.clear();
        }
        if (level > 0) {
            Member parent = this.cache.getParentMember(member);
            for (Exp exp : list) {
                FunCall f;
                if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !OlapUtils.equals((MetadataElement)this.memberForExp(f.getArgs().get(0)), (MetadataElement)parent)) continue;
                return;
            }
            FunCall siblings = new FunCall("Children", Syntax.Property);
            siblings.getArgs().add(this.expForMember(parent));
            list.add(siblings);
        }
    }

    public void addMemberChildren(List<Exp> list, Member member, int[] maxLevel) {
        int childLevel = member.getLevel().getDepth() + 1;
        if (childLevel < maxLevel[0]) {
            return;
        }
        if (childLevel > maxLevel[0]) {
            maxLevel[0] = childLevel;
            list.clear();
        }
        if (childLevel > 0) {
            for (Exp exp : list) {
                FunCall f;
                if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !OlapUtils.equals((MetadataElement)this.memberForExp(f.getArgs().get(0)), (MetadataElement)member)) continue;
                return;
            }
            FunCall children = new FunCall("Children", Syntax.Property);
            children.getArgs().add(this.expForMember(member));
            list.add(children);
        }
    }

    public void addMemberDescendants(List<Exp> list, Member member, Level level, int[] maxLevel) {
        int parentLevel = member.getLevel().getDepth() - 1;
        if (parentLevel < maxLevel[0]) {
            return;
        }
        if (parentLevel > maxLevel[0]) {
            maxLevel[0] = parentLevel;
            list.clear();
        }
        if (parentLevel > 0) {
            for (Exp exp : list) {
                FunCall f;
                if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Descendants") || !OlapUtils.equals((MetadataElement)this.memberForExp(f.getArgs().get(0)), (MetadataElement)member)) continue;
                return;
            }
            FunCall children = new FunCall("Descendants", Syntax.Function);
            children.getArgs().add(this.expForMember(member));
            children.getArgs().add(this.expForLevel(level));
            list.add(children);
        }
    }

    public void addLevelMembers(List<Exp> list, Level level, int[] maxLevel) {
        int depth = level.getDepth();
        if (depth < maxLevel[0]) {
            return;
        }
        if (depth > maxLevel[0]) {
            maxLevel[0] = depth;
            list.clear();
        }
        if (depth > 0) {
            for (Exp exp : list) {
                FunCall f;
                if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Members")) continue;
                return;
            }
            FunCall members = new FunCall("Members", Syntax.Property);
            members.getArgs().add(this.expForLevel(level));
            list.add(members);
        }
    }

    public Level getParentLevel(Level level) {
        Level parent = null;
        if (level.getDepth() > 0) {
            NamedList levels = level.getHierarchy().getLevels();
            for (Level l : levels) {
                if (l.getDepth() != level.getDepth() - 1) continue;
                parent = l;
                break;
            }
        }
        return parent;
    }

    public boolean isMemberInChildren(FunCall f, Member member) {
        if (member.isCalculated()) {
            return false;
        }
        Member parent = this.memberForExp(f.getArgs().get(0));
        return OlapUtils.equals((MetadataElement)parent, (MetadataElement)this.olapUtils.getTopLevelRaggedMember(member));
    }

    public boolean isMemberInDescendants(FunCall f, Member member) {
        if (member.isCalculated()) {
            return false;
        }
        Member ancestor = this.memberForExp(f.getArgs().get(0));
        Level level = this.levelForExp(f.getArgs().get(1));
        Level mLevel = member.getLevel();
        if (!OlapUtils.equals((MetadataElement)mLevel, (MetadataElement)level)) {
            return false;
        }
        if (OlapUtils.equals((MetadataElement)member, (MetadataElement)ancestor)) {
            return false;
        }
        int ancestorLevelNumber = ancestor.getLevel().getDepth();
        Member mm = member;
        while (ancestorLevelNumber < mm.getLevel().getDepth()) {
            mm = this.olapUtils.getTopLevelRaggedMember(mm);
        }
        return OlapUtils.equals((MetadataElement)mm, (MetadataElement)ancestor);
    }

    public boolean isMemberInLevel(FunCall f, Member member) {
        Level level = this.levelForExp(f.getArgs().get(0));
        return OlapUtils.equals((MetadataElement)level, (MetadataElement)member.getLevel());
    }

    public boolean isMemberInSet(FunCall f, Member member) {
        for (Exp arg : f.getArgs()) {
            Member m = this.memberForExp(arg);
            if (!OlapUtils.equals((MetadataElement)m, (MetadataElement)member)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberInUnion(FunCall f, Member member) throws UnknownExpressionException {
        for (int i = 0; i < 2; ++i) {
            FunCall fChild = (FunCall)f.getArgs().get(i);
            if (!this.isMemberInFunCall(fChild, member)) continue;
            return true;
        }
        return false;
    }
}

