/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.impl.CalcSetMode;
import org.pivot4j.impl.ExpGenerator;
import org.pivot4j.impl.PivotModelImpl;
import org.pivot4j.impl.QuaxChangeEvent;
import org.pivot4j.impl.QuaxChangeListener;
import org.pivot4j.impl.QuaxUtil;
import org.pivot4j.impl.SetExp;
import org.pivot4j.impl.UnknownExpressionException;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpNode;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.state.Bookmarkable;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quax
implements Bookmarkable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PivotModelImpl model;
    private QuaxUtil quaxUtil;
    private int nDimension;
    private List<String> hiers;
    private boolean[] containsUF;
    private List<List<String>> ufMemberLists;
    private ExpNode posTreeRoot = null;
    private int ordinal;
    private boolean qubonMode = false;
    private boolean hierarchizeNeeded = false;
    private int nHierExclude = 0;
    private CalcSetMode generateMode = CalcSetMode.Simple;
    private int generateIndex = -1;
    private Exp expGenerate = null;
    private Collection<QuaxChangeListener> changeListeners = new LinkedList<QuaxChangeListener>();
    private Map<Member, Boolean> canExpandMemberMap = new HashMap<Member, Boolean>();
    private Map<List<Member>, Boolean> canExpandPosMap = new HashMap<List<Member>, Boolean>();
    private Map<Member, Boolean> canCollapseMemberMap = new HashMap<Member, Boolean>();
    private Map<List<Member>, Boolean> canCollapsePosMap = new HashMap<List<Member>, Boolean>();
    private Map<String, Member> memberMap = new HashMap<String, Member>();
    private Map<String, Hierarchy> hierarchyMap = new HashMap<String, Hierarchy>();

    public Quax(int ordinal, PivotModelImpl model) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        this.ordinal = ordinal;
        this.model = model;
    }

    protected PivotModelImpl getModel() {
        return this.model;
    }

    protected QuaxUtil getQuaxUtil() {
        return this.quaxUtil;
    }

    public void addChangeListener(QuaxChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(QuaxChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public boolean isInitialized() {
        return this.hiers != null;
    }

    protected void fireQuaxChanged(boolean changedByNavigator) {
        QuaxChangeEvent e = new QuaxChangeEvent(this, changedByNavigator);
        ArrayList<QuaxChangeListener> copiedListeners = new ArrayList<QuaxChangeListener>(this.changeListeners);
        for (QuaxChangeListener listener : copiedListeners) {
            listener.quaxChanged(e);
        }
        this.canExpandMemberMap.clear();
        this.canExpandPosMap.clear();
        this.canCollapseMemberMap.clear();
        this.canCollapsePosMap.clear();
    }

    public void initialize(List<Position> positions) {
        this.quaxUtil = new QuaxUtil(this.model.getCube(), this.model.getMemberHierarchyCache());
        int dimCount = 0;
        this.hierarchizeNeeded = false;
        this.nHierExclude = 0;
        this.qubonMode = true;
        if (positions.isEmpty() || positions.get(0).getMembers().isEmpty()) {
            ArrayList posMembers = new ArrayList(0);
            this.setHierarchies(new ArrayList<Hierarchy>(0));
            return;
        }
        dimCount = positions.get(0).getMembers().size();
        ArrayList<List<Member>> posMembers = new ArrayList<List<Member>>(positions.size());
        for (Position position : positions) {
            posMembers.add(new ArrayList(position.getMembers()));
        }
        ArrayList<Hierarchy> hierachyList = new ArrayList<Hierarchy>(dimCount);
        List firstMembers = (List)posMembers.get(0);
        for (Member member : firstMembers) {
            hierachyList.add(member.getLevel().getHierarchy());
        }
        this.setHierarchies(hierachyList);
        this.initPositions(posMembers);
        this.posTreeRoot.walkTree(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int iDim = node.getLevel();
                if (iDim == Quax.this.nDimension) {
                    return 3;
                }
                if (node.getChildren().size() == 1) {
                    return 0;
                }
                Quax.this.qubonMode = false;
                return 3;
            }
        });
        if (this.qubonMode) {
            this.nHierExclude = dimCount - 1;
        }
    }

    private void initPositions(List<List<Member>> posMemStart) {
        if (posMemStart.isEmpty() || posMemStart.get(0).isEmpty()) {
            this.posTreeRoot = null;
            return;
        }
        this.posTreeRoot = new ExpNode(null);
        int end = this.addToPosTree(posMemStart, 0, posMemStart.size(), 0, this.posTreeRoot);
        while (end < posMemStart.size()) {
            end = this.addToPosTree(posMemStart, end, posMemStart.size(), 0, this.posTreeRoot);
        }
        this.posTreeRoot.walkTree(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int dimIndex = node.getLevel();
                if (dimIndex == Quax.this.nDimension - 1) {
                    if (node.getChildren().size() <= 1) {
                        return 1;
                    }
                    ArrayList<Exp> memArray = new ArrayList<Exp>(node.getChildren().size());
                    for (TreeNode<Exp> child : node.getChildren()) {
                        memArray.add(child.getReference());
                    }
                    node.clear();
                    FunCall oFun = new FunCall("{}", Syntax.Braces, memArray);
                    ExpNode newChild = new ExpNode(oFun);
                    node.addChild(newChild);
                    return 1;
                }
                return 0;
            }
        });
        this.containsUF = new boolean[this.nDimension];
        this.ufMemberLists = new ArrayList<List<String>>(this.nDimension);
        this.memberMap.clear();
        for (int i = 0; i < this.nDimension; ++i) {
            this.ufMemberLists.add(null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("after initPositions {}", (Object)this);
        }
    }

    protected int addToPosTree(List<List<Member>> posMembers, int startIndex, int endIndex, int dimIndex, TreeNode<Exp> parentNode) {
        int endRange;
        Member currentOfDim = posMembers.get(startIndex).get(dimIndex);
        Exp exp = this.quaxUtil.expForMember(currentOfDim);
        ExpNode newNode = new ExpNode(exp);
        parentNode.addChild(newNode);
        for (endRange = startIndex + 1; endRange < endIndex && OlapUtils.equals((MetadataElement)posMembers.get(endRange).get(dimIndex), (MetadataElement)currentOfDim); ++endRange) {
        }
        int nextDim = dimIndex + 1;
        if (nextDim < this.nDimension) {
            int endChild = this.addToPosTree(posMembers, startIndex, endRange, nextDim, newNode);
            while (endChild < endRange) {
                endChild = this.addToPosTree(posMembers, endChild, endRange, nextDim, newNode);
            }
        }
        return endRange;
    }

    public int getNDimension() {
        return this.nDimension;
    }

    public TreeNode<Exp> getPosTreeRoot() {
        return this.posTreeRoot;
    }

    public int getGenerateIndex() {
        return this.generateIndex;
    }

    public void setGenerateIndex(int i) {
        this.generateIndex = i;
    }

    public CalcSetMode getGenerateMode() {
        return this.generateMode;
    }

    public void setGenerateMode(CalcSetMode mode) {
        this.generateMode = mode;
    }

    public void resetGenerate() {
        this.generateMode = CalcSetMode.Simple;
        this.generateIndex = -1;
        this.expGenerate = null;
    }

    public int getNHierExclude() {
        return this.nHierExclude;
    }

    public void setNHierExclude(int hierExclude) {
        this.nHierExclude = hierExclude;
    }

    private boolean allowNavigate(Member member, boolean qubon) {
        Member baseMember = this.quaxUtil.getOlapUtils().getBaseRaggedMember(member);
        if (baseMember.getDepth() != member.getDepth()) {
            return false;
        }
        int iDim = this.dimIdx(member.getDimension());
        return this.allowNavigate(iDim, qubon);
    }

    private boolean allowNavigate(int dimIndex, boolean qubon) {
        if (qubon && this.generateIndex >= 0 && this.generateMode == CalcSetMode.Sticky && dimIndex == this.generateIndex) {
            return false;
        }
        return qubon || this.generateIndex < 0 || this.generateMode != CalcSetMode.Sticky || dimIndex < this.generateIndex;
    }

    public boolean isHierarchizeNeeded() {
        return this.hierarchizeNeeded;
    }

    public void setHierarchizeNeeded(boolean b) {
        this.hierarchizeNeeded = b;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public List<Hierarchy> getHierarchies() {
        if (this.hiers == null) {
            return Collections.emptyList();
        }
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(this.hiers.size());
        for (String name : this.hiers) {
            hierarchies.add(this.getHierarchy(name));
        }
        return hierarchies;
    }

    public void setHierarchies(List<Hierarchy> hierarchies) {
        this.nDimension = hierarchies.size();
        this.hiers = new ArrayList<String>(this.nDimension);
        this.hierarchyMap.clear();
        for (Hierarchy hierarchy : hierarchies) {
            this.hiers.add(hierarchy.getName());
            this.hierarchyMap.put(hierarchy.getName(), hierarchy);
        }
    }

    public boolean isQubonMode() {
        return this.qubonMode;
    }

    public void setQubonMode(boolean qubonMode) {
        this.qubonMode = qubonMode;
    }

    public int dimIdx(Dimension dim) {
        if (this.hiers == null || this.hiers.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (String name : this.hiers) {
            Hierarchy hierarchy = this.getHierarchy(name);
            if (hierarchy.getDimension().equals(dim)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void regeneratePosTree(List<Exp> sets, boolean hiersChanged) {
        if (hiersChanged) {
            this.nDimension = sets.size();
            this.hiers = new ArrayList<String>(this.nDimension);
            this.hierarchyMap.clear();
            for (Exp set : sets) {
                try {
                    Hierarchy hierarchy = this.quaxUtil.hierForExp(set);
                    this.hiers.add(hierarchy.getName());
                    this.hierarchyMap.put(hierarchy.getName(), hierarchy);
                }
                catch (UnknownExpressionException e) {
                    throw new PivotException("Unknown expression : " + e.getExpression());
                }
            }
            this.containsUF = new boolean[this.nDimension];
            this.ufMemberLists = new ArrayList<List<String>>(this.nDimension);
            this.memberMap.clear();
            for (int i = 0; i < this.nDimension; ++i) {
                this.ufMemberLists.add(null);
            }
            this.generateIndex = 0;
            this.generateMode = CalcSetMode.Simple;
        }
        if (this.posTreeRoot == null) {
            this.posTreeRoot = new ExpNode(null);
        }
        this.posTreeRoot.clear();
        ExpNode current = this.posTreeRoot;
        this.nHierExclude = 0;
        int nChildrenFound = 0;
        boolean childrenFound = false;
        for (int i = 0; i < this.nDimension; ++i) {
            ExpNode newNode;
            Exp set = sets.get(i);
            if (set instanceof SetExp) {
                SetExp setx = (SetExp)set;
                newNode = new ExpNode(setx.getExpression());
                CalcSetMode mode = setx.getMode();
                if (mode != CalcSetMode.Simple) {
                    this.generateMode = mode;
                    this.generateIndex = i;
                    this.expGenerate = setx.getExpression();
                }
            } else {
                boolean bChildrenFound = this.findChildrenCall(set, 0);
                if (bChildrenFound) {
                    childrenFound = true;
                    nChildrenFound = i + 1;
                }
                newNode = new ExpNode(set);
                if (this.generateIndex == i && this.generateMode == CalcSetMode.Sticky && !set.equals(this.expGenerate)) {
                    this.resetGenerate();
                }
            }
            ((TreeNode)current).addChild(newNode);
            current = newNode;
            if (this.quaxUtil.canHandle((Exp)newNode.getReference())) continue;
            this.containsUF[i] = true;
        }
        this.qubonMode = true;
        this.nHierExclude = this.nDimension - nChildrenFound;
        if (!childrenFound) {
            this.hierarchizeNeeded = false;
        }
        this.fireQuaxChanged(hiersChanged);
    }

    private boolean findChildrenCall(Exp oExp, int level) {
        if (!this.quaxUtil.isFunCall(oExp)) {
            return false;
        }
        if (level > 0 && this.quaxUtil.isFunCallTo(oExp, "children")) {
            return true;
        }
        int argCount = this.quaxUtil.funCallArgCount(oExp);
        for (int i = 0; i < argCount; ++i) {
            if (!this.findChildrenCall(this.quaxUtil.funCallArg(oExp, i), level + 1)) continue;
            return true;
        }
        return false;
    }

    public boolean canExpand(List<Member> memberPath) {
        List<Member> target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(memberPath);
        int dimIndex = target.size() - 1;
        if (!this.allowNavigate(dimIndex, false)) {
            return false;
        }
        if (this.canExpandPosMap.containsKey(target)) {
            Boolean bCanExpand = this.canExpandPosMap.get(target);
            return bCanExpand;
        }
        boolean childFound = this.checkChildPosition(target);
        this.canExpandPosMap.put(target, !childFound);
        return !childFound;
    }

    public boolean canExpand(Member member) {
        Member target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(member);
        if (!this.allowNavigate(target, false)) {
            return false;
        }
        if (this.canExpandMemberMap.containsKey(target)) {
            return this.canExpandMemberMap.get(target);
        }
        boolean found = !this.findMemberChild(target);
        this.canExpandMemberMap.put(target, found);
        return found;
    }

    public void expand(List<Member> memberPath) {
        ExpNode newNode;
        List<Member> target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(memberPath);
        if (this.qubonMode) {
            this.resolveUnions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Expand after resolveUnions {}", (Object)this);
            }
        }
        int dimIndex = target.size() - 1;
        ExpNode bestNode = this.findBestNode(target);
        int bestNodeIndex = bestNode.getLevel() - 1;
        List<Object> tailNodeList = target.size() < this.nDimension ? this.collectTailNodes(this.posTreeRoot, target) : Collections.emptyList();
        Exp oMember = this.quaxUtil.expForMember(target.get(dimIndex));
        FunCall fChildren = new FunCall("Children", Syntax.Property);
        fChildren.getArgs().add(oMember);
        ExpNode parent = bestNode;
        if (bestNodeIndex == dimIndex) {
            parent = ((TreeNode)bestNode).getParent();
        } else {
            for (int i = bestNodeIndex + 1; i < target.size() - 1; ++i) {
                oMember = this.quaxUtil.expForMember(target.get(i));
                newNode = new ExpNode(oMember);
                ((TreeNode)parent).addChild(newNode);
                parent = newNode;
            }
        }
        int n = this.nDimension - dimIndex - 1;
        if (n < this.nHierExclude) {
            this.nHierExclude = n;
        }
        newNode = new ExpNode(fChildren);
        ((TreeNode)parent).addChild(newNode);
        if (target.size() < this.nDimension) {
            for (TreeNode treeNode : tailNodeList) {
                ((TreeNode)newNode).addChild(treeNode.deepCopy());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After expand {}", (Object)this);
        }
        this.qubonMode = false;
        this.hierarchizeNeeded = true;
        this.fireQuaxChanged(false);
    }

    public void expand(Member member) {
        final Member target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(member);
        if (this.qubonMode) {
            this.resolveUnions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Expand after resolveUnions {}", (Object)this);
            }
        }
        this.nHierExclude = 0;
        final int dimIndex = this.dimIdx(target.getDimension());
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.quaxUtil.equalMember(oExp, target)) {
                        nodesForMember.add((ExpNode)node);
                    }
                } else if (Quax.this.isMemberInFunCall(oExp, target, dimIndex)) {
                    nodesForMember.add((ExpNode)node);
                }
                return 1;
            }
        });
        Exp oMember = this.quaxUtil.expForMember(target);
        FunCall fChildren = new FunCall("Children", Syntax.Property);
        fChildren.getArgs().add(oMember);
        for (ExpNode node : nodesForMember) {
            ExpNode newNode = new ExpNode(fChildren);
            for (TreeNode child : node.getChildren()) {
                newNode.addChild(child.deepCopy());
            }
            ExpNode parent = node.getParent();
            ((TreeNode)parent).addChild(newNode);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After expand member {}", (Object)this);
        }
        this.hierarchizeNeeded = true;
        this.fireQuaxChanged(false);
    }

    public boolean canCollapse(List<Member> memberPath) {
        List<Member> target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(memberPath);
        int dimIndex = target.size() - 1;
        if (!this.allowNavigate(dimIndex, false)) {
            return false;
        }
        if (this.canCollapsePosMap.containsKey(target)) {
            return this.canCollapsePosMap.get(target);
        }
        boolean childFound = this.checkChildPosition(target);
        this.canCollapsePosMap.put(target, childFound);
        return childFound;
    }

    public void collapse(List<Member> memberPath) {
        int i;
        final List<Member> target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(memberPath);
        if (this.qubonMode) {
            this.resolveUnions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Collapse after resolveUnions {}", (Object)this);
            }
        }
        final int dimIndex = target.size() - 1;
        int pathSize = target.size();
        final ArrayList splitLists = new ArrayList(pathSize);
        for (i = 0; i < pathSize; ++i) {
            splitLists.add(new ArrayList());
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                Exp oExp = node.getReference();
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    if (Quax.this.quaxUtil.isMember(oExp)) {
                        if (Quax.this.quaxUtil.equalMember(oExp, (Member)target.get(nodeIndex))) {
                            return 0;
                        }
                        return 1;
                    }
                    if (Quax.this.isMemberInFunCall(oExp, (Member)target.get(nodeIndex), nodeIndex)) {
                        return 0;
                    }
                    return 1;
                }
                boolean found = false;
                if (Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.quaxUtil.isDescendant((Member)target.get(dimIndex), oExp)) {
                        found = true;
                    }
                } else if (Quax.this.isChildOfMemberInFunCall(oExp, (Member)target.get(dimIndex), dimIndex)) {
                    found = true;
                }
                if (found) {
                    int level = node.getLevel();
                    TreeNode<Exp> currentNode = node;
                    while (level > 0) {
                        List list;
                        Exp o = currentNode.getReference();
                        if (!Quax.this.quaxUtil.isMember(o) && !(list = (List)splitLists.get(level - 1)).contains(currentNode)) {
                            list.add((ExpNode)currentNode);
                        }
                        currentNode = currentNode.getParent();
                        level = currentNode.getLevel();
                    }
                }
                return 1;
            }
        });
        for (i = pathSize - 1; i >= 0; --i) {
            List list = (List)splitLists.get(i);
            Member member = target.get(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExpNode node = (ExpNode)iterator.next();
                this.splitFunCall(node, member, i);
            }
        }
        final ArrayList removeList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                Exp oExp = node.getReference();
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    if (Quax.this.quaxUtil.isMember(oExp)) {
                        if (Quax.this.quaxUtil.equalMember(oExp, (Member)target.get(nodeIndex))) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (nodeIndex == dimIndex) {
                    if (!Quax.this.quaxUtil.isMember(oExp)) {
                        if (Quax.this.quaxUtil.isFunCallTo(oExp, "Children")) {
                            Exp oMember = Quax.this.quaxUtil.funCallArg(oExp, 0);
                            if (Quax.this.quaxUtil.expForMember((Member)target.get(dimIndex)).equals(oMember) || Quax.this.quaxUtil.isDescendant((Member)target.get(dimIndex), oMember)) {
                                removeList.add(node);
                            }
                        } else if (Quax.this.quaxUtil.isFunCallTo(oExp, "{}")) {
                            int argCount = Quax.this.quaxUtil.funCallArgCount(oExp);
                            ArrayList<Exp> removeMembers = new ArrayList<Exp>();
                            for (int i = 0; i < argCount; ++i) {
                                Exp oSetMember = Quax.this.quaxUtil.funCallArg(oExp, i);
                                if (!Quax.this.quaxUtil.isDescendant((Member)target.get(dimIndex), oSetMember)) continue;
                                removeMembers.add(oSetMember);
                            }
                            int nRemove = removeMembers.size();
                            if (nRemove == argCount) {
                                removeList.add(node);
                            } else if (nRemove > 0) {
                                Exp[] remaining = new Exp[argCount - nRemove];
                                int j = 0;
                                for (int i = 0; i < argCount; ++i) {
                                    Exp oSetMember = Quax.this.quaxUtil.funCallArg(oExp, i);
                                    if (removeMembers.contains(oSetMember)) continue;
                                    remaining[j++] = oSetMember;
                                }
                                if (remaining.length == 1) {
                                    node.setReference(remaining[0]);
                                } else {
                                    FunCall newSet = new FunCall("{}", Syntax.Braces);
                                    for (Exp arg : remaining) {
                                        newSet.getArgs().add(arg);
                                    }
                                    node.setReference(newSet);
                                }
                            }
                        } else if (Quax.this.quaxUtil.isFunCallTo(oExp, "Union")) {
                            Exp oRemain = Quax.this.removeDescendantsFromFunCall(oExp, (Member)target.get(dimIndex), dimIndex);
                            if (oRemain == null) {
                                removeList.add(node);
                            } else {
                                node.setReference(oRemain);
                            }
                        }
                        return 1;
                    }
                    if (Quax.this.quaxUtil.isMember(oExp) && Quax.this.quaxUtil.isDescendant((Member)target.get(dimIndex), oExp)) {
                        removeList.add(node);
                    }
                    return 1;
                }
                throw new PivotException("Unexpected tree node level " + nodeIndex + " " + Quax.this.quaxUtil.memberString(target));
            }
        });
        for (TreeNode nodeToRemove : removeList) {
            this.removePathToNode(nodeToRemove);
        }
        int n = this.nDimension - dimIndex - 1;
        if (n < this.nHierExclude) {
            this.nHierExclude = n;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After collapse {}", (Object)this);
        }
        this.fireQuaxChanged(false);
    }

    public boolean canCollapse(Member member) {
        Member target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(member);
        if (!this.allowNavigate(target, false)) {
            return false;
        }
        if (this.canCollapseMemberMap.containsKey(target)) {
            return this.canCollapseMemberMap.get(target);
        }
        boolean found = this.findMemberChild(target);
        this.canCollapseMemberMap.put(target, found);
        return found;
    }

    public void collapse(Member member) {
        final Member target = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(member);
        if (this.qubonMode) {
            this.resolveUnions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("collapse member after resolveUnions " + this.toString());
            }
        }
        final int dimIndex = this.dimIdx(target.getDimension());
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.quaxUtil.isDescendant(target, oExp)) {
                        nodesForMember.add(node);
                    }
                } else if (Quax.this.isDescendantOfMemberInFunCall(oExp, target, nodeIndex)) {
                    nodesForMember.add(node);
                }
                return 1;
            }
        });
        for (TreeNode node : nodesForMember) {
            Exp oExp = (Exp)node.getReference();
            if (this.quaxUtil.isMember(oExp)) {
                this.removePathToNode(node);
                continue;
            }
            Exp oComplement = this.removeDescendantsFromFunCall(oExp, target, dimIndex);
            if (oComplement == null) {
                this.removePathToNode(node);
                continue;
            }
            node.setReference(oComplement);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After collapse {}", (Object)this);
        }
        this.fireQuaxChanged(false);
    }

    public boolean canDrillDown(Member member) {
        return this.allowNavigate(member, true);
    }

    public void drillDown(Member member) {
        int dimIndex = this.dimIdx(member.getDimension());
        ArrayList<Exp> sets = new ArrayList<Exp>(this.nDimension);
        Exp oMember = this.quaxUtil.expForMember(member);
        FunCall fChildren = new FunCall("Children", Syntax.Property);
        fChildren.getArgs().add(oMember);
        for (int i = 0; i < this.nDimension; ++i) {
            if (i == dimIndex) {
                sets.add(fChildren);
                continue;
            }
            sets.add(this.genExpForDim(i));
        }
        this.regeneratePosTree(sets, false);
    }

    public boolean canDrillUp(Hierarchy hierarchy) {
        final int dimIndex = this.dimIdx(hierarchy.getDimension());
        if (!this.allowNavigate(dimIndex, true)) {
            return false;
        }
        int result = this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.isFunCallNotTopLevel(oExp, nodeIndex)) {
                        return 3;
                    }
                    return 1;
                }
                if (Quax.this.quaxUtil.levelDepthForMember(oExp) > 0) {
                    return 3;
                }
                return 1;
            }
        });
        return result == 3;
    }

    public void drillUp(Hierarchy hierarchy) {
        int dimIndex = this.dimIdx(hierarchy.getDimension());
        ArrayList<Exp> sets = new ArrayList<Exp>(this.nDimension);
        for (int i = 0; i < this.nDimension; ++i) {
            if (i == dimIndex) {
                sets.add(this.drillupExp(dimIndex, hierarchy));
                continue;
            }
            sets.add(this.genExpForDim(i));
        }
        this.regeneratePosTree(sets, false);
    }

    public Exp genExp(boolean genHierarchize) {
        Exp exp = this.generateMode != CalcSetMode.Simple && this.generateIndex > 0 ? this.genGenerateExp(genHierarchize) : this.genNormalExp(genHierarchize);
        if (this.posTreeRoot.getChildCount() == 0 && OlapUtils.isEmptySetSupported(this.model.getMetadata())) {
            exp = new FunCall("{}", Syntax.Braces);
        }
        return exp;
    }

    private Exp genNormalExp(boolean genHierarchize) {
        ExpGenerator expGenerator = new ExpGenerator();
        if (!genHierarchize) {
            expGenerator.init(this.posTreeRoot, this.hiers.size(), this.quaxUtil);
            return expGenerator.generate();
        }
        if (this.nHierExclude == 0) {
            expGenerator.init(this.posTreeRoot, this.hiers.size(), this.quaxUtil);
            Exp exp = expGenerator.generate();
            FunCall call = new FunCall("Hierarchize", Syntax.Function);
            call.getArgs().add(exp);
            return call;
        }
        return this.genLeftRight(expGenerator, this.nDimension - this.nHierExclude, this.nHierExclude);
    }

    private Exp genLeftRight(ExpGenerator expGenerator, int leftDepth, int rightDepth) {
        int i;
        FunCall leftExp = null;
        if (leftDepth > 0) {
            ExpNode leftRoot = this.posTreeRoot.deepCopyPrune(leftDepth);
            leftRoot.setReference(null);
            ArrayList<Hierarchy> leftHiers = new ArrayList<Hierarchy>(leftDepth);
            for (i = 0; i < leftDepth; ++i) {
                leftHiers.add(this.getHierarchy(this.hiers.get(i)));
            }
            expGenerator.init(leftRoot, leftHiers.size(), this.quaxUtil);
            leftExp = new FunCall("Hierarchize", Syntax.Function);
            leftExp.getArgs().add(expGenerator.generate());
        }
        Exp rightExp = null;
        ArrayList<Hierarchy> rightHiers = new ArrayList<Hierarchy>(rightDepth);
        for (i = 0; i < rightDepth; ++i) {
            rightHiers.add(this.getHierarchy(this.hiers.get(leftDepth + i)));
        }
        ExpNode rightRoot = new ExpNode(null);
        TreeNode current = this.posTreeRoot;
        for (int i2 = 0; i2 < leftDepth; ++i2) {
            List list = current.getChildren();
            current = list.get(0);
        }
        List list = current.getChildren();
        for (TreeNode treeNode : list) {
            rightRoot.addChild(treeNode.deepCopy());
        }
        expGenerator.init(rightRoot, rightHiers.size(), this.quaxUtil);
        rightExp = expGenerator.generate();
        if (leftExp == null) {
            return rightExp;
        }
        FunCall exp = new FunCall("CrossJoin", Syntax.Function);
        exp.getArgs().add(leftExp);
        exp.getArgs().add(rightExp);
        return exp;
    }

    private Exp genGenerateExp(boolean genHierarchize) {
        ExpGenerator expGenerator = new ExpGenerator();
        if (this.nDimension - this.generateIndex > this.nHierExclude && this.logger.isWarnEnabled()) {
            this.logger.warn("Unexpected values: nHierExclude={}, generateIndex={}", (Object)this.nHierExclude, (Object)this.generateIndex);
        }
        Exp leftExp = null;
        if (genHierarchize && this.nHierExclude > this.nDimension - this.generateIndex && this.nHierExclude < this.nDimension) {
            int leftDepth = this.nDimension - this.nHierExclude;
            int rightDepth = this.generateIndex - leftDepth;
            leftExp = this.genLeftRight(expGenerator, leftDepth, rightDepth);
        } else {
            ExpNode leftRoot = this.posTreeRoot.deepCopyPrune(this.generateIndex);
            leftRoot.setReference(null);
            ArrayList<Hierarchy> leftHiers = new ArrayList<Hierarchy>(this.generateIndex);
            for (int i = 0; i < this.generateIndex; ++i) {
                leftHiers.add(this.getHierarchy(this.hiers.get(i)));
            }
            expGenerator.init(leftRoot, leftHiers.size(), this.quaxUtil);
            leftExp = expGenerator.generate();
            if (genHierarchize) {
                leftExp = new FunCall("Hierarchize", Syntax.Function);
                ((FunCall)leftExp).getArgs().add(leftExp);
            }
        }
        TreeNode topCountNode = this.posTreeRoot;
        for (int i = 0; i <= this.generateIndex; ++i) {
            List children = topCountNode.getChildren();
            topCountNode = children.get(0);
        }
        Exp topcount = (Exp)topCountNode.getReference();
        Exp origTopcountSet = this.quaxUtil.funCallArg(topcount, 0);
        Exp currentMembersTuple = this.genCurrentTuple();
        FunCall ocj = new FunCall("Crossjoin", Syntax.Function);
        ocj.getArgs().add(currentMembersTuple);
        ocj.getArgs().add(origTopcountSet);
        String fun = this.quaxUtil.funCallName(topcount);
        int n = this.quaxUtil.funCallArgCount(topcount);
        ArrayList<Exp> args = new ArrayList<Exp>(n);
        args.add(ocj);
        for (int i = 1; i < n; ++i) {
            args.add(this.quaxUtil.funCallArg(topcount, i));
        }
        FunCall newTopCount = new FunCall(fun, Syntax.Function, args);
        FunCall oGenerate = new FunCall("Generate", Syntax.Function);
        oGenerate.getArgs().add(leftExp);
        oGenerate.getArgs().add(newTopCount);
        if (this.generateIndex + 1 == this.nDimension) {
            return oGenerate;
        }
        int nRight = this.nDimension - this.generateIndex - 1;
        Hierarchy[] rightHiers = new Hierarchy[nRight];
        for (int i = 1; i <= nRight; ++i) {
            rightHiers[nRight - i] = this.getHierarchy(this.hiers.get(this.nDimension - i));
        }
        ExpNode root = new ExpNode(null);
        List list = topCountNode.getChildren();
        for (TreeNode node : list) {
            root.addChild(node.deepCopy());
        }
        expGenerator.init(root, rightHiers.length, this.quaxUtil);
        Exp rightExp = expGenerator.generate();
        FunCall exp = new FunCall("CrossJoin", Syntax.Function);
        exp.getArgs().add(oGenerate);
        exp.getArgs().add(rightExp);
        return exp;
    }

    private Exp genCurrentTuple() {
        ArrayList<Exp> currentsOfDim = new ArrayList<Exp>(this.generateIndex);
        for (String name : this.hiers) {
            Hierarchy hierarchy = this.getHierarchy(name);
            Dimension dim = hierarchy.getDimension();
            FunCall call = new FunCall("CurrentMember", Syntax.Property);
            call.getArgs().add(this.quaxUtil.expForDim(dim));
            currentsOfDim.add(call);
        }
        Exp oTuple = this.generateIndex > 1 ? new FunCall("()", Syntax.Parentheses, currentsOfDim) : (Exp)currentsOfDim.get(0);
        FunCall oSet = new FunCall("{}", Syntax.Braces);
        oSet.getArgs().add(oTuple);
        return oSet;
    }

    private boolean checkChildPosition(List<Member> path) {
        final List<Member> memberPath = this.quaxUtil.getOlapUtils().wrapRaggedIfNecessary(path);
        int result = this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int dimIndex = memberPath.size() - 1;
                int nodeIndex = node.getLevel() - 1;
                Exp oExp = node.getReference();
                if (nodeIndex < dimIndex) {
                    if (Quax.this.quaxUtil.isMember(oExp)) {
                        if (Quax.this.quaxUtil.equalMember(oExp, (Member)memberPath.get(nodeIndex))) {
                            return 0;
                        }
                        return 1;
                    }
                    if (Quax.this.isMemberInFunCall(oExp, (Member)memberPath.get(nodeIndex), nodeIndex)) {
                        return 0;
                    }
                    return 1;
                }
                if (Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.quaxUtil.checkParent((Member)memberPath.get(nodeIndex), oExp)) {
                        return 3;
                    }
                    return 1;
                }
                if (Quax.this.isChildOfMemberInFunCall(oExp, (Member)memberPath.get(nodeIndex), nodeIndex)) {
                    return 3;
                }
                return 1;
            }
        });
        return result == 3;
    }

    private void resolveUnions() {
        final ArrayList<List<Exp>> setLists = new ArrayList<List<Exp>>(this.nDimension);
        for (int i = 0; i < this.nDimension; ++i) {
            setLists.add(new ArrayList());
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp)) {
                    Quax.this.funToList(oExp, (List)setLists.get(nodeIndex));
                } else {
                    ((List)setLists.get(nodeIndex)).add(oExp);
                }
                return 0;
            }
        });
        this.posTreeRoot = new ExpNode(null);
        this.crossJoinTree(setLists, this.posTreeRoot, 0);
        this.qubonMode = false;
    }

    private TreeNode<Exp> findBestNode(final List<Member> memberPath) {
        final TreeNode[] bestNode = new TreeNode[]{this.posTreeRoot};
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int dimIndex = memberPath.size() - 1;
                int nodeIndex = node.getLevel() - 1;
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp)) {
                    return 1;
                }
                if (Quax.this.quaxUtil.equalMember(oExp, (Member)memberPath.get(nodeIndex))) {
                    if (nodeIndex == dimIndex) {
                        bestNode[0] = node;
                        return 3;
                    }
                    bestNode[0] = node;
                    return 0;
                }
                return 1;
            }
        });
        return bestNode[0];
    }

    private List<TreeNode<Exp>> collectTailNodes(TreeNode<Exp> startNode, final List<Member> memberPath) {
        final ArrayList<TreeNode<Exp>> tailNodes = new ArrayList<TreeNode<Exp>>();
        startNode.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int dimIndex = memberPath.size() - 1;
                int nodeIndex = node.getLevel() - 1;
                Exp oExp = node.getReference();
                boolean match = false;
                if (Quax.this.quaxUtil.isMember(oExp)) {
                    if (Quax.this.quaxUtil.equalMember(oExp, (Member)memberPath.get(nodeIndex))) {
                        match = true;
                    }
                } else if (Quax.this.isMemberInFunCall(oExp, (Member)memberPath.get(nodeIndex), nodeIndex)) {
                    match = true;
                }
                if (match) {
                    if (nodeIndex == dimIndex) {
                        tailNodes.addAll(node.getChildren());
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
        });
        return tailNodes;
    }

    private boolean findMemberChild(final Member member) {
        final int iDim = this.dimIdx(member.getDimension());
        int result = this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (Quax.this.quaxUtil.isMember(oExp) ? Quax.this.quaxUtil.checkParent(member, oExp) : Quax.this.isChildOfMemberInFunCall(oExp, member, nodeIndex)) {
                    return 3;
                }
                return 1;
            }
        });
        return result == 3;
    }

    private void crossJoinTree(List<List<Exp>> setLists, TreeNode<Exp> currentNode, int dimIndex) {
        for (Exp oExp : setLists.get(dimIndex)) {
            ExpNode newNode = new ExpNode(oExp);
            if (dimIndex < this.nDimension - 1) {
                this.crossJoinTree(setLists, newNode, dimIndex + 1);
            }
            currentNode.addChild(newNode);
        }
    }

    private void splitFunCall(ExpNode funCall, Member member, int hierIndex) {
        Exp oExp = (Exp)funCall.getReference();
        if (!this.isMemberInFunCall(oExp, member, funCall.getLevel() - 1)) {
            return;
        }
        Exp oComplement = this.createComplement(oExp, member, hierIndex);
        if (oComplement == null) {
            funCall.setReference(this.quaxUtil.expForMember(member));
            return;
        }
        ExpNode newNodeComplement = new ExpNode(oComplement);
        ExpNode newNodeMember = new ExpNode(this.quaxUtil.expForMember(member));
        for (TreeNode child : funCall.getChildren()) {
            newNodeComplement.addChild(child.deepCopy());
            newNodeMember.addChild(child.deepCopy());
        }
        ExpNode insert = funCall.getParent();
        funCall.remove();
        ((TreeNode)insert).addChild(newNodeComplement);
        ((TreeNode)insert).addChild(newNodeMember);
    }

    private void removePathToNode(TreeNode<Exp> nodeToRemove) {
        if (nodeToRemove.getParent().getChildren().size() > 1) {
            nodeToRemove.remove();
        } else {
            TreeNode<Exp> parent = nodeToRemove.getParent();
            while (parent.getParent().getChildren().size() == 1) {
                parent = parent.getParent();
            }
            if (parent.getLevel() > 0) {
                parent.remove();
            }
        }
    }

    public Exp genExpForDim(int dimIndex) {
        int start;
        Exp set;
        if (this.generateIndex >= 0 && this.generateIndex == dimIndex && this.generateMode != CalcSetMode.Simple) {
            TreeNode topCountNode = this.posTreeRoot.getChildren().get(0);
            for (int i = 0; i < this.generateIndex; ++i) {
                List children = topCountNode.getChildren();
                topCountNode = children.get(0);
            }
            Exp topcount = (Exp)topCountNode.getReference();
            SetExp setexp = new SetExp(this.generateMode, topcount, this.getHierarchy(this.hiers.get(dimIndex)));
            return setexp;
        }
        List<Exp> funCallList = this.collectFunCalls(dimIndex);
        List<Exp> memberList = this.collectMembers(dimIndex);
        this.cleanupMemberList(funCallList, memberList, dimIndex);
        if (funCallList.isEmpty() && memberList.size() == 1) {
            return memberList.get(0);
        }
        FunCall mSet = null;
        if (!memberList.isEmpty()) {
            mSet = new FunCall("{}", Syntax.Braces, memberList);
        }
        if (funCallList.isEmpty()) {
            return mSet;
        }
        if (funCallList.size() == 1 && mSet == null) {
            return funCallList.get(0);
        }
        if (mSet != null) {
            set = mSet;
            start = 0;
        } else {
            set = funCallList.get(0);
            start = 1;
        }
        for (int j = start; j < funCallList.size(); ++j) {
            FunCall call = new FunCall("Union", Syntax.Function);
            call.getArgs().add(set);
            call.getArgs().add(funCallList.get(j));
            set = call;
        }
        return set;
    }

    private Exp drillupExp(int dimIndex, Hierarchy hierarchy) {
        int[] maxLevel = new int[]{0};
        List<Exp> drillupList = this.collectDrillup(dimIndex, maxLevel);
        Exp expForHier = null;
        if (maxLevel[0] == 0) {
            expForHier = this.quaxUtil.topLevelMembers(hierarchy, false);
        } else if (drillupList.size() == 1) {
            expForHier = drillupList.get(0);
        } else {
            for (Exp oExp : drillupList) {
                if (expForHier == null) {
                    expForHier = oExp;
                    continue;
                }
                FunCall call = new FunCall("Union", Syntax.Function);
                call.getArgs().add(expForHier);
                call.getArgs().add(oExp);
                expForHier = call;
            }
        }
        return expForHier;
    }

    private List<Exp> collectDrillup(final int dimIndex, final int[] maxLevel) {
        final ArrayList<Exp> drillupList = new ArrayList<Exp>();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp)) {
                    Quax.this.addFunCallToDrillup(drillupList, oExp, maxLevel);
                } else {
                    Member m = Quax.this.quaxUtil.memberForExp(oExp);
                    Quax.this.quaxUtil.addMemberUncles(drillupList, m, maxLevel);
                }
                return 1;
            }
        });
        return drillupList;
    }

    private List<Exp> collectFunCalls(final int dimIndex) {
        if (this.posTreeRoot == null) {
            return Collections.emptyList();
        }
        final ArrayList<Exp> funCalls = new ArrayList<Exp>();
        final ArrayList uniqueNames = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                String unique;
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp) && !uniqueNames.contains(unique = Quax.this.quaxUtil.funString(oExp).toString())) {
                    funCalls.add(oExp);
                    uniqueNames.add(unique);
                }
                return 1;
            }
        });
        return funCalls;
    }

    private void cleanupMemberList(List<Exp> funCalls, List<Exp> memberList, int dimIndex) {
        if (!funCalls.isEmpty() && !memberList.isEmpty()) {
            Iterator<Exp> itMem = memberList.iterator();
            block0: while (itMem.hasNext()) {
                Exp oMember = itMem.next();
                Member m = this.quaxUtil.memberForExp(oMember);
                for (Exp oFun : funCalls) {
                    if (!this.isMemberInFunCall(oFun, m, dimIndex)) continue;
                    itMem.remove();
                    continue block0;
                }
            }
        }
    }

    private List<Exp> collectMembers(final int dimIndex) {
        if (this.posTreeRoot == null) {
            return Collections.emptyList();
        }
        final ArrayList<Exp> memberList = new ArrayList<Exp>();
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                if (nodeIndex < dimIndex) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (Quax.this.quaxUtil.isMember(oExp) && !memberList.contains(oExp)) {
                    memberList.add(oExp);
                }
                return 1;
            }
        });
        return memberList;
    }

    private void addFunCallToDrillup(List<Exp> list, Exp oFun, int[] maxLevel) {
        if (this.quaxUtil.isFunCallTo(oFun, "Union")) {
            for (int i = 0; i < 2; ++i) {
                Exp fExp = this.quaxUtil.funCallArg(oFun, i);
                this.addFunCallToDrillup(list, fExp, maxLevel);
            }
        } else if (this.quaxUtil.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.quaxUtil.funCallArgCount(oFun); ++i) {
                Exp oMember = this.quaxUtil.funCallArg(oFun, i);
                Member m = this.quaxUtil.memberForExp(oMember);
                this.quaxUtil.addMemberUncles(list, m, maxLevel);
            }
        } else if (this.quaxUtil.isFunCallTo(oFun, "Children")) {
            Exp oMember = this.quaxUtil.funCallArg(oFun, 0);
            Member m = this.quaxUtil.memberForExp(oMember);
            this.quaxUtil.addMemberSiblings(list, m, maxLevel);
        } else if (this.quaxUtil.isFunCallTo(oFun, "Descendants")) {
            Exp oMember = this.quaxUtil.funCallArg(oFun, 0);
            Member m = this.quaxUtil.memberForExp(oMember);
            Exp oLevel = this.quaxUtil.funCallArg(oFun, 1);
            Level lev = this.quaxUtil.levelForExp(oLevel);
            int level = m.getLevel().getDepth();
            int levlev = lev.getDepth();
            if (levlev == level + 1) {
                this.quaxUtil.addMemberSiblings(list, m, maxLevel);
            } else if (levlev == level + 2) {
                this.quaxUtil.addMemberChildren(list, m, maxLevel);
            } else {
                Level parentLevel = this.quaxUtil.getParentLevel(lev);
                this.quaxUtil.addMemberDescendants(list, m, parentLevel, maxLevel);
            }
        } else if (this.quaxUtil.isFunCallTo(oFun, "Members")) {
            Exp oLevel = this.quaxUtil.funCallArg(oFun, 0);
            Level lev = this.quaxUtil.levelForExp(oLevel);
            int levlev = lev.getDepth();
            if (levlev == 0) {
                return;
            }
            Level parentLevel = this.quaxUtil.getParentLevel(lev);
            this.quaxUtil.addLevelMembers(list, parentLevel, maxLevel);
        } else {
            Exp oFun2 = this.quaxUtil.funCallArg(oFun, 0);
            this.addFunCallToDrillup(list, oFun2, maxLevel);
        }
    }

    private void funToList(Exp oFun, List<Exp> list) {
        if (this.quaxUtil.isFunCallTo(oFun, "Union")) {
            Exp arg0 = this.quaxUtil.funCallArg(oFun, 0);
            Exp arg1 = this.quaxUtil.funCallArg(oFun, 1);
            this.funToList(arg0, list);
            this.funToList(arg1, list);
        } else if (this.quaxUtil.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.quaxUtil.funCallArgCount(oFun); ++i) {
                Exp oMember = this.quaxUtil.funCallArg(oFun, i);
                list.add(oMember);
            }
        } else {
            list.add(oFun);
        }
    }

    private boolean isMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean result = false;
        try {
            result = this.quaxUtil.isMemberInFunCall(oExp, member);
        }
        catch (UnknownExpressionException e) {
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            result = this.ufMemberLists.get(hierIndex).contains(member);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFunCallNotTopLevel(Exp oExp, int hierIndex) {
        boolean result = false;
        try {
            return this.quaxUtil.isFunCallNotTopLevel(oExp);
        }
        catch (UnknownExpressionException e) {
            String name;
            Member member;
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            List<String> members = this.ufMemberLists.get(hierIndex);
            Iterator<String> iterator = members.iterator();
            do {
                if (!iterator.hasNext()) return result;
            } while ((member = this.getMember(name = iterator.next())).getLevel().getDepth() <= 0);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChildOfMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean result = false;
        try {
            return this.quaxUtil.isChildOfMemberInFunCall(oExp, member);
        }
        catch (UnknownExpressionException e) {
            String name;
            Member m;
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            List<String> members = this.ufMemberLists.get(hierIndex);
            Iterator<String> iterator = members.iterator();
            do {
                if (!iterator.hasNext()) return result;
            } while (!this.quaxUtil.checkParent(member, this.quaxUtil.expForMember(m = this.getMember(name = iterator.next()))));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDescendantOfMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean result = false;
        try {
            return this.quaxUtil.isDescendantOfMemberInFunCall(oExp, member);
        }
        catch (UnknownExpressionException e) {
            String name;
            Member m;
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            List<String> members = this.ufMemberLists.get(hierIndex);
            Iterator<String> iterator = members.iterator();
            do {
                if (!iterator.hasNext()) return result;
            } while (!this.quaxUtil.checkDescendantM(member, m = this.getMember(name = iterator.next())));
            return true;
        }
    }

    private Exp removeDescendantsFromFunCall(Exp oFun, Member member, int hierIndex) {
        try {
            return this.removeDescendantsFromFunCall(oFun, member);
        }
        catch (UnknownExpressionException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unkown FunCall {}", (Object)this.quaxUtil.funCallName(oFun));
            }
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            ArrayList<Exp> newList = new ArrayList<Exp>();
            List<String> members = this.ufMemberLists.get(hierIndex);
            for (String name : members) {
                Member m = this.getMember(name);
                if (this.quaxUtil.checkDescendantM(member, m)) continue;
                newList.add(this.quaxUtil.expForMember(m));
            }
            return new FunCall("{}", Syntax.Braces, newList);
        }
    }

    private Exp removeDescendantsFromFunCall(Exp oFun, Member member) throws UnknownExpressionException {
        if (this.quaxUtil.isFunCallTo(oFun, "Children")) {
            return null;
        }
        if (this.quaxUtil.isFunCallTo(oFun, "Descendants")) {
            return null;
        }
        if (this.quaxUtil.isFunCallTo(oFun, "Members")) {
            List members;
            Level level = member.getLevel();
            try {
                members = level.getMembers();
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
            ArrayList<Member> remainder = new ArrayList<Member>(members.size());
            for (Member m : members) {
                if (this.quaxUtil.isDescendant(member, m)) continue;
                remainder.add(m);
            }
            return this.quaxUtil.createMemberSet(remainder);
        }
        if (this.quaxUtil.isFunCallTo(oFun, "{}")) {
            ArrayList<Member> remainder = new ArrayList<Member>();
            for (int i = 0; i < this.quaxUtil.funCallArgCount(oFun); ++i) {
                Exp arg = this.quaxUtil.funCallArg(oFun, i);
                if (this.quaxUtil.isDescendant(member, arg)) continue;
                remainder.add(this.quaxUtil.memberForExp(arg));
            }
            return this.quaxUtil.createMemberSet(remainder);
        }
        if (this.quaxUtil.isFunCallTo(oFun, "Union")) {
            FunCall call;
            Exp[] uargs = new Exp[]{this.removeDescendantsFromFunCall(this.quaxUtil.funCallArg(oFun, 0), member), this.removeDescendantsFromFunCall(this.quaxUtil.funCallArg(oFun, 0), member)};
            if (uargs[0] == null && uargs[1] == null) {
                return null;
            }
            if (uargs[1] == null) {
                return uargs[0];
            }
            if (uargs[0] == null) {
                return uargs[1];
            }
            if (this.quaxUtil.isMember(uargs[0])) {
                call = new FunCall("{}", Syntax.Braces);
                call.getArgs().add(uargs[0]);
                uargs[0] = call;
            }
            if (this.quaxUtil.isMember(uargs[1])) {
                call = new FunCall("{}", Syntax.Braces);
                call.getArgs().add(uargs[1]);
                uargs[1] = call;
            }
            if (this.quaxUtil.isFunCallTo(uargs[0], "{}") && this.quaxUtil.isFunCallTo(uargs[1], "{}")) {
                return this.unionOfSets(uargs[0], uargs[1]);
            }
            return new FunCall("Union", Syntax.Function, Arrays.asList(uargs));
        }
        throw new UnknownExpressionException(this.quaxUtil.funCallName(oFun));
    }

    private Exp createComplement(Exp oFun, Member member, int hierIndex) {
        try {
            return this.createComplement(oFun, member);
        }
        catch (UnknownExpressionException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unkown FunCall {}", (Object)this.quaxUtil.funCallName(oFun));
            }
            if (this.ufMemberLists.get(hierIndex) == null) {
                throw new PivotException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getExpression());
            }
            ArrayList<Exp> newList = new ArrayList<Exp>();
            List<String> members = this.ufMemberLists.get(hierIndex);
            for (String name : members) {
                Member m = this.getMember(name);
                if (OlapUtils.equals((MetadataElement)member, (MetadataElement)m)) continue;
                newList.add(this.quaxUtil.expForMember(m));
            }
            return new FunCall("{}", Syntax.Braces, newList);
        }
    }

    private Exp createComplement(Exp oFun, Member member) throws UnknownExpressionException {
        if (this.quaxUtil.isFunCallTo(oFun, "Children")) {
            Exp oParent = this.quaxUtil.funCallArg(oFun, 0);
            Exp oMember = this.quaxUtil.expForMember(member);
            if (!this.quaxUtil.checkChild(member, oParent)) {
                return oFun;
            }
            List<Exp> oChildren = this.quaxUtil.getChildMembers(oParent);
            if (oChildren.size() < 2) {
                return null;
            }
            ArrayList<Exp> mComplement = new ArrayList<Exp>(oChildren.size() - 1);
            for (Exp child : oChildren) {
                if (child.equals(oMember)) continue;
                mComplement.add(child);
            }
            if (mComplement.size() == 1) {
                return (Exp)mComplement.get(0);
            }
            FunCall oComplement = new FunCall("{}", Syntax.Braces, mComplement);
            return oComplement;
        }
        if (this.quaxUtil.isFunCallTo(oFun, "{}")) {
            int nComp = 0;
            int nArg = this.quaxUtil.funCallArgCount(oFun);
            Exp oMember = this.quaxUtil.expForMember(member);
            for (int i = 0; i < nArg; ++i) {
                Exp o = this.quaxUtil.funCallArg(oFun, i);
                if (o.equals(oMember)) continue;
                ++nComp;
            }
            if (nComp == 0) {
                return null;
            }
            if (nComp == nArg) {
                return oFun;
            }
            ArrayList<Exp> mComplement = new ArrayList<Exp>(nComp);
            for (int i = 0; i < nArg; ++i) {
                Exp o = this.quaxUtil.funCallArg(oFun, i);
                if (o.equals(oMember)) continue;
                mComplement.add(o);
            }
            if (mComplement.size() == 1) {
                return (Exp)mComplement.get(0);
            }
            FunCall oComplement = new FunCall("{}", Syntax.Braces, mComplement);
            return oComplement;
        }
        if (this.quaxUtil.isFunCallTo(oFun, "Union")) {
            Exp[] complements = new Exp[2];
            for (int i = 0; i < 2; ++i) {
                Exp o = this.quaxUtil.funCallArg(oFun, i);
                complements[i] = this.createComplement(o, member);
            }
            if (complements[0] == null && complements[1] == null) {
                return null;
            }
            if (complements[0] != null && complements[1] == null) {
                return complements[0];
            }
            if (complements[0] == null && complements[1] != null) {
                return complements[1];
            }
            if (!this.quaxUtil.isFunCall(complements[0])) {
                FunCall call = new FunCall("{}", Syntax.Braces);
                call.getArgs().add(complements[0]);
                complements[0] = call;
            }
            if (!this.quaxUtil.isFunCall(complements[1])) {
                FunCall call = new FunCall("{}", Syntax.Braces);
                call.getArgs().add(complements[1]);
                complements[1] = call;
            }
            if (this.quaxUtil.isFunCallTo(complements[0], "{}") && this.quaxUtil.isFunCallTo(complements[1], "{}")) {
                return this.unionOfSets(complements[0], complements[1]);
            }
            FunCall newUnion = new FunCall("Union", Syntax.Function, Arrays.asList(complements));
            return newUnion;
        }
        throw new UnknownExpressionException(this.quaxUtil.funCallName(oFun));
    }

    private Exp unionOfSets(Exp set1, Exp set2) {
        int j;
        int n1 = this.quaxUtil.funCallArgCount(set1);
        int n2 = this.quaxUtil.funCallArgCount(set2);
        Exp[] newSet = new Exp[n1 + n2];
        int i = 0;
        for (j = 0; j < n1; ++j) {
            newSet[i++] = this.quaxUtil.funCallArg(set1, j);
        }
        for (j = 0; j < n2; ++j) {
            newSet[i++] = this.quaxUtil.funCallArg(set2, j);
        }
        return new FunCall("{}", Syntax.Braces, Arrays.asList(newSet));
    }

    public void setHierMemberList(int iHier, List<Member> list) {
        ArrayList<String> members = new ArrayList<String>(list.size());
        for (Member member : list) {
            members.add(member.getUniqueName());
            this.memberMap.put(member.getUniqueName(), member);
        }
        this.ufMemberLists.set(iHier, members);
    }

    public boolean isUnknownFunction(int iHier) {
        return this.containsUF[iHier];
    }

    @Override
    public Serializable saveState() {
        Serializable[] state = new Serializable[]{Boolean.valueOf(this.qubonMode), Integer.valueOf(this.ordinal), Integer.valueOf(this.nDimension), Boolean.valueOf(this.hierarchizeNeeded), Integer.valueOf(this.generateIndex), this.generateMode, Integer.valueOf(this.nHierExclude), (Serializable)((Object)this.ufMemberLists), (Serializable)((Object)this.hiers), this.containsUF, this.posTreeRoot};
        return state;
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        this.qubonMode = (Boolean)states[0];
        this.ordinal = (Integer)states[1];
        this.nDimension = (Integer)states[2];
        this.hierarchizeNeeded = (Boolean)states[3];
        this.generateIndex = (Integer)states[4];
        this.generateMode = (CalcSetMode)((Object)states[5]);
        this.nHierExclude = (Integer)states[6];
        this.ufMemberLists = (List)((Object)states[7]);
        this.hiers = (List)((Object)states[8]);
        this.containsUF = (boolean[])states[9];
        this.posTreeRoot = (ExpNode)states[10];
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        builder.append("Number of hierarchies excluded from HIEARARCHIZE=" + this.nHierExclude);
        builder.append('\n');
        if (this.posTreeRoot == null) {
            builder.append("Root=null");
            return builder.toString();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback<Exp>(){

            @Override
            public int handleTreeNode(TreeNode<Exp> node) {
                int nodeIndex = node.getLevel() - 1;
                builder.append("\n");
                for (int i = 0; i < nodeIndex - 1; ++i) {
                    builder.append("   ");
                }
                if (nodeIndex > 0) {
                    builder.append("+--");
                }
                Exp oExp = node.getReference();
                if (!Quax.this.quaxUtil.isMember(oExp)) {
                    builder.append((CharSequence)Quax.this.quaxUtil.funString(oExp));
                } else {
                    builder.append(Quax.this.quaxUtil.getMemberUniqueName(oExp));
                }
                return 0;
            }
        });
        return builder.toString();
    }

    protected Member getMember(String uniqueName) {
        Member member = this.memberMap.get(uniqueName);
        if (member == null) {
            try {
                member = this.getModel().getCube().lookupMember(IdentifierNode.parseIdentifier((String)uniqueName).getSegmentList());
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
            this.memberMap.put(uniqueName, member);
        }
        return member;
    }

    protected Hierarchy getHierarchy(String name) {
        Hierarchy hierarchy = this.hierarchyMap.get(name);
        if (hierarchy == null) {
            hierarchy = (Hierarchy)this.getModel().getCube().getHierarchies().get(name);
            this.hierarchyMap.put(name, hierarchy);
        }
        return hierarchy;
    }
}

