/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.el;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ExpressionContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = -8709294073194083447L;
    private ExpressionContext parent;

    public ExpressionContext() {
    }

    public ExpressionContext(ExpressionContext parent) {
        this.parent = parent;
    }

    @Override
    public Object get(Object key) {
        Object value = null;
        if (super.containsKey(key)) {
            value = super.get(key);
        } else if (this.parent != null) {
            value = this.parent.get(key);
        }
        if (value instanceof ValueBinding) {
            value = ((ValueBinding)value).getValue();
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        return this.parent != null && this.parent.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        Set<String> keySet = super.keySet();
        if (this.parent != null) {
            keySet = new HashSet<String>(keySet);
            Set<String> parentSet = this.parent.keySet();
            for (String key : parentSet) {
                if (keySet.contains(key)) continue;
                keySet.add(key);
            }
        }
        return keySet;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        Set<String> keySet = this.keySet();
        LinkedList<Object> values = new LinkedList<Object>();
        for (String key : keySet) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<String> keySet = this.keySet();
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>(keySet.size());
        for (String key : keySet) {
            entries.add(new Entry(key, this.get(key)));
        }
        return entries;
    }

    public static interface ValueBinding<T> {
        public T getValue();
    }

    static class Entry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            this.value = value;
            return value;
        }
    }
}

