/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDataSource;
import org.pivot4j.PivotException;
import org.pivot4j.datasource.AbstractOlapDataSource;
import org.pivot4j.datasource.CloseableDataSource;
import org.pivot4j.datasource.OlapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledOlapDataSource
extends AbstractOlapDataSource
implements CloseableDataSource {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericObjectPool.Config poolConfig;
    private GenericObjectPool<OlapConnection> pool;
    private OlapDataSource dataSource;
    private PooledOlapConnectionFactory connectionFactory;

    public PooledOlapDataSource(OlapDataSource dataSource) {
        this(dataSource, null);
    }

    public PooledOlapDataSource(OlapDataSource dataSource, GenericObjectPool.Config poolConfig) {
        if (dataSource == null) {
            throw new NullArgumentException("dataSource");
        }
        this.dataSource = dataSource;
        this.poolConfig = poolConfig == null ? new GenericObjectPool.Config() : poolConfig;
        this.connectionFactory = this.createConnectionFactory(dataSource);
        this.pool = this.createPool((PoolableObjectFactory<OlapConnection>)this.connectionFactory, poolConfig);
    }

    public OlapDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Disposing the connection pool.");
            }
            this.getPool().close();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected PooledOlapConnectionFactory createConnectionFactory(OlapDataSource dataSource) {
        return new PooledOlapConnectionFactory(dataSource);
    }

    protected PooledOlapConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected GenericObjectPool<OlapConnection> createPool(PoolableObjectFactory<OlapConnection> factory, GenericObjectPool.Config config) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating connection pool with following parameters : ");
            this.logger.info("\t- max active : {}", (Object)config.maxActive);
            this.logger.info("\t- max idle : {}", (Object)config.maxIdle);
            this.logger.info("\t- min idle: {}", (Object)config.minIdle);
            this.logger.info("\t- max wait : {}", (Object)config.maxWait);
        }
        return new GenericObjectPool(factory, config);
    }

    protected GenericObjectPool<OlapConnection> getPool() {
        return this.pool;
    }

    @Override
    protected OlapConnection createConnection(String userName, String password) throws SQLException {
        try {
            return (OlapConnection)this.pool.borrowObject();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public int getMaxIdle() {
        return this.poolConfig.maxIdle;
    }

    public int getMaxActive() {
        return this.poolConfig.maxActive;
    }

    public long getMaxWait() {
        return this.poolConfig.maxWait;
    }

    public byte getWhenExhaustedAction() {
        return this.poolConfig.whenExhaustedAction;
    }

    public boolean isTestOnBorrow() {
        return this.poolConfig.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.poolConfig.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.poolConfig.testWhileIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.poolConfig.timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.poolConfig.numTestsPerEvictionRun;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.poolConfig.minEvictableIdleTimeMillis;
    }

    class PooledOlapConnectionFactory
    extends OlapConnectionFactory {
        public PooledOlapConnectionFactory(OlapDataSource dataSource) {
            super(dataSource);
        }

        @Override
        public OlapConnection makeObject() {
            final OlapConnection connection = super.makeObject();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("close")) {
                        if (PooledOlapDataSource.this.logger.isDebugEnabled()) {
                            PooledOlapDataSource.this.logger.debug("Return a connection to the pool : " + connection);
                        }
                        PooledOlapDataSource.this.pool.returnObject((Object)((OlapConnection)proxy));
                        if (PooledOlapDataSource.this.logger.isDebugEnabled()) {
                            PooledOlapDataSource.this.logger.debug("\t- current pool size : " + PooledOlapDataSource.this.pool.getNumActive() + " / " + PooledOlapDataSource.this.pool.getMaxActive());
                        }
                        return null;
                    }
                    return method.invoke((Object)connection, args);
                }
            };
            return (OlapConnection)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{OlapConnection.class}, handler);
        }

        @Override
        public void destroyObject(OlapConnection con) {
            if (PooledOlapDataSource.this.logger.isDebugEnabled()) {
                PooledOlapDataSource.this.logger.debug("Closing a returned connection object : {}", (Object)con);
            }
            try {
                ((OlapConnection)con.unwrap(OlapConnection.class)).close();
            }
            catch (SQLException e) {
                throw new PivotException(e);
            }
        }
    }
}

