/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.asyncexecutor.AcquiredTimerJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;

public class AcquireTimerJobsCmd
implements Command<AcquiredTimerJobEntities> {
    private final AsyncExecutor asyncExecutor;

    public AcquireTimerJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public AcquiredTimerJobEntities execute(CommandContext commandContext) {
        AcquiredTimerJobEntities acquiredJobs = new AcquiredTimerJobEntities();
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findTimerJobsToExecute(new Page(0, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()));
        for (TimerJobEntity job : timerJobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, TimerJobEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

