/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.ui;

import com.opensymphony.xwork2.ActionContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gsweb.components.util.ComponentResourceUtils;
import org.gsweb.components.util.UIComponent;

public class TextBox
implements UIComponent {
    private PageContext pageContext = null;
    private String id = "";
    private String name = "";
    private int maxlength = 20;
    private String placeHolder = "";
    private int width = 200;
    private String value = "";
    private String readonly = "N";
    private StringBuilder htmlOut = new StringBuilder();

    private Map<String, Object> getParameters(String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", this.id);
        params.put("name", this.name);
        params.put("maxlength", String.valueOf(this.maxlength));
        params.put("placeHolder", StringEscapeUtils.escapeEcmaScript(this.placeHolder));
        params.put("width", String.valueOf(this.width));
        params.put("value", this.value);
        Object valueStackObj = null;
        if (!StringUtils.isBlank(this.value)) {
            valueStackObj = ActionContext.getContext().getValueStack().findValue(this.value);
        }
        if (valueStackObj != null) {
            this.fillValueByValueStackObj(params, valueStackObj);
        }
        params.put("readonly", this.readonly);
        return params;
    }

    private void fillValueByValueStackObj(Map<String, Object> params, Object valueStackObj) {
        if (valueStackObj instanceof String) {
            params.put("value", StringEscapeUtils.escapeHtml4((String)valueStackObj));
            return;
        }
        if (valueStackObj instanceof Integer) {
            params.put("value", String.valueOf((Integer)valueStackObj));
            return;
        }
        if (valueStackObj instanceof Long) {
            params.put("value", String.valueOf((Long)valueStackObj));
            return;
        }
        if (valueStackObj instanceof BigDecimal) {
            params.put("value", ((BigDecimal)valueStackObj).toString());
            return;
        }
        if (valueStackObj instanceof BigInteger) {
            params.put("value", ((BigInteger)valueStackObj).toString());
            return;
        }
        if (valueStackObj instanceof Float) {
            params.put("value", String.valueOf((Float)valueStackObj));
            return;
        }
        if (valueStackObj instanceof Double) {
            params.put("value", String.valueOf((Double)valueStackObj));
            return;
        }
    }

    private void generateHtml() {
        try {
            this.htmlOut.append(ComponentResourceUtils.generatorResource(TextBox.class, "html", "META-INF/resource/textbox/ui.textbox.htm.ftl", this.getParameters("html")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScript() throws Exception {
        return " ";
    }

    @Override
    public String getHtml() throws Exception {
        this.generateHtml();
        return this.htmlOut.toString();
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }
}

