/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.ui;

import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.PageContext;
import org.gsweb.components.ui.TextBox;
import org.gsweb.components.util.ComponentResourceUtils;
import org.gsweb.components.util.UIComponent;

public class Grid
implements UIComponent {
    private PageContext pageContext = null;
    private String id;
    private String gridFieldStructure = "";
    private String clearQueryFn = "";
    private int width = 100;
    private String programId = "Query";
    private String disableOnHeaderCellClick = "N";
    private StringBuilder script = new StringBuilder();
    private StringBuilder htmlOut = new StringBuilder();

    private Map<String, Object> getParameters(String type, String language) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", this.id);
        if ("script".equals(type)) {
            params.put("gridFieldStructure", ComponentResourceUtils.getScriptFunctionNameForGridParams(this.gridFieldStructure));
            params.put("clearQueryFn", ComponentResourceUtils.getScriptFunctionNameForInCall(this.clearQueryFn));
            params.put("programId", this.programId);
            params.put("disableOnHeaderCellClick", this.disableOnHeaderCellClick);
        } else {
            params.put("width", String.valueOf(String.valueOf(this.width)) + "%");
            params.put("totalName", "total");
            params.put("pageName", "page");
            params.put("rowSizeName", "row size");
            this.setLabelNameFromProperties(params, language);
        }
        return params;
    }

    private void setLabelNameFromProperties(Map<String, Object> params, String language) {
        String propFileName = "META-INF/resource/grid/ui.grid_" + language + ".properties";
        InputStream is = null;
        is = TextBox.class.getClassLoader().getResourceAsStream(propFileName);
        if (is != null) {
            Properties prop;
            block12: {
                prop = new Properties();
                try {
                    try {
                        prop.load(is);
                        params.put("totalName", prop.get("totalName"));
                        params.put("pageName", prop.get("pageName"));
                        params.put("rowSizeName", prop.get("rowSizeName"));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            prop.clear();
            prop = null;
        }
        is = null;
    }

    private void generateScript() {
        try {
            this.script.append(ComponentResourceUtils.generatorResource(Grid.class, "script", "META-INF/resource/grid/ui.grid.js.ftl", this.getParameters("script", null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateHtml() {
        Locale locale = ActionContext.getContext().getLocale();
        try {
            this.htmlOut.append(ComponentResourceUtils.generatorResource(Grid.class, "html", "META-INF/resource/grid/ui.grid.htm.ftl", this.getParameters("html", locale.getLanguage())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return null;
    }

    public String getGridFieldStructure() {
        return this.gridFieldStructure;
    }

    public void setGridFieldStructure(String gridFieldStructure) {
        this.gridFieldStructure = gridFieldStructure;
    }

    public String getClearQueryFn() {
        return this.clearQueryFn;
    }

    public void setClearQueryFn(String clearQueryFn) {
        this.clearQueryFn = clearQueryFn;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public String getScript() throws Exception {
        this.generateScript();
        return this.script.toString();
    }

    @Override
    public String getHtml() throws Exception {
        this.generateHtml();
        return this.htmlOut.toString();
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public String getDisableOnHeaderCellClick() {
        return this.disableOnHeaderCellClick;
    }

    public void setDisableOnHeaderCellClick(String disableOnHeaderCellClick) {
        this.disableOnHeaderCellClick = disableOnHeaderCellClick;
    }
}

