/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.ui;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.gsweb.components.util.ComponentResourceUtils;
import org.gsweb.components.util.UIComponent;

public class Button
implements UIComponent {
    private PageContext pageContext = null;
    private String id = "";
    private String name = "";
    private String label = "";
    private boolean showLabel = true;
    private String onClick = "";
    private String iconClass = "";
    private String cssClass = "";
    private String xhrUrl = "";
    private String xhrParameter = "";
    private boolean sync = true;
    private String handleAs = "json";
    private long timeout = 60000L;
    private boolean preventCache = true;
    private String loadFn = "";
    private String errorFn = "";
    private String parameterType = "postData";
    private String programId = "Message";
    private String confirmDialogMode = "N";
    private String confirmDialogTitle = "";
    private String confirmDialogMsg = "";
    private StringBuilder script = new StringBuilder();
    private StringBuilder htmlOut = new StringBuilder();

    private Map<String, Object> getParameters(String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ("script".equals(type)) {
            params.put("id", this.id);
            params.put("name", this.name);
            params.put("onClick", ComponentResourceUtils.getScriptFunctionNameForXhrMain(this.onClick));
            params.put("xhrUrl", this.xhrUrl);
            params.put("xhrParameter", this.xhrParameter);
            params.put("handleAs", this.handleAs);
            params.put("timeout", String.valueOf(this.timeout));
            params.put("sync", String.valueOf(this.sync));
            params.put("preventCache", String.valueOf(this.preventCache));
            params.put("loadFn", ComponentResourceUtils.getScriptFunctionNameForInCall(this.loadFn));
            params.put("errorFn", ComponentResourceUtils.getScriptFunctionNameForInCall(this.errorFn));
            params.put("parameterType", this.parameterType);
            params.put("programId", this.programId);
            if (!StringUtils.isBlank(this.loadFn) && !this.loadFn.endsWith(";")) {
                params.put("loadFn", String.valueOf(this.loadFn) + ";");
            }
            if (!StringUtils.isBlank(this.errorFn) && !this.errorFn.endsWith(";")) {
                params.put("errorFn", String.valueOf(this.errorFn) + ";");
            }
            params.put("confirmDialogMode", this.confirmDialogMode);
            params.put("confirmDialogTitle", StringUtils.defaultString(this.confirmDialogTitle).trim());
            params.put("confirmDialogMsg", this.confirmDialogMsg);
        } else {
            params.put("id", this.id);
            params.put("name", this.name);
            params.put("showLabel", String.valueOf(this.showLabel));
            params.put("iconClass", this.iconClass);
            params.put("cssClass", this.cssClass);
            params.put("onClick", this.onClick);
            params.put("label", this.label);
        }
        return params;
    }

    private void generateXhrScript() {
        try {
            this.script.append(ComponentResourceUtils.generatorResource(Button.class, "script", "META-INF/resource/button/ui.button.js.ftl", this.getParameters("script")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateHtml() {
        try {
            this.htmlOut.append(ComponentResourceUtils.generatorResource(Button.class, "html", "META-INF/resource/button/ui.button.htm.ftl", this.getParameters("html")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScript() throws Exception {
        if (StringUtils.isBlank(this.xhrUrl)) {
            this.script.setLength(0);
        } else {
            this.generateXhrScript();
        }
        return this.script.toString();
    }

    @Override
    public String getHtml() throws Exception {
        this.generateHtml();
        return this.htmlOut.toString();
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getXhrUrl() {
        return this.xhrUrl;
    }

    public void setXhrUrl(String xhrUrl) {
        this.xhrUrl = xhrUrl;
    }

    public String getXhrParameter() {
        return this.xhrParameter;
    }

    public void setXhrParameter(String xhrParameter) {
        this.xhrParameter = xhrParameter;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public String getHandleAs() {
        return this.handleAs;
    }

    public void setHandleAs(String handleAs) {
        this.handleAs = handleAs;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isPreventCache() {
        return this.preventCache;
    }

    public void setPreventCache(boolean preventCache) {
        this.preventCache = preventCache;
    }

    public String getLoadFn() {
        return this.loadFn;
    }

    public void setLoadFn(String loadFn) {
        this.loadFn = loadFn;
    }

    public String getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(String errorFn) {
        this.errorFn = errorFn;
    }

    public StringBuilder getHtmlOut() {
        return this.htmlOut;
    }

    public void setHtmlOut(StringBuilder htmlOut) {
        this.htmlOut = htmlOut;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setScript(StringBuilder script) {
        this.script = script;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public String getConfirmDialogMode() {
        return this.confirmDialogMode;
    }

    public void setConfirmDialogMode(String confirmDialogMode) {
        this.confirmDialogMode = confirmDialogMode;
    }

    public String getConfirmDialogTitle() {
        return this.confirmDialogTitle;
    }

    public void setConfirmDialogTitle(String confirmDialogTitle) {
        this.confirmDialogTitle = confirmDialogTitle;
    }

    public String getConfirmDialogMsg() {
        return this.confirmDialogMsg;
    }

    public void setConfirmDialogMsg(String confirmDialogMsg) {
        this.confirmDialogMsg = confirmDialogMsg;
    }
}

