/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.datastax.driver.core.utils.UUIDs;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.Years;

public class SimpleUtils {
    public static final int IS_YEAR = 1;
    public static final int IS_MONTH = 2;
    public static final int IS_DAY = 3;
    private static final Random rnd = new Random();
    private static final String sourceStr = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] sourceStrArray = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static boolean checkBeTrueOf_azAZ09(int minLength, int maxLength, String sourceValue) {
        boolean accept = true;
        if (sourceValue == null || sourceValue.length() < minLength || sourceValue.length() > maxLength || minLength < 0) {
            accept = false;
            return accept;
        }
        accept = SimpleUtils.checkBeTrueOf_azAZ09(sourceValue);
        return accept;
    }

    public static boolean checkBeTrueOf_09(String sourceValue) {
        boolean isNormal = true;
        if (sourceValue != null && sourceValue.length() > 0) {
            char val = '\u0000';
            char[] tmp = sourceValue.toCharArray();
            int ix = 0;
            while (ix < tmp.length && isNormal) {
                val = tmp[ix];
                if (val < '0' || val > '9') {
                    isNormal = false;
                }
                ++ix;
            }
        } else {
            isNormal = false;
        }
        return isNormal;
    }

    public static boolean checkBeTrueOf_azAZ09(String sourceValue) {
        boolean isNormal = true;
        if (sourceValue != null && sourceValue.length() > 0) {
            char val = '\u0000';
            char[] tmp = sourceValue.toCharArray();
            int ix = 0;
            while (ix < tmp.length && isNormal) {
                val = tmp[ix];
                if (!(val >= '0' && val <= '9' || val >= 'A' && val <= 'Z' || val >= 'a' && val <= 'z')) {
                    isNormal = false;
                }
                ++ix;
            }
        } else {
            isNormal = false;
        }
        return isNormal;
    }

    public static boolean checkBeTrueOfNumber(String sourceValue) {
        return NumberUtils.isCreatable(sourceValue);
    }

    public static String createRandomString(int length) {
        if (length < 1) {
            return "";
        }
        StringBuffer retValue = new StringBuffer();
        int ix = 0;
        while (ix < length) {
            retValue.append(sourceStrArray[rnd.nextInt(sourceStrArray.length)]);
            ++ix;
        }
        return retValue.toString();
    }

    public static String getStr(String value) {
        return SimpleUtils.getStr(value, "");
    }

    public static String getStr(String value, String defaultValue) {
        return StringUtils.defaultString(value, defaultValue);
    }

    public static int getInt(String value, int defaultValue) {
        int val = defaultValue;
        if (value != null) {
            val = NumberUtils.toInt(value, defaultValue);
        }
        return val;
    }

    public static long getLong(String value, long defaultValue) {
        long val = defaultValue;
        if (value != null) {
            val = NumberUtils.toLong(value, defaultValue);
        }
        return val;
    }

    public static float getFloat(String value, float defaultValue) {
        float val = defaultValue;
        if (value != null) {
            val = NumberUtils.toFloat(value, defaultValue);
        }
        return val;
    }

    public static final String getStrYMD(int type) {
        Calendar calendar = Calendar.getInstance();
        if (type == 1) {
            return String.valueOf(calendar.get(1));
        }
        if (type == 2) {
            return StringUtils.leftPad(String.valueOf(calendar.get(2) + 1), 2, "0");
        }
        if (type == 3) {
            return StringUtils.leftPad(String.valueOf(calendar.get(5)), 2, "0");
        }
        return String.valueOf(calendar.get(1));
    }

    public static boolean isDate(String yyyymmdd) {
        String[] tmp;
        boolean accept = false;
        if (yyyymmdd == null) {
            return accept;
        }
        int y = 0;
        int m = 0;
        int d = 0;
        if (yyyymmdd.indexOf("/") > -1) {
            tmp = yyyymmdd.split("/");
            if (tmp.length == 3) {
                y = SimpleUtils.getInt(tmp[0], 0);
                m = SimpleUtils.getInt(tmp[1], 0);
                d = SimpleUtils.getInt(tmp[2], 0);
            }
            tmp = null;
        }
        if (yyyymmdd.indexOf("-") > -1) {
            tmp = yyyymmdd.split("-");
            if (tmp.length == 3) {
                y = SimpleUtils.getInt(tmp[0], 0);
                m = SimpleUtils.getInt(tmp[1], 0);
                d = SimpleUtils.getInt(tmp[2], 0);
            }
            tmp = null;
        }
        if (yyyymmdd.length() == 8) {
            y = SimpleUtils.getInt(yyyymmdd.substring(0, 4), 0);
            m = SimpleUtils.getInt(yyyymmdd.substring(4, 6), 0);
            d = SimpleUtils.getInt(yyyymmdd.substring(6, 8), 0);
        }
        if (y != 0 && m != 0 && d != 0 && y >= 1900 && y <= 9999 && m >= 1 && m <= 12 && d >= 1 && d <= SimpleUtils.getMaxDayOfMonth(y, m)) {
            accept = true;
        }
        return accept;
    }

    public static int getDaysBetween(String startDate, String endDate) {
        DateTime s = new DateTime(SimpleUtils.getStrYMD(startDate.replaceAll("/", "-"), "-"));
        DateTime e = new DateTime(SimpleUtils.getStrYMD(endDate.replaceAll("/", "-"), "-"));
        return Days.daysBetween(s, e).getDays();
    }

    public static int getDaysBetween(Date startDate, Date endDate) {
        return SimpleUtils.getDaysBetween(SimpleUtils.getStrYMD(startDate, "-"), SimpleUtils.getStrYMD(endDate, "-"));
    }

    public static int getYearsBetween(String startDate, String endDate) {
        DateTime s = new DateTime(startDate.length() == 4 ? String.valueOf(startDate) + "-01-01" : SimpleUtils.getStrYMD(startDate.replaceAll("/", "-"), "-"));
        DateTime e = new DateTime(endDate.length() == 4 ? String.valueOf(endDate) + "-01-01" : SimpleUtils.getStrYMD(endDate.replaceAll("/", "-"), "-"));
        return Years.yearsBetween(s, e).getYears();
    }

    public static int getYearsBetween(Date startDate, Date endDate) {
        return SimpleUtils.getYearsBetween(SimpleUtils.getStrYMD(startDate, "").substring(0, 4), SimpleUtils.getStrYMD(endDate, "").substring(0, 4));
    }

    public static int getMonthsBetween(String startDate, String endDate) {
        DateTime s = new DateTime(SimpleUtils.getStrYMD(startDate.replaceAll("/", "-"), "-"));
        DateTime e = new DateTime(SimpleUtils.getStrYMD(endDate.replaceAll("/", "-"), "-"));
        return Months.monthsBetween(s, e).getMonths();
    }

    public static int getMonthsBetween(Date startDate, Date endDate) {
        return SimpleUtils.getMonthsBetween(SimpleUtils.getStrYMD(startDate, "-"), SimpleUtils.getStrYMD(endDate, "-"));
    }

    public static final String getStrYMD(String splitStr) {
        StringBuilder sb = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        sb.append(calendar.get(1)).append(splitStr);
        sb.append(StringUtils.leftPad(String.valueOf(calendar.get(2) + 1), 2, "0")).append(splitStr);
        sb.append(StringUtils.leftPad(String.valueOf(calendar.get(5)), 2, "0"));
        return sb.toString();
    }

    public static final String getStrYMD(Date date, String splitStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(1)) + splitStr + StringUtils.leftPad(String.valueOf(calendar.get(2) + 1), 2, "0") + splitStr + StringUtils.leftPad(String.valueOf(calendar.get(5)), 2, "0");
    }

    public static final String getStrYMD(String yyyymmdd, String splitStr) {
        if (StringUtils.isBlank(splitStr) || !SimpleUtils.isDate(yyyymmdd)) {
            return yyyymmdd;
        }
        if (yyyymmdd.length() != 8) {
            return yyyymmdd;
        }
        return String.valueOf(yyyymmdd.substring(0, 4)) + splitStr + yyyymmdd.substring(4, 6) + splitStr + yyyymmdd.substring(6, 8);
    }

    public static int getMaxDayOfMonth(int year, int month) {
        int max = 28;
        Calendar calendar = Calendar.getInstance();
        if (year >= 1900 && year <= 3000) {
            calendar.set(1, year);
        } else {
            calendar.set(1, 1900);
        }
        if (month >= 1 && month <= 12) {
            calendar.set(2, month - 1);
        } else {
            calendar.set(2, 0);
        }
        calendar.set(5, 1);
        max = calendar.getActualMaximum(5);
        return max;
    }

    public static int getDayOfWeek(int year, int month) {
        int dayofweek = 28;
        Calendar calendar = Calendar.getInstance();
        if (year >= 1900 && year <= 3000) {
            calendar.set(1, year);
        } else {
            calendar.set(1, 1900);
        }
        if (month >= 1 && month <= 12) {
            calendar.set(2, month - 1);
        } else {
            calendar.set(2, 0);
        }
        calendar.set(5, 1);
        dayofweek = calendar.get(7);
        return dayofweek;
    }

    public static Map<String, String> getQuarterlyStartEnd(String yyyyMMdd) throws Exception {
        HashMap<String, String> dateMap = new HashMap<String, String>();
        if (yyyyMMdd == null) {
            throw new IllegalArgumentException("yyyyMMdd error.");
        }
        if ((yyyyMMdd = yyyyMMdd.replaceAll("/", "")).length() != 8 || !NumberUtils.isCreatable(yyyyMMdd)) {
            throw new IllegalArgumentException("yyyyMMdd error.");
        }
        int yyyy = Integer.parseInt(yyyyMMdd.substring(0, 4));
        int mm = Integer.parseInt(yyyyMMdd.substring(4, 6));
        String start = "";
        String end = "";
        if (mm >= 1 && mm <= 3) {
            start = String.valueOf(yyyy) + "/01/01";
            end = String.valueOf(yyyy) + "/03/" + SimpleUtils.getMaxDayOfMonth(yyyy, 3);
        }
        if (mm >= 4 && mm <= 6) {
            start = String.valueOf(yyyy) + "/04/01";
            end = String.valueOf(yyyy) + "/06/" + SimpleUtils.getMaxDayOfMonth(yyyy, 6);
        }
        if (mm >= 7 && mm <= 9) {
            start = String.valueOf(yyyy) + "/07/01";
            end = String.valueOf(yyyy) + "/09/" + SimpleUtils.getMaxDayOfMonth(yyyy, 9);
        }
        if (mm >= 10 && mm <= 12) {
            start = String.valueOf(yyyy) + "/10/01";
            end = String.valueOf(yyyy) + "/12/" + SimpleUtils.getMaxDayOfMonth(yyyy, 12);
        }
        if ("".equals(start) || "".equals(end)) {
            throw new IllegalArgumentException("yyyyMMdd error.");
        }
        dateMap.put("date1", start);
        dateMap.put("date2", end);
        return dateMap;
    }

    public static String toHex(String sourceValue) {
        String value = "";
        value = Hex.encodeHexString(SimpleUtils.getStr(sourceValue, "").getBytes());
        return value;
    }

    public static String deHex(String sourceValue) {
        String value = "";
        try {
            value = new String(Hex.decodeHex(SimpleUtils.getStr(sourceValue, "").toCharArray()));
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String toB64(String sourceValue) {
        String value = "";
        value = Base64.encodeBase64String(SimpleUtils.getStr(sourceValue, "").getBytes());
        return value;
    }

    public static String deB64(String sourceValue) {
        String value = "";
        value = new String(Base64.decodeBase64(SimpleUtils.getStr(sourceValue, "")));
        return value;
    }

    public static String getUUIDStr() {
        return UUIDs.timeBased().toString();
    }

    public static String getRandomUUIDStr() {
        return UUIDs.random().toString();
    }

    public static byte[] toMD5(String sourceValue) {
        return DigestUtils.md5(SimpleUtils.getStr(sourceValue, ""));
    }

    public static String toMD5Hex(String sourceValue) {
        return DigestUtils.md5Hex(SimpleUtils.getStr(sourceValue, ""));
    }

    public static String joinString(Object ... values) {
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                sb.append((String)o);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String toUnicode(String strValue) {
        if (strValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] chr = strValue.toCharArray();
        int ix = 0;
        while (ix < chr.length) {
            sb.append("&#").append((int)chr[ix]).append(";");
            ++ix;
        }
        return sb.toString();
    }

    public static <T extends Serializable> List<T> getListHashSet(List<T> list) throws Exception {
        if (list == null) {
            return list;
        }
        return new ArrayList<T>(new HashSet<T>(list));
    }

    public static BufferedImage decodeToImage(String imageString) {
        BufferedImage image = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)imageString));
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static String encodeToString(BufferedImage image, String type) {
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, type, bos);
            byte[] imageBytes = bos.toByteArray();
            imageString = DatatypeConverter.printBase64Binary((byte[])imageBytes);
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageString;
    }

    public static String getPNGBase64Content(String imgStr) throws Exception {
        if (!SimpleUtils.isPNGBase64Content(imgStr)) {
            imgStr = new String(IOUtils.toByteArray(SimpleUtils.class.getClassLoader().getResource("META-INF/resource/nofound-icon.html").openStream()));
        }
        imgStr = StringUtils.replaceOnce(imgStr, "<img src=\"data:image/png;base64,", "");
        imgStr = StringUtils.replaceOnce(imgStr, "\">", "");
        imgStr = StringUtils.replaceOnce(imgStr, "data:image/png;base64,", "");
        return imgStr;
    }

    public static boolean isPNGBase64Content(String imgStr) throws Exception {
        if (imgStr == null || imgStr.indexOf("image/png;base64,") == -1) {
            return false;
        }
        return imgStr.length() >= 35;
    }

    public static Workbook createPOIWorkbook(InputStream inp) throws IOException, InvalidFormatException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader(inp)) {
            return new HSSFWorkbook(inp);
        }
        if (DocumentFactoryHelper.hasOOXMLHeader(inp)) {
            return new XSSFWorkbook(OPCPackage.open(inp));
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static void setCellPicture(XSSFWorkbook wb, XSSFSheet sh, byte[] iconBytes, int row, int col) throws Exception {
        int myPictureId = wb.addPicture(iconBytes, 6);
        XSSFDrawing drawing = sh.createDrawingPatriarch();
        XSSFClientAnchor myAnchor = new XSSFClientAnchor();
        myAnchor.setCol1(col);
        myAnchor.setRow1(row);
        XSSFPicture myPicture = drawing.createPicture(myAnchor, myPictureId);
        myPicture.resize();
    }

    public static byte[] getColorRGB(String rgb) throws Exception {
        if (StringUtils.isEmpty(rgb) || rgb.length() != 6) {
            return new byte[3];
        }
        int red = Integer.parseInt(rgb.substring(0, 2), 16);
        int green = Integer.parseInt(rgb.substring(2, 4), 16);
        int blue = Integer.parseInt(rgb.substring(4, 6), 16);
        return new byte[]{(byte)red, (byte)green, (byte)blue};
    }

    public static byte[] getColorRGB4POIColor(String srcRGB) throws Exception {
        if (StringUtils.isEmpty(srcRGB) || srcRGB.length() != 6 && srcRGB.length() != 7) {
            byte[] byArray = new byte[4];
            byArray[0] = -1;
            return byArray;
        }
        String rgb = srcRGB;
        if (rgb.length() == 7) {
            rgb = rgb.substring(1, rgb.length());
        }
        int red = Integer.parseInt(rgb.substring(0, 2), 16);
        int green = Integer.parseInt(rgb.substring(2, 4), 16);
        int blue = Integer.parseInt(rgb.substring(4, 6), 16);
        return new byte[]{-1, (byte)red, (byte)green, (byte)blue};
    }

    public static int[] getColorRGB2(String color) throws Exception {
        if (StringUtils.isEmpty(color) || color.length() != 7) {
            return new int[3];
        }
        Color c = Color.decode(color);
        return new int[]{c.getRed(), c.getGreen(), c.getBlue()};
    }

    public static String getHttpRequestUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        url.append(request.getRequestURL().toString());
        Enumeration paramNames = request.getParameterNames();
        int i = 0;
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (i == 0) {
                url.append("?");
            } else {
                url.append("&");
            }
            url.append(paramName).append("=").append(request.getParameter(paramName));
            ++i;
        }
        return url.toString();
    }

    public static String escapeCsv(String str) throws Exception {
        if (str == null) {
            return str;
        }
        str = str.replaceAll("\r\n", "#GS_NRNL#");
        str = str.replaceAll("\r", "#GS_NR#");
        str = str.replaceAll("\n", "#GS_NL#");
        str = str.replaceAll("\t", "#GS_TAB#");
        str = str.replaceAll(";", "#GS_SEMICOLON#");
        str = str.replaceAll(",", "#GS_COMMA#");
        return str;
    }

    public static String unEscapeCsv(String str) throws Exception {
        if (str == null) {
            return str;
        }
        str = str.replaceAll("#GS_NRNL#", "\r\n");
        str = str.replaceAll("#GS_NR#", "\r");
        str = str.replaceAll("#GS_NL#", "\n");
        str = str.replaceAll("#GS_TAB#", "\t");
        str = str.replaceAll("#GS_SEMICOLON#", ";");
        str = str.replaceAll("#GS_COMMA#", ",");
        return str;
    }

    public static String unEscapeCsv2(String str) throws Exception {
        if (str == null) {
            return str;
        }
        if ((str = SimpleUtils.unEscapeCsv(str)).startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length());
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static int getAvailableProcessors(int maxSize) {
        int processors = Runtime.getRuntime().availableProcessors() - 1;
        if (processors > maxSize) {
            processors = maxSize;
        }
        if (processors < 1) {
            processors = 1;
        }
        return processors;
    }
}

