/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import javax.sql.DataSource;
import ognl.Ognl;
import org.apache.commons.lang3.StringUtils;

public class ManualDataSourceFactory {
    private static boolean checkDataSourceClass(Class<?> clazz) throws Exception {
        if (clazz == null) {
            return false;
        }
        boolean isDataSource = false;
        Class<?>[] ifs = clazz.getInterfaces();
        int i = 0;
        while (ifs != null && i < ifs.length) {
            if (ifs[i].getSimpleName().equals("DataSource")) {
                isDataSource = true;
            }
            ++i;
        }
        return isDataSource;
    }

    public static DataSource getDataSource(Class<?> dataSourceClass, String url, String user, String password) throws Exception {
        if (!ManualDataSourceFactory.checkDataSourceClass(dataSourceClass)) {
            throw new Exception("DataSource Class is not implements DataSource. error!");
        }
        if (StringUtils.isBlank(url) || StringUtils.isBlank(user)) {
            throw new Exception("url or user is required!");
        }
        DataSource ds = (DataSource)dataSourceClass.newInstance();
        Ognl.setValue("url", (Object)ds, (Object)url);
        Ognl.setValue("user", (Object)ds, (Object)user);
        Ognl.setValue("password", (Object)ds, (Object)(password == null ? "" : password));
        return ds;
    }
}

