/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class FtpClientUtils {
    public static final int TIME_OUT = 30000;
    protected Logger logger = Logger.getLogger(FtpClientUtils.class);
    protected FTPClient ftpClient = new FTPClient();
    private String ftpserver = "";
    private String ftpuser = "";
    private String ftppass = "";
    private File storeDir;

    public FtpClientUtils() {
        this.ftpClient.setBufferSize(100000);
    }

    public String getFtpserver() {
        return this.ftpserver;
    }

    public void setFtpserver(String ftpserver) {
        this.ftpserver = ftpserver;
    }

    public String getFtpuser() {
        return this.ftpuser;
    }

    public void setFtpuser(String ftpuser) {
        this.ftpuser = ftpuser;
    }

    public String getFtppass() {
        return this.ftppass;
    }

    public void setFtppass(String ftppass) {
        this.ftppass = ftppass;
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(File storeDir) {
        this.storeDir = storeDir;
    }

    public void restConnection() throws Exception {
        this.ftpClient.connect(this.ftpserver);
        this.ftpClient.login(this.ftpuser, this.ftppass);
    }

    public void get() throws SocketException, IOException, Exception {
        this.get(this.ftpserver, this.ftpuser, this.ftppass, "", this.storeDir, false);
    }

    public void get(String ftpserver, String ftpuser, String ftppass, String cwdDirectory, File storeDir, boolean deleteFtpFile) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.login(ftpserver, ftpuser, ftppass);
        }
        this.get(cwdDirectory, storeDir, null, deleteFtpFile);
    }

    public void get(String cwdDirectory, File storeDir, String head) throws SocketException, IOException, Exception {
        this.get(cwdDirectory, storeDir, head, false);
    }

    public void getByName(String cwdDirectory, File storeDir, String head) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.logger.error("FTP not connection...");
            throw new Exception("FTP not connection...");
        }
        this.ftpClient.setFileType(2);
        if (cwdDirectory != null && !"".equals(cwdDirectory)) {
            this.ftpClient.cwd(cwdDirectory);
        }
        String[] names = this.ftpClient.listNames();
        int ix = 0;
        while (names != null && ix < names.length) {
            if (head != null && !"".equals(head) && names[ix].indexOf(head) != 0) {
                this.logger.info("not get : " + names[ix]);
            } else {
                this.logger.info(names[ix]);
                if (names[ix].indexOf(".") > 0 && names[ix].indexOf(".") < names[ix].length()) {
                    File downloadFile = new File(String.valueOf(storeDir.getPath()) + "/" + names[ix]);
                    FileOutputStream fos = new FileOutputStream(downloadFile);
                    if (this.ftpClient.retrieveFile(names[ix], fos)) {
                        this.logger.info("ftp GET (save to) : " + storeDir.getPath() + "/" + names[ix]);
                    }
                    downloadFile = null;
                    fos.close();
                    fos = null;
                }
            }
            ++ix;
        }
    }

    public void get(String cwdDirectory, File storeDir, String head, boolean deleteFtpFile) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.logger.error("FTP not connection...");
            throw new Exception("FTP not connection...");
        }
        this.ftpClient.setFileType(2);
        if (cwdDirectory != null && !"".equals(cwdDirectory)) {
            this.ftpClient.cwd(cwdDirectory);
        }
        FTPFile[] ftpFiles = this.ftpClient.listFiles();
        int ix = 0;
        while (ftpFiles != null && ix < ftpFiles.length) {
            if (head != null && !"".equals(head) && ftpFiles[ix].getName().indexOf(head) != 0) {
                this.logger.info("not get : " + ftpFiles[ix].getName());
            } else {
                this.logger.info(ftpFiles[ix]);
                if (ftpFiles[ix].isFile()) {
                    File downloadFile = new File(String.valueOf(storeDir.getPath()) + "/" + ftpFiles[ix].getName());
                    FileOutputStream fos = new FileOutputStream(downloadFile);
                    if (this.ftpClient.retrieveFile(ftpFiles[ix].getName(), fos)) {
                        this.logger.info("ftp GET (save to) : " + storeDir.getPath() + "/" + ftpFiles[ix].getName());
                        if (deleteFtpFile) {
                            this.delete(ftpFiles[ix].getName());
                        }
                    }
                    downloadFile = null;
                    fos.close();
                    fos = null;
                }
            }
            ++ix;
        }
    }

    public boolean delete(String remoteFileName) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.logger.error("FTP not connection...");
            throw new Exception("FTP not connection...");
        }
        boolean delStatus = this.ftpClient.deleteFile(remoteFileName);
        this.logger.warn("ftp DELETE : " + remoteFileName + " del-status : " + delStatus);
        return delStatus;
    }

    public boolean deleteRestConnection(String cwdDirectory, String remoteFileName) throws SocketException, IOException, Exception {
        this.restConnection();
        this.cwd(cwdDirectory);
        return this.delete(remoteFileName);
    }

    public void put(String cwdDirectory, String remoteFileName, File localFile) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.logger.error("FTP not connection... put(String cwdDirectory, String remoteFileName, File localFile)");
            this.restConnection();
        }
        FileInputStream fis = new FileInputStream(localFile);
        this.ftpClient.setFileType(2);
        if (cwdDirectory != null && !"".equals(cwdDirectory)) {
            this.ftpClient.cwd(cwdDirectory);
        }
        this.ftpClient.storeFile(remoteFileName, fis);
        this.logger.warn("ftp PUT : " + cwdDirectory + "/" + remoteFileName);
        fis.close();
        fis = null;
    }

    public void login(String ftpserver, String ftpuser, String ftppass) throws SocketException, IOException {
        this.ftpserver = ftpserver;
        this.ftpuser = ftpuser;
        this.ftppass = ftppass;
        this.ftpClient.connect(this.ftpserver);
        this.ftpClient.setConnectTimeout(30000);
        this.ftpClient.login(this.ftpuser, this.ftppass);
    }

    public void cwd(String cwdDirectory) throws SocketException, IOException, Exception {
        if (!this.ftpClient.isConnected()) {
            this.logger.error("FTP not connection... cwd(String cwdDirectory) ");
            this.restConnection();
        }
        this.ftpClient.cwd(cwdDirectory);
    }

    public void close() {
        try {
            this.ftpClient.logout();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        try {
            this.ftpClient.disconnect();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }
}

