/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.model.dynamichql.DynamicHql;
import com.netsteadfast.greenstep.base.model.dynamichql.Query;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DynamicHqlUtils {
    protected static Logger logger = Logger.getLogger(DynamicHqlUtils.class);
    private static final String TEMPLATE_ID = "dynamic-hql-resource";
    private static Map<String, DynamicHql> resourceDataMap = new HashMap<String, DynamicHql>();

    public static DynamicHql loadResource(String resource) throws Exception {
        DynamicHql dynamicHql = resourceDataMap.get(resource);
        if (dynamicHql == null) {
            InputStream in = null;
            try {
                try {
                    in = DynamicHqlUtils.class.getResourceAsStream("/dynamichql/" + resource);
                    byte[] xmlBytes = IOUtils.toByteArray(in);
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DynamicHql.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    dynamicHql = (DynamicHql)jaxbUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xmlBytes));
                    resourceDataMap.put(resource, dynamicHql);
                }
                catch (IOException e) {
                    logger.error(e.getMessage().toString());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    IOUtils.closeQuietly(in);
                }
                in = null;
                throw throwable;
            }
            if (in != null) {
                IOUtils.closeQuietly(in);
            }
            Object var2_2 = null;
        }
        return dynamicHql;
    }

    public static String process(String resource, String queryName, Map<String, Object> paramMap) throws Exception {
        DynamicHql dynamicHql = DynamicHqlUtils.loadResource(resource);
        if (dynamicHql == null) {
            logger.error("no dynamic hql resource.");
            throw new Exception("no dynamic hql resource.");
        }
        String hql = "";
        int i = 0;
        while (i < dynamicHql.getQuery().size() && hql.length() < 1) {
            Query queryObj = dynamicHql.getQuery().get(i);
            if (queryObj.getName().equals(queryName)) {
                StringTemplateLoader templateLoader = new StringTemplateLoader();
                templateLoader.putTemplate(TEMPLATE_ID, queryObj.getContent());
                Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
                cfg.setTemplateLoader(templateLoader);
                Template template = cfg.getTemplate(TEMPLATE_ID, "utf-8");
                StringWriter out = new StringWriter();
                template.process(paramMap, out);
                hql = ((Object)out).toString();
            }
            ++i;
        }
        if (StringUtils.isBlank(hql)) {
            logger.warn("hql is blank.");
        }
        return hql;
    }
}

