/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.sys;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.base.sys.USessLogHelperImpl;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;

public class WebSystemHttpSessionListener
implements HttpSessionListener,
HttpSessionAttributeListener {
    protected Logger log = Logger.getLogger(WebSystemHttpSessionListener.class);
    private static final Map<String, HttpSession> sessionsMap = new HashMap<String, HttpSession>();
    private static Properties props = new Properties();
    private static String invalidateSameAccountSession = "Y";
    private IUSessLogHelper uSessLogHelper = new USessLogHelperImpl();

    static {
        try {
            props.load(WebSystemHttpSessionListener.class.getClassLoader().getResource("META-INF/webSystemHttpSessionListener.properties").openStream());
            invalidateSameAccountSession = SimpleUtils.getStr(props.getProperty("INVALIDATE_SAME_ACCOUNT_SESSION"), "Y");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            sessionsMap.remove(event.getSession().getId());
            if (this.uSessLogHelper.count(event.getSession().getId()) > 0L) {
                this.uSessLogHelper.delete(event.getSession().getId());
                SecurityUtils.getSubject().logout();
                this.log.info(String.valueOf(Constants.getSystem()) + " sessionDestroyed: " + event.getSession().getId() + " and do SecurityUtils.getSubject().logout().... ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        try {
            String name = event.getName();
            if ("SESSION_GSCORE_ACCOUNT".equals(name)) {
                sessionsMap.put(event.getSession().getId(), event.getSession());
            }
            this.cleanBeforeLoginUser(event);
            this.writeLoginUser(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        try {
            this.clearLoginUser(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
    }

    private void cleanBeforeLoginUser(HttpSessionBindingEvent event) throws Exception {
        if (!"Y".equals(invalidateSameAccountSession)) {
            return;
        }
        String name = event.getName();
        Object value = event.getValue();
        if ("SESSION_GSCORE_ACCOUNT".equals(name)) {
            String account = ((AccountObj)value).getAccount();
            List<String> sessionIdList = this.uSessLogHelper.findSessionIdByAccount(account);
            int ix = 0;
            while (sessionIdList != null && ix < sessionIdList.size()) {
                String sessId = sessionIdList.get(ix);
                HttpSession beforeUserHttpSession = sessionsMap.get(sessId);
                beforeUserHttpSession.invalidate();
                sessionsMap.remove(sessId);
                this.log.warn("invalidate before session:" + sessId + " account:" + account);
                ++ix;
            }
        }
    }

    private void writeLoginUser(HttpSessionBindingEvent event) throws Exception {
        String sessionId = event.getSession().getId();
        String name = event.getName();
        Object value = event.getValue();
        if ("SESSION_GSCORE_ACCOUNT".equals(name)) {
            if (this.uSessLogHelper.count(sessionId) > 0L) {
                this.uSessLogHelper.delete(sessionId);
            }
            this.uSessLogHelper.insert(sessionId, ((AccountObj)value).getAccount());
        }
    }

    private void clearLoginUser(HttpSessionBindingEvent event) throws Exception {
        String sessionId = event.getSession().getId();
        String name = event.getName();
        if ("SESSION_GSCORE_ACCOUNT".equals(name) && this.uSessLogHelper.count(sessionId) > 0L) {
            this.uSessLogHelper.delete(sessionId);
        }
    }
}

