/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.sys;

import com.netsteadfast.greenstep.base.model.AccountObj;
import com.opensymphony.xwork2.ActionContext;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserAccountHttpSessionSupport {
    protected static Logger logger = Logger.getLogger(UserAccountHttpSessionSupport.class);

    public static void create(HttpServletRequest request, AccountObj account, String language) {
        request.getSession().setAttribute("SESSION_GSCORE_ACCOUNT", (Object)account);
        request.getSession().setAttribute("SESSION_GSCORE_LANG", (Object)language);
    }

    public static void create(ActionContext actionContext, AccountObj account, String language) {
        actionContext.getSession().put("SESSION_GSCORE_ACCOUNT", account);
        actionContext.getSession().put("SESSION_GSCORE_LANG", language);
    }

    public static void createSysCurrentId(HttpServletRequest request, String sysCurrentId) {
        request.getSession().setAttribute("SESSION_GSCORE_SYSCURRENT_ID", (Object)sysCurrentId);
    }

    public static void createSysCurrentId(ActionContext actionContext, String sysCurrentId) {
        actionContext.getSession().put("SESSION_GSCORE_SYSCURRENT_ID", sysCurrentId);
    }

    public static AccountObj get(HttpServletRequest request) {
        return (AccountObj)request.getSession().getAttribute("SESSION_GSCORE_ACCOUNT");
    }

    public static AccountObj get(ActionContext actionContext) {
        return (AccountObj)actionContext.getSession().get("SESSION_GSCORE_ACCOUNT");
    }

    public static AccountObj get(Map<String, Object> session) {
        return (AccountObj)session.get("SESSION_GSCORE_ACCOUNT");
    }

    public static void remove(HttpServletRequest request) {
        try {
            request.getSession().removeAttribute("SESSION_GSCORE_ACCOUNT");
            request.getSession().removeAttribute("SESSION_GSCORE_LANG");
            request.getSession().removeAttribute("SESSION_GSCORE_SYSCURRENT_ID");
        }
        catch (Exception e) {
            logger.warn(e.getMessage().toString());
        }
    }

    public static void remove(ActionContext actionContext) {
        try {
            actionContext.getSession().remove("SESSION_GSCORE_ACCOUNT");
            actionContext.getSession().remove("SESSION_GSCORE_LANG");
            actionContext.getSession().remove("SESSION_GSCORE_SYSCURRENT_ID");
        }
        catch (Exception e) {
            logger.warn(e.getMessage().toString());
        }
    }

    public static void remove(Map<String, Object> session) {
        try {
            session.remove("SESSION_GSCORE_ACCOUNT");
            session.remove("SESSION_GSCORE_LANG");
            session.remove("SESSION_GSCORE_SYSCURRENT_ID");
        }
        catch (Exception e) {
            logger.warn(e.getMessage().toString());
        }
    }

    public static String getLang(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("SESSION_GSCORE_LANG");
    }

    public static String getLang(ActionContext actionContext) {
        return (String)actionContext.getSession().get("SESSION_GSCORE_LANG");
    }

    public static String getLang(Map<String, Object> session) {
        return (String)session.get("SESSION_GSCORE_LANG");
    }

    public static String getSysCurrentId(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("SESSION_GSCORE_SYSCURRENT_ID");
    }

    public static String getSysCurrentId(ActionContext actionContext) {
        return (String)actionContext.getSession().get("SESSION_GSCORE_SYSCURRENT_ID");
    }

    public static String getSysCurrentId(Map<String, Object> session) {
        return (String)session.get("SESSION_GSCORE_SYSCURRENT_ID");
    }
}

