/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;

public class DynamicHqlQueryParamHandler
implements Serializable {
    private static final long serialVersionUID = 8844134742123809153L;
    private static final String FULL_EQUALS = "FULL_EQUALS";
    private static final String BEGINNING_LIKE = "BEGINNING_LIKE";
    private static final String ENDING_LIKE = "ENDING_LIKE";
    private static final String CONTAINING_LIKE = "CONTAINING_LIKE";
    private static final String EQUALS_LIKE = "EQUALS_LIKE";
    private Map<String, Object> value = new LinkedHashMap<String, Object>();
    private Map<String, Object> root = new HashMap<String, Object>();
    private Map<String, String> sourceSearchParameter;

    public DynamicHqlQueryParamHandler() {
    }

    public DynamicHqlQueryParamHandler(Map<String, String> sourceSearchParameter) {
        this.sourceSearchParameter = sourceSearchParameter;
    }

    public Map<String, String> getSourceSearchParameter() {
        return this.sourceSearchParameter;
    }

    public void setSourceSearchParameter(Map<String, String> sourceSearchParameter) {
        this.sourceSearchParameter = sourceSearchParameter;
    }

    public void setSourceSearchParameterAndRoot(Map<String, String> sourceSearchParameter) {
        this.sourceSearchParameter = sourceSearchParameter;
        if (this.sourceSearchParameter != null) {
            this.root.putAll(this.sourceSearchParameter);
        }
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public DynamicHqlQueryParamHandler addExprVariable(String key, Object value) {
        this.root.put(key, value);
        return this;
    }

    public DynamicHqlQueryParamHandler fullEquals4TextField(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckNoBlank(value)) {
            this.putValue(FULL_EQUALS, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler fullEquals4Select(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckWithSelectId(value)) {
            this.putValue(FULL_EQUALS, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler fullEquals(String field, String expression) {
        String value = this.sourceSearchParameter.get(field);
        if (this.root.get(field) == null) {
            this.root.put(field, value);
        }
        if (this.parse(expression)) {
            this.putValue(FULL_EQUALS, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler beginningLike(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckNoBlank(value)) {
            this.putValue(BEGINNING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler beginningLike(String field, String expression) {
        String value = this.sourceSearchParameter.get(field);
        if (this.root.get(field) == null) {
            this.root.put(field, value);
        }
        if (this.parse(expression)) {
            this.putValue(BEGINNING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler endingLike(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckNoBlank(value)) {
            this.putValue(ENDING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler endingLike(String field, String expression) {
        String value = this.sourceSearchParameter.get(field);
        if (this.root.get(field) == null) {
            this.root.put(field, value);
        }
        if (this.parse(expression)) {
            this.putValue(ENDING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler containingLike(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckNoBlank(value)) {
            this.putValue(CONTAINING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler containingLike(String field, String expression) {
        String value = this.sourceSearchParameter.get(field);
        if (this.root.get(field) == null) {
            this.root.put(field, value);
        }
        if (this.parse(expression)) {
            this.putValue(CONTAINING_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler equalsLike(String field) {
        String value = this.sourceSearchParameter.get(field);
        if (this.defaultCheckNoBlank(value)) {
            this.putValue(EQUALS_LIKE, field, value);
        }
        return this;
    }

    public DynamicHqlQueryParamHandler equalsLike(String field, String expression) {
        String value = this.sourceSearchParameter.get(field);
        if (this.root.get(field) == null) {
            this.root.put(field, value);
        }
        if (this.parse(expression)) {
            this.putValue(EQUALS_LIKE, field, value);
        }
        return this;
    }

    private boolean defaultCheckWithSelectId(String value) {
        if (StringUtils.isBlank(value)) {
            return false;
        }
        return !"all".equals(value);
    }

    private boolean defaultCheckNoBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    private boolean parse(String expression) {
        boolean c = false;
        try {
            c = "true".equals(String.valueOf(Ognl.getValue(expression, this.root)).toLowerCase());
        }
        catch (OgnlException e) {
            e.printStackTrace();
        }
        return c;
    }

    private void putValue(String type, String field, String value) {
        if (FULL_EQUALS.equals(type) || EQUALS_LIKE.equals(type)) {
            this.value.put(field, value);
        } else if (BEGINNING_LIKE.equals(type)) {
            this.value.put(field, String.valueOf(value) + "%");
        } else if (ENDING_LIKE.equals(type)) {
            this.value.put(field, "%" + value);
        } else if (CONTAINING_LIKE.equals(type)) {
            this.value.put(field, "%" + value + "%");
        }
    }
}

