/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.filter;

import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.base.sys.USessLogHelperImpl;
import com.netsteadfast.greenstep.base.sys.UserCurrentCookie;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class WebLoginCheckFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private IUSessLogHelper uSessLogHelper = null;

    private boolean isLogin(HttpServletRequest httpRequest, AccountObj accountObj) {
        Map<String, String> dataMap = UserCurrentCookie.getCurrentData(httpRequest);
        String account = StringUtils.defaultString(dataMap.get("account"));
        String currentId = StringUtils.defaultString(dataMap.get("currentId"));
        if (StringUtils.isBlank(account)) {
            return false;
        }
        if (!accountObj.getAccount().equals(account)) {
            return false;
        }
        try {
            if (this.uSessLogHelper.countByCurrent(account, currentId) > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object accountObj;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String redirectUrl = this.filterConfig.getInitParameter("redirectUrl");
        if (StringUtils.isBlank(redirectUrl)) {
            redirectUrl = "/pages/system/login_again.jsp";
        }
        if ((accountObj = httpRequest.getSession().getAttribute("SESSION_GSCORE_ACCOUNT")) == null || !(accountObj instanceof AccountObj)) {
            httpResponse.sendRedirect(String.valueOf(request.getServletContext().getContextPath()) + redirectUrl);
            return;
        }
        if (!this.isLogin(httpRequest, (AccountObj)accountObj)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.uSessLogHelper = new USessLogHelperImpl();
    }
}

