/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Member;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;

public class MemberSelection
extends TreeNode<Member> {
    private Set<Member> selection = new HashSet<Member>();
    private Cube cube;
    private MemberHierarchyCache memberHierarchyCache;

    public MemberSelection(Cube cube) {
        super(null);
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        this.cube = cube;
    }

    public MemberSelection(List<Member> members, Cube cube) {
        super(null);
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        this.cube = cube;
        this.addMembers(members);
    }

    public void addMembers(List<Member> members) {
        for (Member member : members) {
            this.addMember(member);
        }
    }

    public void addMember(Member member) {
        TreeNode parent = this;
        OlapUtils utils = new OlapUtils(this.cube);
        utils.setMemberHierarchyCache(this.memberHierarchyCache);
        Member wrappedMember = utils.wrapRaggedIfNecessary(member);
        ArrayList ancestors = new ArrayList(wrappedMember.getAncestorMembers());
        Collections.reverse(ancestors);
        for (Member ancestor : ancestors) {
            if (utils.getBaseRaggedMember(ancestor = utils.wrapRaggedIfNecessary(ancestor)).getDepth() != ancestor.getDepth()) continue;
            SelectionNode node = this.findChild(ancestor);
            if (node == null) {
                node = new SelectionNode(ancestor, false);
                parent.addChild(node);
            }
            parent = node;
        }
        SelectionNode node = this.findChild(wrappedMember);
        if (node == null) {
            node = new SelectionNode(wrappedMember, true);
            parent.addChild(node);
        } else {
            ((SelectionNode)node).setSelected(true);
        }
        if (!this.isSelected(wrappedMember)) {
            this.selection.add(wrappedMember);
        }
    }

    public void removeMember(Member member) {
        SelectionNode node = (SelectionNode)this.findChild(member);
        if (node == null) {
            throw new IllegalArgumentException("The specified member does not belong to the selection tree.");
        }
        node.getParent().removeChild(node);
        if (this.isSelected(member)) {
            this.selection.remove(member);
        }
    }

    public boolean isSelected(Member member) {
        if (member == null) {
            return false;
        }
        OlapUtils utils = new OlapUtils(this.cube);
        utils.setMemberHierarchyCache(this.memberHierarchyCache);
        Member wrappedMember = utils.wrapRaggedIfNecessary(member);
        return this.selection.contains(wrappedMember);
    }

    public List<Member> getMembers() {
        final ArrayList<Member> members = new ArrayList<Member>();
        TreeNodeCallback<Member> callback = new TreeNodeCallback<Member>(){

            @Override
            public int handleTreeNode(TreeNode<Member> node) {
                if (((SelectionNode)node).isSelected()) {
                    members.add(node.getReference());
                }
                return 0;
            }
        };
        this.walkChildren(callback);
        return members;
    }

    public boolean canMoveUp(Member member) {
        SelectionNode node = (SelectionNode)this.findChild(member);
        if (node == null) {
            throw new IllegalArgumentException("The specified member does not belong to the selection tree.");
        }
        int index = node.getParent().getChildren().indexOf(node);
        return index > 0;
    }

    public boolean canMoveDown(Member member) {
        SelectionNode node = (SelectionNode)this.findChild(member);
        if (node == null) {
            throw new IllegalArgumentException("The specified member does not belong to the selection tree.");
        }
        int index = node.getParent().getChildren().indexOf(node);
        return index < node.getParent().getChildCount() - 1;
    }

    public void moveUp(Member member) {
        SelectionNode node = (SelectionNode)this.findChild(member);
        if (node == null) {
            throw new IllegalArgumentException("The specified member does not belong to the selection tree.");
        }
        TreeNode<Object> parentNode = node.getParent();
        List siblings = parentNode.getChildren();
        int index = siblings.indexOf(node);
        TreeNode targetNode = siblings.get(index - 1);
        parentNode.removeChild(node);
        parentNode.removeChild(targetNode);
        parentNode.addChild(index - 1, node);
        parentNode.addChild(index, targetNode);
    }

    public void moveDown(Member member) {
        SelectionNode node = (SelectionNode)this.findChild(member);
        if (node == null) {
            throw new IllegalArgumentException("The specified member does not belong to the selection tree.");
        }
        TreeNode<Object> parentNode = node.getParent();
        List siblings = parentNode.getChildren();
        int index = siblings.indexOf(node);
        TreeNode targetNode = siblings.get(index + 1);
        parentNode.removeChild(node);
        parentNode.removeChild(targetNode);
        parentNode.addChild(index, targetNode);
        parentNode.addChild(index + 1, node);
    }

    public MemberHierarchyCache getMemberHierarchyCache() {
        return this.memberHierarchyCache;
    }

    public void setMemberHierarchyCache(MemberHierarchyCache memberHierarchyCache) {
        this.memberHierarchyCache = memberHierarchyCache;
    }

    static class SelectionNode
    extends TreeNode<Member> {
        private boolean selected;

        SelectionNode(Member member, boolean selected) {
            super(member);
            this.selected = selected;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

