/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;

public class MarkupWriter {
    private PrintWriter writer;
    private boolean formatOutput = true;
    private int indent = 0;
    private int indentSize = 1;
    private char indentCharacter = (char)9;

    public MarkupWriter(Writer writer) {
        if (writer == null) {
            throw new NullArgumentException("writer");
        }
        this.writer = new PrintWriter(writer);
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public boolean getFormatOutput() {
        return this.formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public char getIndentCharacter() {
        return this.indentCharacter;
    }

    public void setIndentCharacter(char indentCharacter) {
        this.indentCharacter = indentCharacter;
    }

    protected void writeIndent() {
        for (int i = 0; i < this.indent * this.indentSize; ++i) {
            this.writer.print(this.indentCharacter);
        }
    }

    public void startElement(String name, Map<String, String> attributes) {
        if (this.formatOutput) {
            this.writeIndent();
            ++this.indent;
        }
        this.writer.print('<');
        this.writer.print(name);
        if (attributes != null) {
            if (attributes.containsKey("id")) {
                this.writeAttribute("id", attributes.get("id"));
            }
            for (String attributeName : attributes.keySet()) {
                if ("id".equals(attributeName)) continue;
                this.writeAttribute(attributeName, attributes.get(attributeName));
            }
        }
        this.writer.print('>');
        if (this.formatOutput) {
            this.writer.println();
        }
    }

    public void writeAttribute(String attributeName, String attributeValue) {
        this.writer.print(' ');
        this.writer.print(attributeName);
        this.writer.print("=\"");
        this.writer.print(StringUtils.trimToEmpty((String)attributeValue));
        this.writer.print("\"");
    }

    public void writeContent(String content) {
        if (this.formatOutput) {
            this.writeIndent();
        }
        this.writer.print(StringUtils.trimToEmpty((String)content));
        if (this.formatOutput) {
            this.writer.println();
        }
    }

    public void endElement(String name) {
        if (this.formatOutput) {
            --this.indent;
            this.writeIndent();
        }
        this.writer.print("</");
        this.writer.print(name);
        this.writer.print('>');
        if (this.formatOutput) {
            this.writer.println();
        }
    }
}

