/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Property;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.ui.aggregator.AggregatorPosition;
import org.pivot4j.ui.collector.PropertyCollector;
import org.pivot4j.ui.table.TableRenderer;
import org.pivot4j.util.MemberHierarchyCache;

class TableAxisContext
implements Cloneable {
    private Axis axis;
    private List<Hierarchy> hierarchies;
    private Map<AggregatorPosition, List<Aggregator>> aggregators;
    private Map<Hierarchy, List<Level>> levelMap;
    private Map<Level, List<Property>> propertyMap;
    private TableRenderer renderer;
    private MemberHierarchyCache memberHierarchyCache;
    private Map<String, Integer> rowSpanCache = new HashMap<String, Integer>();

    TableAxisContext(Cube cube, Axis axis, List<Hierarchy> hierarchies, Map<Hierarchy, List<Level>> levels, Map<AggregatorPosition, List<Aggregator>> aggregators, MemberHierarchyCache cache, TableRenderer renderer) {
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (hierarchies == null) {
            throw new NullArgumentException("hierarchies");
        }
        if (levels == null) {
            throw new NullArgumentException("levels");
        }
        if (renderer == null) {
            throw new NullArgumentException("renderer");
        }
        this.axis = axis;
        this.hierarchies = hierarchies;
        this.levelMap = levels;
        this.aggregators = aggregators == null ? new HashMap<AggregatorPosition, List<Aggregator>>() : aggregators;
        this.memberHierarchyCache = cache == null ? new MemberHierarchyCache(cube) : cache;
        this.renderer = renderer;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public List<Hierarchy> getHierarchies() {
        return Collections.unmodifiableList(this.hierarchies);
    }

    public List<Level> getLevels(Hierarchy hierarchy) {
        return Collections.unmodifiableList(this.levelMap.get(hierarchy));
    }

    public List<Aggregator> getAggregators(AggregatorPosition position) {
        List<Aggregator> result = this.aggregators.get((Object)position);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public TableRenderer getRenderer() {
        return this.renderer;
    }

    public List<Property> getProperties(Level level) {
        List<Property> properties;
        PropertyCollector collector = this.renderer.getPropertyCollector();
        if (collector == null) {
            return Collections.emptyList();
        }
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<Level, List<Property>>();
        }
        if ((properties = this.propertyMap.get(level)) == null) {
            properties = collector.getProperties(level);
            this.propertyMap.put(level, properties);
        }
        return Collections.unmodifiableList(properties);
    }

    public MemberHierarchyCache getMemberHierarchyCache() {
        return this.memberHierarchyCache;
    }

    public Map<String, Integer> getRowSpanCache() {
        return this.rowSpanCache;
    }
}

