/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.property;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.pivot4j.el.ExpressionEvaluator;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.property.AbstractRenderProperty;

public class SimpleRenderProperty
extends AbstractRenderProperty {
    private String value;

    SimpleRenderProperty() {
    }

    public SimpleRenderProperty(String name) {
        super(name);
    }

    public SimpleRenderProperty(String name, String value) {
        super(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Object getValue(RenderContext context) {
        if (context == null) {
            throw new NullArgumentException("context");
        }
        if (this.value == null) {
            return null;
        }
        ExpressionEvaluator evaluator = context.getExpressionEvaluator();
        return ObjectUtils.toString((Object)evaluator.evaluate(this.value, context.getExpressionContext()));
    }

    @Override
    public Serializable saveState() {
        return new Serializable[]{super.saveState(), this.value};
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        super.restoreState(states[0]);
        this.value = (String)((Object)states[1]);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.value != null) {
            configuration.setProperty("value", (Object)this.value);
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        super.restoreSettings(configuration);
        this.value = configuration.getString("value");
    }
}

