/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.property;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.pivot4j.ui.condition.ConditionFactory;
import org.pivot4j.ui.property.AbstractRenderProperty;
import org.pivot4j.ui.property.ConditionalRenderProperty;
import org.pivot4j.ui.property.RenderProperty;
import org.pivot4j.ui.property.RenderPropertyList;
import org.pivot4j.ui.property.SimpleRenderProperty;

public class DefaultRenderPropertyList
implements RenderPropertyList {
    private SortedMap<String, RenderProperty> properties = new TreeMap<String, RenderProperty>();
    private ConditionFactory conditionFactory;

    public DefaultRenderPropertyList(ConditionFactory conditionFactory) {
        if (conditionFactory == null) {
            throw new NullArgumentException("conditionFactory");
        }
        this.conditionFactory = conditionFactory;
    }

    protected ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    @Override
    public List<RenderProperty> getRenderProperties() {
        return new LinkedList<RenderProperty>(this.properties.values());
    }

    @Override
    public RenderProperty getRenderProperty(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return (RenderProperty)this.properties.get(name);
    }

    @Override
    public void setRenderProperty(RenderProperty property) {
        if (property == null) {
            throw new NullArgumentException("property");
        }
        this.properties.put(property.getName(), property);
    }

    @Override
    public void removeRenderProperty(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        this.properties.remove(name);
    }

    @Override
    public boolean hasRenderProperty(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return this.properties.containsKey(name);
    }

    @Override
    public Serializable saveState() {
        Collection<RenderProperty> propertyList = this.properties.values();
        Serializable[] states = new Serializable[propertyList.size()];
        int index = 0;
        for (RenderProperty property : propertyList) {
            boolean conditional = property instanceof ConditionalRenderProperty;
            states[index++] = new Serializable[]{Boolean.valueOf(conditional), property.saveState()};
        }
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        Serializable[] states = (Serializable[])state;
        this.properties.clear();
        for (Serializable st : states) {
            Serializable[] pair = (Serializable[])st;
            boolean conditional = (Boolean)pair[0];
            AbstractRenderProperty property = conditional ? new ConditionalRenderProperty(this.conditionFactory) : new SimpleRenderProperty();
            property.restoreState(pair[1]);
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        int index = 0;
        for (RenderProperty property : this.properties.values()) {
            String name = String.format("property(%s)", index++);
            configuration.setProperty(name, (Object)"");
            SubnodeConfiguration propertyConfig = configuration.configurationAt(name);
            property.saveSettings((HierarchicalConfiguration)propertyConfig);
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.properties.clear();
        try {
            List configurations = configuration.configurationsAt("property");
            for (HierarchicalConfiguration propertyConfig : configurations) {
                boolean conditional = propertyConfig.containsKey("conditions");
                AbstractRenderProperty property = conditional ? new ConditionalRenderProperty(this.conditionFactory) : new SimpleRenderProperty();
                property.restoreSettings(propertyConfig);
                this.properties.put(property.getName(), property);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

