/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.property;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.pivot4j.ui.property.RenderProperty;

public abstract class AbstractRenderProperty
implements RenderProperty {
    private String name;

    AbstractRenderProperty() {
    }

    public AbstractRenderProperty(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Serializable saveState() {
        return this.name;
    }

    @Override
    public void restoreState(Serializable state) {
        this.name = (String)((Object)state);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        configuration.setProperty("[@name]", (Object)this.name);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.name = configuration.getString("[@name]");
    }

    @Override
    public int compareTo(RenderProperty property) {
        if (property == null) {
            return -1;
        }
        return this.name.compareTo(property.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).toString();
    }
}

