/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.poi;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.olap4j.Axis;
import org.pivot4j.PivotException;
import org.pivot4j.ui.AbstractContentRenderCallback;
import org.pivot4j.ui.command.UICommand;
import org.pivot4j.ui.poi.Format;
import org.pivot4j.ui.table.TableRenderCallback;
import org.pivot4j.ui.table.TableRenderContext;

public class ExcelExporter
extends AbstractContentRenderCallback<TableRenderContext>
implements TableRenderCallback {
    private Format format = Format.HSSF;
    private Workbook workbook;
    private Sheet sheet;
    private Row row;
    private Cell cell;
    private CellStyle headerCellStyle;
    private CellStyle valueCellStyle;
    private CellStyle aggregationCellStyle;
    private List<CellRangeAddress> mergedRegions;
    private String fontFamily = "Arial";
    private int fontSize = 10;
    private int sheetIndex = 0;

    public ExcelExporter(OutputStream out) {
        super(out);
    }

    @Override
    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public void startRender(TableRenderContext context) {
        this.sheet = null;
        this.row = null;
        this.cell = null;
        this.mergedRegions = new ArrayList<CellRangeAddress>();
        this.sheetIndex = 0;
        this.headerCellStyle = null;
        this.valueCellStyle = null;
        this.workbook = this.createWorkbook();
    }

    @Override
    public void startTable(TableRenderContext context) {
        this.sheet = this.createSheet(context, this.workbook);
    }

    @Override
    public void startHeader(TableRenderContext context) {
    }

    @Override
    public void endHeader(TableRenderContext context) {
    }

    @Override
    public void startBody(TableRenderContext context) {
    }

    @Override
    public void startRow(TableRenderContext context) {
        this.row = this.createRow(this.sheet, context.getRowIndex() + this.getRowOffset());
    }

    @Override
    public void startCell(TableRenderContext context) {
        this.cell = this.createCell(this.row, context.getColumnIndex() + this.getColOffset());
    }

    @Override
    public void renderCommands(TableRenderContext context, List<UICommand<?>> commands) {
    }

    @Override
    public void renderContent(TableRenderContext context, String label, Double value) {
        this.cell.setCellStyle(this.getCellStyle(context));
        if ("value".equals(context.getCellType()) && context.getAxis() != Axis.FILTER) {
            if (value == null) {
                this.cell.setCellValue("");
            } else {
                this.cell.setCellValue(value.doubleValue());
            }
        } else {
            boolean showParentMembers = context.getRenderer().getShowParentMembers();
            if (!showParentMembers && label != null && context.getAxis() == Axis.ROWS && context.getMember() != null && context.getCell() == null) {
                label = StringUtils.leftPad((String)label, (int)(context.getMember().getDepth() + label.length()));
            }
            this.cell.setCellValue(label);
            this.cell.setCellType(1);
        }
    }

    @Override
    public void endCell(TableRenderContext context) {
        this.cell = null;
        CellRangeAddress range = this.createMergedRegion(context);
        if (range != null) {
            this.mergedRegions.add(range);
        }
    }

    @Override
    public void endRow(TableRenderContext context) {
        this.row = null;
    }

    @Override
    public void endBody(TableRenderContext context) {
    }

    @Override
    public void endTable(TableRenderContext context) {
        this.mergeCells(context, this.sheet, this.mergedRegions);
        this.adjustColumnSizes(context, this.sheet);
        this.mergedRegions.clear();
        this.sheet = null;
    }

    @Override
    public void endRender(TableRenderContext context) {
        try {
            this.workbook.write(this.getOutputStream());
        }
        catch (IOException e) {
            throw new PivotException(e);
        }
    }

    protected Workbook createWorkbook() {
        XSSFWorkbook newWorkbook = null;
        switch (this.format) {
            case XSSF: {
                newWorkbook = new XSSFWorkbook();
                break;
            }
            case HSSF: {
                newWorkbook = new HSSFWorkbook();
                break;
            }
            case SXSSF: {
                newWorkbook = new SXSSFWorkbook(500);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return newWorkbook;
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    protected Sheet createSheet(TableRenderContext context, Workbook workbook) {
        Sheet newSheet = workbook.createSheet(WorkbookUtil.createSafeSheetName((String)this.getSheetName(context, this.sheetIndex)));
        ++this.sheetIndex;
        return newSheet;
    }

    protected String getSheetName(TableRenderContext context, int sheetIndex) {
        String name = context.getAxis() == Axis.FILTER ? context.getResourceBundle().getString("label.filter") : context.getModel().getCube().getCaption();
        return name;
    }

    protected Sheet getSheet() {
        return this.sheet;
    }

    protected int getRowOffset() {
        return 0;
    }

    protected int getColOffset() {
        return 0;
    }

    protected Row createRow(Sheet sheet, int rowIndex) {
        return sheet.createRow(rowIndex);
    }

    protected Row getRow() {
        return this.row;
    }

    protected Cell createCell(Row row, int colIndex) {
        return row.createCell(colIndex);
    }

    protected Cell getCell() {
        return this.cell;
    }

    protected CellStyle createHeaderCellStyle() {
        CellStyle style = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontName(this.fontFamily);
        font.setFontHeightInPoints((short)this.fontSize);
        font.setBoldweight((short)700);
        style.setFont(font);
        style.setAlignment((short)1);
        style.setVerticalAlignment((short)1);
        switch (this.format) {
            case XSSF: 
            case SXSSF: {
                ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(Color.lightGray));
                break;
            }
            case HSSF: {
                style.setFillForegroundColor((short)22);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        style.setFillPattern((short)1);
        style.setBorderTop((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        return style;
    }

    protected CellStyle getHeaderCellStyle() {
        if (this.headerCellStyle == null) {
            this.headerCellStyle = this.createHeaderCellStyle();
        }
        return this.headerCellStyle;
    }

    protected CellStyle createValueCellStyle() {
        CellStyle style = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontName(this.fontFamily);
        font.setFontHeightInPoints((short)this.fontSize);
        font.setBoldweight((short)400);
        style.setFont(font);
        style.setAlignment((short)3);
        style.setVerticalAlignment((short)1);
        style.setBorderTop((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setDataFormat((short)4);
        return style;
    }

    protected CellStyle getValueCellStyle() {
        if (this.valueCellStyle == null) {
            this.valueCellStyle = this.createValueCellStyle();
        }
        return this.valueCellStyle;
    }

    protected CellStyle createAggregationCellStyle() {
        CellStyle style = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontName(this.fontFamily);
        font.setFontHeightInPoints((short)this.fontSize);
        font.setBoldweight((short)400);
        style.setFont(font);
        style.setAlignment((short)3);
        style.setVerticalAlignment((short)1);
        switch (this.format) {
            case XSSF: 
            case SXSSF: {
                ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(Color.lightGray));
                break;
            }
            case HSSF: {
                style.setFillForegroundColor((short)22);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        style.setFillPattern((short)1);
        style.setBorderTop((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setDataFormat((short)4);
        return style;
    }

    protected CellStyle getAggregationCellStyle() {
        if (this.aggregationCellStyle == null) {
            this.aggregationCellStyle = this.createAggregationCellStyle();
        }
        return this.aggregationCellStyle;
    }

    protected CellStyle getCellStyle(TableRenderContext context) {
        if ("value".equals(context.getCellType())) {
            if (context.getAggregator() == null) {
                return this.getValueCellStyle();
            }
            return this.getAggregationCellStyle();
        }
        return this.getHeaderCellStyle();
    }

    protected CellRangeAddress createMergedRegion(TableRenderContext context) {
        if (context.getColumnSpan() > 1 || context.getRowSpan() > 1) {
            int firstRow = context.getRowIndex() + this.getRowOffset();
            int lastRow = firstRow + context.getRowSpan() - 1;
            int firstCol = context.getColumnIndex() + this.getColOffset();
            int lastCol = firstCol + context.getColumnSpan() - 1;
            return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        }
        return null;
    }

    protected void mergeCells(TableRenderContext context, Sheet sheet, List<CellRangeAddress> regions) {
        for (CellRangeAddress region : regions) {
            sheet.addMergedRegion(region);
        }
    }

    protected void adjustColumnSizes(TableRenderContext context, Sheet sheet) {
        for (int i = 0; i < context.getColumnCount(); ++i) {
            try {
                sheet.autoSizeColumn(this.getColOffset() + i, !this.mergedRegions.isEmpty());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

