/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.html;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.ui.AbstractMarkupRenderCallback;
import org.pivot4j.ui.command.UICommand;
import org.pivot4j.ui.table.TableRenderCallback;
import org.pivot4j.ui.table.TableRenderContext;
import org.pivot4j.util.CssWriter;
import org.pivot4j.util.RenderPropertyUtils;

public class HtmlRenderCallback
extends AbstractMarkupRenderCallback<TableRenderContext>
implements TableRenderCallback {
    private String tableId;
    private String tableStyleClass = "pv-table";
    private Integer border;
    private Integer cellSpacing;
    private Integer cellPadding;
    private String rowStyleClass = "pv-row";
    private String evenRowStyleClass = "pv-row-even";
    private String oddRowStyleClass = "pv-row-odd";
    private String columnHeaderStyleClass = "pv-col-hdr";
    private String rowHeaderStyleClass = "pv-row-hdr";
    private String columnTitleStyleClass = this.columnHeaderStyleClass;
    private String rowTitleStyleClass = this.rowHeaderStyleClass;
    private String cellStyleClass = "pv-cell";
    private String cornerStyleClass = "pv-corner";
    private int rowHeaderLevelPadding = 10;

    public HtmlRenderCallback(Writer writer) {
        super(writer);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableStyleClass() {
        return this.tableStyleClass;
    }

    public void setTableStyleClass(String tableStyleClass) {
        this.tableStyleClass = tableStyleClass;
    }

    public Integer getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Integer cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public Integer getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(Integer cellPadding) {
        this.cellPadding = cellPadding;
    }

    public Integer getBorder() {
        return this.border;
    }

    public void setBorder(Integer border) {
        this.border = border;
    }

    public String getRowStyleClass() {
        return this.rowStyleClass;
    }

    public void setRowStyleClass(String rowStyleClass) {
        this.rowStyleClass = rowStyleClass;
    }

    public String getEvenRowStyleClass() {
        return this.evenRowStyleClass;
    }

    public void setEvenRowStyleClass(String evenRowStyleClass) {
        this.evenRowStyleClass = evenRowStyleClass;
    }

    public String getOddRowStyleClass() {
        return this.oddRowStyleClass;
    }

    public void setOddRowStyleClass(String oddRowStyleClass) {
        this.oddRowStyleClass = oddRowStyleClass;
    }

    public String getColumnHeaderStyleClass() {
        return this.columnHeaderStyleClass;
    }

    public void setColumnHeaderStyleClass(String columnHeaderStyleClass) {
        this.columnHeaderStyleClass = columnHeaderStyleClass;
    }

    public String getRowHeaderStyleClass() {
        return this.rowHeaderStyleClass;
    }

    public void setRowHeaderStyleClass(String rowHeaderStyleClass) {
        this.rowHeaderStyleClass = rowHeaderStyleClass;
    }

    public String getColumnTitleStyleClass() {
        return this.columnTitleStyleClass;
    }

    public void setColumnTitleStyleClass(String columnTitleStyleClass) {
        this.columnTitleStyleClass = columnTitleStyleClass;
    }

    public String getRowTitleStyleClass() {
        return this.rowTitleStyleClass;
    }

    public void setRowTitleStyleClass(String rowTitleStyleClass) {
        this.rowTitleStyleClass = rowTitleStyleClass;
    }

    public String getCellStyleClass() {
        return this.cellStyleClass;
    }

    public void setCellStyleClass(String cellStyleClass) {
        this.cellStyleClass = cellStyleClass;
    }

    public String getCornerStyleClass() {
        return this.cornerStyleClass;
    }

    public void setCornerStyleClass(String cornerStyleClass) {
        this.cornerStyleClass = cornerStyleClass;
    }

    public int getRowHeaderLevelPadding() {
        return this.rowHeaderLevelPadding;
    }

    public void setRowHeaderLevelPadding(int rowHeaderLevelPadding) {
        this.rowHeaderLevelPadding = rowHeaderLevelPadding;
    }

    @Override
    public void startTable(TableRenderContext context) {
        this.startElement("table", this.getTableAttributes(context));
    }

    protected Map<String, String> getTableAttributes(TableRenderContext context) {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        if (this.tableId != null) {
            attributes.put("id", this.tableId);
        }
        if (this.tableStyleClass != null) {
            attributes.put("class", this.tableStyleClass);
        }
        if (this.cellSpacing != null) {
            attributes.put("cellspacing", Integer.toString(this.cellSpacing));
        }
        if (this.cellPadding != null) {
            attributes.put("cellpadding", Integer.toString(this.cellPadding));
        }
        if (this.border != null) {
            attributes.put("border", Integer.toString(this.border));
        }
        return attributes;
    }

    @Override
    public void startHeader(TableRenderContext context) {
        this.startElement("thead", this.getHeaderAttributes(context));
    }

    protected Map<String, String> getHeaderAttributes(TableRenderContext context) {
        return Collections.emptyMap();
    }

    @Override
    public void endHeader(TableRenderContext context) {
        this.endElement("thead");
    }

    @Override
    public void startBody(TableRenderContext context) {
        this.startElement("tbody", this.getBodyAttributes(context));
    }

    protected Map<String, String> getBodyAttributes(TableRenderContext context) {
        return Collections.emptyMap();
    }

    @Override
    public void startRow(TableRenderContext context) {
        this.startElement("tr", this.getRowAttributes(context));
    }

    protected Map<String, String> getRowAttributes(TableRenderContext context) {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        int index = context.getRowIndex() - context.getColumnHeaderCount();
        if (index < 0) {
            index = context.getRowIndex();
        }
        if (this.rowStyleClass != null || this.evenRowStyleClass != null || this.oddRowStyleClass != null) {
            boolean even;
            boolean first = true;
            StringBuilder builder = new StringBuilder();
            if (this.rowStyleClass != null) {
                builder.append(this.rowStyleClass);
                first = false;
            }
            boolean bl = even = index % 2 == 0;
            if (even && this.evenRowStyleClass != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(' ');
                }
                builder.append(this.evenRowStyleClass);
            } else if (!even && this.oddRowStyleClass != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(' ');
                }
                builder.append(this.oddRowStyleClass);
            }
            attributes.put("class", builder.toString());
        }
        return attributes;
    }

    @Override
    public void startCell(TableRenderContext context) {
        String tagName = "value".equals(context.getCellType()) || "aggValue".equals(context.getCellType()) ? "td" : "th";
        this.startElement(tagName, this.getCellAttributes(context));
    }

    protected Map<String, String> getCellAttributes(TableRenderContext context) {
        String styleClassValue;
        String styleClass = null;
        StringWriter writer = new StringWriter();
        CssWriter cssWriter = new CssWriter(writer);
        if ("label".equals(context.getCellType())) {
            if (context.getAxis() == Axis.COLUMNS) {
                styleClass = this.columnHeaderStyleClass;
            } else {
                styleClass = this.rowHeaderStyleClass;
                if (this.rowHeaderLevelPadding > 0) {
                    int padding = this.rowHeaderLevelPadding * (1 + context.getMember().getDepth());
                    cssWriter.writeStyle("padding-left", padding + "px");
                }
            }
        } else if ("title".equals(context.getCellType()) || "aggValue".equals(context.getCellType())) {
            if (context.getAxis() == Axis.COLUMNS) {
                styleClass = this.columnTitleStyleClass;
            } else if (context.getAxis() == Axis.ROWS) {
                styleClass = this.rowTitleStyleClass;
            }
        } else if ("value".equals(context.getCellType())) {
            styleClass = this.cellStyleClass;
        } else if ("fill".equals(context.getCellType())) {
            styleClass = this.cornerStyleClass;
        }
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        String propertyCategory = context.getRenderPropertyCategory();
        RenderPropertyUtils propertyUtils = this.getRenderPropertyUtils();
        cssWriter.writeStyle("color", propertyUtils.getString("fgColor", propertyCategory, null));
        String bgColor = propertyUtils.getString("bgColor", propertyCategory, null);
        if (bgColor != null) {
            cssWriter.writeStyle("background-color", bgColor);
            cssWriter.writeStyle("background-image", "none");
        }
        cssWriter.writeStyle("font-family", propertyUtils.getString("fontFamily", propertyCategory, null));
        cssWriter.writeStyle("font-size", propertyUtils.getString("fontSize", propertyCategory, null));
        String fontStyle = propertyUtils.getString("fontStyle", propertyCategory, null);
        if (fontStyle != null) {
            if (fontStyle.contains("bold")) {
                cssWriter.writeStyle("font-weight", "bold");
            }
            if (fontStyle.contains("italic")) {
                cssWriter.writeStyle("font-style", "oblique");
            }
        }
        if ((styleClassValue = this.getRenderPropertyUtils().getString("styleClass", context.getRenderPropertyCategory(), null)) != null) {
            styleClass = styleClass == null ? styleClassValue : styleClass + " " + styleClassValue;
        }
        if (styleClass != null) {
            attributes.put("class", styleClass);
        }
        writer.flush();
        IOUtils.closeQuietly((Writer)writer);
        String style = writer.toString();
        if (StringUtils.isNotEmpty((String)style)) {
            attributes.put("style", style);
        }
        if (context.getColumnSpan() > 1) {
            attributes.put("colspan", Integer.toString(context.getColumnSpan()));
        }
        if (context.getRowSpan() > 1) {
            attributes.put("rowspan", Integer.toString(context.getRowSpan()));
        }
        return attributes;
    }

    @Override
    public void renderCommands(TableRenderContext context, List<UICommand<?>> commands) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderContent(TableRenderContext context, String label, Double value) {
        String text;
        ExpressionContext elContext = context.getExpressionContext();
        elContext.put("label", label);
        elContext.put("value", value);
        String propertyCategory = context.getRenderPropertyCategory();
        RenderPropertyUtils propertyUtils = this.getRenderPropertyUtils();
        try {
            text = StringUtils.defaultIfEmpty((String)propertyUtils.getString("label", propertyCategory, label), (String)"&nbsp;");
        }
        finally {
            elContext.remove("label");
            elContext.remove("value");
        }
        String link = propertyUtils.getString("link", propertyCategory, null);
        if (link == null) {
            this.writeContent(text);
        } else {
            HashMap<String, String> attributes = new HashMap<String, String>(1);
            attributes.put("href", link);
            this.startElement("a", attributes);
            this.writeContent(text);
            this.endElement("a");
        }
    }

    @Override
    public void endCell(TableRenderContext context) {
        String tagName = "value".equals(context.getCellType()) || "aggValue".equals(context.getCellType()) ? "td" : "th";
        this.endElement(tagName);
    }

    @Override
    public void endRow(TableRenderContext context) {
        this.endElement("tr");
    }

    @Override
    public void endBody(TableRenderContext context) {
        this.endElement("tbody");
    }

    @Override
    public void endTable(TableRenderContext context) {
        this.endElement("table");
    }

    @Override
    public Serializable saveState() {
        return new Serializable[]{super.saveState(), this.tableId, this.border, this.cellSpacing, this.cellPadding, this.tableStyleClass, this.columnHeaderStyleClass, this.columnTitleStyleClass, this.rowHeaderStyleClass, this.rowTitleStyleClass, this.cornerStyleClass, this.rowStyleClass, this.evenRowStyleClass, this.oddRowStyleClass, this.cellStyleClass, Integer.valueOf(this.rowHeaderLevelPadding)};
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        int index = 0;
        super.restoreState(states[index++]);
        this.tableId = (String)((Object)states[index++]);
        this.border = (Integer)states[index++];
        this.cellSpacing = (Integer)states[index++];
        this.cellPadding = (Integer)states[index++];
        this.tableStyleClass = (String)((Object)states[index++]);
        this.columnHeaderStyleClass = (String)((Object)states[index++]);
        this.columnTitleStyleClass = (String)((Object)states[index++]);
        this.rowHeaderStyleClass = (String)((Object)states[index++]);
        this.rowTitleStyleClass = (String)((Object)states[index++]);
        this.cornerStyleClass = (String)((Object)states[index++]);
        this.rowStyleClass = (String)((Object)states[index++]);
        this.evenRowStyleClass = (String)((Object)states[index++]);
        this.oddRowStyleClass = (String)((Object)states[index++]);
        this.cellStyleClass = (String)((Object)states[index++]);
        this.rowHeaderLevelPadding = (Integer)states[index++];
    }
}

