/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.ObjectUtils;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.ConditionFactory;
import org.pivot4j.util.OlapUtils;

public class CellValueCondition
extends AbstractCondition {
    public static final String NAME = "cellValue";
    private Double value;
    private Criteria criteria;
    private List<String> positionUniqueNames;

    public CellValueCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public CellValueCondition(ConditionFactory conditionFactory, Double value, Criteria criteria) {
        super(conditionFactory);
        this.value = value;
        this.criteria = criteria;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public List<String> getPositionUniqueNames() {
        return this.positionUniqueNames;
    }

    public void setPositionUniqueNames(List<String> positionUniqueNames) {
        this.positionUniqueNames = positionUniqueNames;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.value == null) {
            throw new IllegalStateException("VALUE is not specified.");
        }
        if (this.criteria == null) {
            throw new IllegalStateException("Criteria is not specified.");
        }
        Double cellValue = this.getCellValue(context);
        return this.value.equals(cellValue);
    }

    protected Double getCellValue(RenderContext context) {
        Position position = this.getPosition(context);
        Cell cell = null;
        if (position == null) {
            cell = context.getCell();
        } else if (position.getMembers() != null && !position.getMembers().isEmpty()) {
            ArrayList<Position> positions = new ArrayList<Position>(context.getAxes().size());
            for (Axis axis : context.getAxes()) {
                Position pos = context.getPosition(axis);
                if (pos == null) {
                    return null;
                }
                if (pos.getMembers() != null && !pos.getMembers().isEmpty() && OlapUtils.equals((MetadataElement)pos.getMembers().get(0), (MetadataElement)position.getMembers().get(0))) {
                    pos = position;
                }
                positions.add(pos);
            }
            cell = context.getCellSet().getCell(positions.toArray(new Position[positions.size()]));
        }
        if (cell == null) {
            return null;
        }
        try {
            return cell.getDoubleValue();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    protected Position getPosition(RenderContext context) {
        Position position = null;
        if (this.positionUniqueNames != null && !this.positionUniqueNames.isEmpty()) {
            String cacheKey = "cellValueCache" + this.hashCode();
            if (context.hasAttribute(cacheKey)) {
                position = (Position)context.getAttribute(cacheKey);
            }
            if (position == null) {
                for (Axis axis : context.getAxes()) {
                    Position pos = context.getPosition(axis);
                    if (pos == null || !this.matches(pos)) continue;
                    position = pos;
                    break;
                }
                if (position != null) {
                    context.setAttribute(cacheKey, position);
                }
            }
        }
        return position;
    }

    protected boolean matches(Position position) {
        if (this.positionUniqueNames == null || position == null) {
            return false;
        }
        boolean matches = false;
        List members = position.getMembers();
        if (this.positionUniqueNames.size() == members.size()) {
            Iterator<String> it = this.positionUniqueNames.iterator();
            for (Member member : position.getMembers()) {
                matches = it.next().equals(member.getUniqueName());
                if (matches) continue;
                break;
            }
        }
        return matches;
    }

    @Override
    public Serializable saveState() {
        Serializable[] states = new Serializable[3];
        states[0] = this.value;
        states[1] = this.criteria;
        if (this.positionUniqueNames != null) {
            states[2] = new LinkedList<String>(this.positionUniqueNames);
        }
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        List names;
        Serializable[] states = (Serializable[])state;
        this.value = (Double)states[0];
        this.criteria = (Criteria)((Object)states[1]);
        this.positionUniqueNames = names = (List)((Object)states[2]);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.criteria != null) {
            configuration.addProperty("criteria", (Object)this.criteria.name());
        }
        if (this.value != null) {
            configuration.addProperty("value", (Object)this.value);
        }
        if (this.positionUniqueNames != null) {
            int index = 0;
            for (String member : this.positionUniqueNames) {
                String name = String.format("position.member(%s)", index++);
                configuration.setProperty(name, (Object)member);
            }
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        String name = configuration.getString("criteria");
        this.criteria = name == null ? null : Criteria.valueOf(name);
        this.value = configuration.getDouble("value", null);
        try {
            List members = configuration.configurationsAt("position.member");
            this.positionUniqueNames = new LinkedList<String>();
            for (HierarchicalConfiguration member : members) {
                this.positionUniqueNames.add(member.getString(""));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("cellValue ");
        if (this.criteria != null) {
            builder.append(this.criteria.getOperator());
        }
        if (this.value != null) {
            builder.append(" ");
            builder.append(this.value);
        }
        return builder.toString();
    }

    public static enum Criteria {
        Equals{

            @Override
            boolean matches(Double value1, Double value2) {
                return ObjectUtils.equals((Object)value1, (Object)value2);
            }

            @Override
            String getOperator() {
                return "=";
            }
        }
        ,
        GreaterThan{

            @Override
            boolean matches(Double value1, Double value2) {
                if (value1 == null || value2 == null) {
                    return false;
                }
                return value1.compareTo(value2) > 0;
            }

            @Override
            String getOperator() {
                return ">";
            }
        }
        ,
        GreaterThanEquals{

            @Override
            boolean matches(Double value1, Double value2) {
                return GreaterThan.matches(value1, value2) || Equals.matches(value1, value2);
            }

            @Override
            String getOperator() {
                return ">=";
            }
        }
        ,
        LesserThan{

            @Override
            boolean matches(Double value1, Double value2) {
                if (value1 == null || value2 == null) {
                    return false;
                }
                return value1.compareTo(value2) < 0;
            }

            @Override
            String getOperator() {
                return "<";
            }
        }
        ,
        LesserThanEquals{

            @Override
            boolean matches(Double value1, Double value2) {
                return LesserThan.matches(value1, value2) || Equals.matches(value1, value2);
            }

            @Override
            String getOperator() {
                return "<=";
            }
        };


        abstract boolean matches(Double var1, Double var2);

        abstract String getOperator();
    }
}

