/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.command;

import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.pivot4j.PivotModel;
import org.pivot4j.transform.DrillExpandPosition;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.command.AbstractDrillDownCommand;
import org.pivot4j.ui.command.UICommandParameters;

public class DrillCollapsePositionCommand
extends AbstractDrillDownCommand {
    public static final String NAME = "collapsePosition";

    public DrillCollapsePositionCommand(PivotRenderer<?> renderer) {
        super(renderer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMode(RenderContext context) {
        return "position";
    }

    @Override
    public boolean canExecute(RenderContext context) {
        if (!super.canExecute(context)) {
            return false;
        }
        PivotModel model = context.getModel();
        DrillExpandPosition transform = model.getTransform(DrillExpandPosition.class);
        Position position = context.getPosition();
        Member member = context.getMember();
        if (position == null || member == null || context.getProperty() != null) {
            return false;
        }
        return transform.canCollapse(position, member);
    }

    @Override
    public UICommandParameters createParameters(RenderContext context) {
        UICommandParameters parameters = new UICommandParameters();
        parameters.setAxisOrdinal(context.getAxis().axisOrdinal());
        parameters.setPositionOrdinal(context.getPosition().getOrdinal());
        parameters.setMemberOrdinal(context.getPosition().getMembers().indexOf(context.getMember()));
        return parameters;
    }

    @Override
    public Void execute(PivotModel model, UICommandParameters parameters) {
        CellSet cellSet = model.getCellSet();
        CellSetAxis axis = (CellSetAxis)cellSet.getAxes().get(parameters.getAxisOrdinal());
        Position position = (Position)axis.getPositions().get(parameters.getPositionOrdinal());
        Member member = (Member)position.getMembers().get(parameters.getMemberOrdinal());
        DrillExpandPosition transform = model.getTransform(DrillExpandPosition.class);
        transform.collapse(position, member);
        return null;
    }
}

