/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.command;

import java.sql.ResultSet;
import org.olap4j.Cell;
import org.olap4j.OlapException;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.command.AbstractUICommand;
import org.pivot4j.ui.command.DrillThroughCommand;
import org.pivot4j.ui.command.UICommandParameters;

public class BasicDrillThroughCommand
extends AbstractUICommand<ResultSet>
implements DrillThroughCommand {
    public static final String NAME = "drillThrough";

    public BasicDrillThroughCommand(PivotRenderer<?> renderer) {
        super(renderer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean canExecute(RenderContext context) {
        PivotModel model = context.getModel();
        boolean scenarioEnabled = model.isScenarioSupported() && model.getScenario() != null;
        return !scenarioEnabled && this.getRenderer().getEnableDrillThrough() && model.getCube().isDrillThroughEnabled() && context.getCell() != null;
    }

    @Override
    public UICommandParameters createParameters(RenderContext context) {
        UICommandParameters parameters = new UICommandParameters();
        parameters.setCellOrdinal(context.getCell().getOrdinal());
        return parameters;
    }

    @Override
    public ResultSet execute(PivotModel model, UICommandParameters parameters) {
        Cell cell = model.getCellSet().getCell(parameters.getCellOrdinal());
        try {
            return cell.drillThrough();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }
}

