/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Property;
import org.pivot4j.PivotModel;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.el.ExpressionEvaluator;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.ui.property.RenderPropertyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenderContext {
    public static final String RESOURCE_BUNDLE_NAME = "org.pivot4j.i18n.messages";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PivotModel model;
    private PivotRenderer<?> renderer;
    private ResourceBundle resourceBundle;
    private ExpressionContext expressionContext;
    private ExpressionEvaluator expressionEvaluator;
    private Axis axis;
    private Hierarchy hierarchy;
    private Level level;
    private Member member;
    private Property property;
    private Position position;
    private Cell cell;
    private String cellType;
    private String renderPropertyCategory;
    private Aggregator aggregator;
    private Map<String, Object> attributes;

    public RenderContext(PivotModel model, PivotRenderer<?> renderer) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        if (renderer == null) {
            throw new NullArgumentException("renderer");
        }
        this.model = model;
        this.renderer = renderer;
        this.resourceBundle = this.createDefaultResourceBundle(model);
        this.expressionContext = this.createExpressionContext(model);
        this.expressionEvaluator = model.getExpressionEvaluatorFactory().createEvaluator();
        this.attributes = new HashMap<String, Object>();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new NullArgumentException("logger");
        }
        this.logger = logger;
    }

    public PivotModel getModel() {
        return this.model;
    }

    public PivotRenderer<?> getRenderer() {
        return this.renderer;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    protected ExpressionContext createExpressionContext(PivotModel model) {
        ExpressionContext context = new ExpressionContext(model.getExpressionContext());
        context.put("axis", new ExpressionContext.ValueBinding<Axis>(){

            @Override
            public Axis getValue() {
                return RenderContext.this.axis;
            }
        });
        context.put("hierarchy", new ExpressionContext.ValueBinding<Hierarchy>(){

            @Override
            public Hierarchy getValue() {
                return RenderContext.this.hierarchy;
            }
        });
        context.put("level", new ExpressionContext.ValueBinding<Level>(){

            @Override
            public Level getValue() {
                return RenderContext.this.level;
            }
        });
        context.put("member", new ExpressionContext.ValueBinding<Member>(){

            @Override
            public Member getValue() {
                return RenderContext.this.member;
            }
        });
        context.put("cell", new ExpressionContext.ValueBinding<Cell>(){

            @Override
            public Cell getValue() {
                return RenderContext.this.cell;
            }
        });
        context.put("cellType", new ExpressionContext.ValueBinding<String>(){

            @Override
            public String getValue() {
                return RenderContext.this.cellType;
            }
        });
        context.put("renderPropertyCategory", new ExpressionContext.ValueBinding<String>(){

            @Override
            public String getValue() {
                return RenderContext.this.renderPropertyCategory;
            }
        });
        context.put("position", new ExpressionContext.ValueBinding<Position>(){

            @Override
            public Position getValue() {
                return RenderContext.this.position;
            }
        });
        context.put("property", new ExpressionContext.ValueBinding<Property>(){

            @Override
            public Property getValue() {
                return RenderContext.this.property;
            }
        });
        context.put("aggregator", new ExpressionContext.ValueBinding<Aggregator>(){

            @Override
            public Aggregator getValue() {
                return RenderContext.this.aggregator;
            }
        });
        context.put("attributes", new ExpressionContext.ValueBinding<Map<String, Object>>(){

            @Override
            public Map<String, Object> getValue() {
                return RenderContext.this.attributes;
            }
        });
        return context;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    protected ResourceBundle createDefaultResourceBundle(PivotModel model) {
        return ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, model.getLocale());
    }

    public CellSet getCellSet() {
        return this.model.getCellSet();
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public abstract List<Axis> getAxes();

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public String getRenderPropertyCategory() {
        return this.renderPropertyCategory;
    }

    public void setRenderPropertyCategory(String renderPropertyCategory) {
        this.renderPropertyCategory = renderPropertyCategory;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public abstract Position getPosition(Axis var1);

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public abstract Position getAggregationTarget(Axis var1);

    public CellSetAxis getCellSetAxis() {
        if (this.axis == null) {
            return null;
        }
        return (CellSetAxis)this.getCellSet().getAxes().get(this.axis.axisOrdinal());
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Map<String, RenderPropertyList> getRenderProperties() {
        return this.renderer.getRenderProperties();
    }
}

