/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.olap4j.OlapConnection;
import org.pivot4j.PivotException;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.transform.ChangeSlicer;
import org.pivot4j.transform.DrillExpandMember;
import org.pivot4j.transform.DrillExpandPosition;
import org.pivot4j.transform.DrillReplace;
import org.pivot4j.transform.DrillThrough;
import org.pivot4j.transform.NonEmpty;
import org.pivot4j.transform.PlaceHierarchiesOnAxes;
import org.pivot4j.transform.PlaceLevelsOnAxes;
import org.pivot4j.transform.PlaceMembersOnAxes;
import org.pivot4j.transform.SwapAxes;
import org.pivot4j.transform.Transform;
import org.pivot4j.transform.TransformFactory;
import org.pivot4j.transform.impl.ChangeSlicerImpl;
import org.pivot4j.transform.impl.DrillExpandMemberImpl;
import org.pivot4j.transform.impl.DrillExpandPositionImpl;
import org.pivot4j.transform.impl.DrillReplaceImpl;
import org.pivot4j.transform.impl.DrillThroughImpl;
import org.pivot4j.transform.impl.NonEmptyImpl;
import org.pivot4j.transform.impl.PlaceHierarchiesOnAxesImpl;
import org.pivot4j.transform.impl.PlaceLevelsOnAxesImpl;
import org.pivot4j.transform.impl.PlaceMembersOnAxesImpl;
import org.pivot4j.transform.impl.SwapAxesImpl;

public class TransformFactoryImpl
implements TransformFactory {
    private Map<Class<? extends Transform>, Class<? extends Transform>> transforms = new HashMap<Class<? extends Transform>, Class<? extends Transform>>();

    public TransformFactoryImpl() {
        this.registerDefaultTransforms(this.transforms);
    }

    protected void registerDefaultTransforms(Map<Class<? extends Transform>, Class<? extends Transform>> transforms) {
        transforms.put(DrillExpandMember.class, DrillExpandMemberImpl.class);
        transforms.put(DrillExpandPosition.class, DrillExpandPositionImpl.class);
        transforms.put(DrillReplace.class, DrillReplaceImpl.class);
        transforms.put(DrillThrough.class, DrillThroughImpl.class);
        transforms.put(NonEmpty.class, NonEmptyImpl.class);
        transforms.put(SwapAxes.class, SwapAxesImpl.class);
        transforms.put(PlaceHierarchiesOnAxes.class, PlaceHierarchiesOnAxesImpl.class);
        transforms.put(PlaceMembersOnAxes.class, PlaceMembersOnAxesImpl.class);
        transforms.put(PlaceLevelsOnAxes.class, PlaceLevelsOnAxesImpl.class);
        transforms.put(ChangeSlicer.class, ChangeSlicerImpl.class);
    }

    @Override
    public <T extends Transform> T createTransform(Class<T> type, QueryAdapter queryAdapter, OlapConnection connection) {
        Transform transform = null;
        Class<? extends Transform> implementationType = this.transforms.get(type);
        if (implementationType != null) {
            try {
                Constructor<? extends Transform> constructor = implementationType.getConstructor(QueryAdapter.class, OlapConnection.class);
                transform = constructor.newInstance(queryAdapter, connection);
            }
            catch (NoSuchMethodException e) {
                String msg = "The registered implementation class does not have a suitable constructor : " + implementationType;
                throw new IllegalArgumentException(msg);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Failed to instantiate the transfom class : " + implementationType;
                throw new PivotException(msg, e);
            }
        }
        return (T)transform;
    }
}

