/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.mdx.Exp;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.DrillThrough;
import org.pivot4j.util.OlapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillThroughImpl
extends AbstractTransform
implements DrillThrough {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DrillThroughImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public ResultSet drillThrough(Cell cell) {
        return this.drillThrough(cell, null, 0);
    }

    @Override
    public ResultSet drillThrough(Cell cell, List<MetadataElement> selection, int maximumRows) {
        if (cell == null) {
            throw new NullArgumentException("cell");
        }
        ResultSet result = selection != null && !selection.isEmpty() || maximumRows > 0 ? this.performDrillThroughMdx(cell, selection, maximumRows) : this.performDrillThrough(cell);
        return result;
    }

    protected ResultSet performDrillThrough(Cell cell) {
        try {
            return cell.drillThrough();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    protected ResultSet performDrillThroughMdx(Cell cell, List<MetadataElement> selection, int maximumRows) {
        ResultSet result;
        PivotModel model = this.getModel();
        Cube cube = model.getCube();
        QueryAdapter query = this.getQueryAdapter();
        StringBuilder builder = new StringBuilder();
        builder.append("DRILLTHROUGH");
        if (maximumRows > 0) {
            builder.append(" MAXROWS ");
            builder.append(maximumRows);
        }
        builder.append(" SELECT (");
        boolean isFirst = true;
        List coords = cell.getCoordinateList();
        CellSet cellSet = cell.getCellSet();
        List axes = cellSet.getAxes();
        OlapUtils utils = new OlapUtils(this.getModel().getCube());
        utils.setMemberHierarchyCache(this.getQueryAdapter().getModel().getMemberHierarchyCache());
        int axisOrdinal = 0;
        Iterator iterator = coords.iterator();
        while (iterator.hasNext()) {
            int ordinal = (Integer)iterator.next();
            Position position = (Position)((CellSetAxis)axes.get(axisOrdinal++)).getPositions().get(ordinal);
            for (Member member : position.getMembers()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(", ");
                }
                builder.append(utils.wrapRaggedIfNecessary(member).getUniqueName());
            }
        }
        builder.append(") ON COLUMNS FROM ");
        builder.append(cube.getUniqueName());
        Exp slicer = query.getParsedQuery().getSlicer();
        if (slicer != null) {
            builder.append(" WHERE ");
            builder.append(slicer.toMdx());
        }
        if (selection != null && !selection.isEmpty()) {
            builder.append(" RETURN ");
            isFirst = true;
            for (MetadataElement elem : selection) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(", ");
                }
                if (elem instanceof Member) {
                    elem = utils.wrapRaggedIfNecessary((Member)elem);
                }
                builder.append(elem.getUniqueName());
            }
        }
        String mdx = builder.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Drill through MDX : {}", (Object)mdx);
        }
        try {
            OlapStatement stmt = this.getConnection().createStatement();
            result = stmt.executeQuery(mdx);
        }
        catch (SQLException e) {
            throw new PivotException(e);
        }
        return result;
    }
}

