/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.util.Collections;
import java.util.List;
import org.olap4j.OlapConnection;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.DrillExpandPosition;

public class DrillExpandPositionImpl
extends AbstractTransform
implements DrillExpandPosition {
    public DrillExpandPositionImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    @Override
    public boolean canExpand(Position position, Member member) {
        List<Member> pathMembers = this.memberPath(position, member);
        return this.getQueryAdapter().canExpand(pathMembers);
    }

    @Override
    public boolean canCollapse(Position position, Member member) {
        List<Member> pathMembers = this.memberPath(position, member);
        return this.getQueryAdapter().canCollapse(pathMembers);
    }

    @Override
    public void expand(Position position, Member member) {
        List<Member> pathMembers = this.memberPath(position, member);
        this.getQueryAdapter().expand(pathMembers);
    }

    @Override
    public void collapse(Position position, Member member) {
        List<Member> pathMembers = this.memberPath(position, member);
        this.getQueryAdapter().collapse(pathMembers);
    }

    private List<Member> memberPath(Position position, Member member) {
        List posMembers = position.getMembers();
        int index = posMembers.indexOf(member);
        if (index < 0) {
            return Collections.emptyList();
        }
        return posMembers.subList(0, index + 1);
    }
}

