/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.sort;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.commons.lang.NullArgumentException;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.sort.SortCriteria;

public abstract class SortMode
implements Serializable {
    private static final long serialVersionUID = 3571398856078189701L;
    public static final SortMode BASIC = new SortMode(){
        private static final long serialVersionUID = 3622337346091896703L;

        @Override
        public String getName() {
            return "basic";
        }

        @Override
        public SortCriteria nextMode(SortCriteria mode) {
            if (mode == null) {
                return SortCriteria.ASC;
            }
            if (mode == SortCriteria.ASC) {
                return SortCriteria.DESC;
            }
            return null;
        }
    };
    public static final SortMode BREAKING = new SortMode(){
        private static final long serialVersionUID = 7472926285648718374L;

        @Override
        public String getName() {
            return "breaking";
        }

        @Override
        public SortCriteria nextMode(SortCriteria mode) {
            if (mode == null) {
                return SortCriteria.BASC;
            }
            if (mode == SortCriteria.BASC) {
                return SortCriteria.BDESC;
            }
            return null;
        }
    };
    public static final SortMode COUNT = new SortMode(){
        private static final long serialVersionUID = -3751113668954135001L;

        @Override
        public String getName() {
            return "count";
        }

        @Override
        public SortCriteria nextMode(SortCriteria mode) {
            if (mode == null) {
                return SortCriteria.TOPCOUNT;
            }
            if (mode == SortCriteria.TOPCOUNT) {
                return SortCriteria.BOTTOMCOUNT;
            }
            return null;
        }
    };

    public static SortMode fromName(String name) {
        Field[] fields;
        for (Field field : fields = SortMode.class.getFields()) {
            SortMode mode;
            Object value;
            try {
                value = field.get(null);
            }
            catch (Exception e) {
                throw new PivotException(e);
            }
            if (!(value instanceof SortMode) || !name.equals((mode = (SortMode)value).getName())) continue;
            return mode;
        }
        return null;
    }

    public abstract String getName();

    public abstract SortCriteria nextMode(SortCriteria var1);

    public void toggleSort(PivotModel model) {
        SortCriteria criteria;
        if (model == null) {
            throw new NullArgumentException("model");
        }
        SortCriteria currentCriteria = null;
        if (model.isSorting()) {
            currentCriteria = model.getSortCriteria();
        }
        if ((criteria = this.nextMode(currentCriteria)) == null) {
            model.setSorting(false);
        } else {
            model.setSorting(true);
            model.setSortCriteria(criteria);
        }
    }
}

