/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx.metadata;

import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.pivot4j.mdx.ExpVisitor;
import org.pivot4j.mdx.metadata.AbstractMetadataExp;
import org.pivot4j.mdx.metadata.MetadataExpVisitor;

public class LevelExp
extends AbstractMetadataExp<Level> {
    private static final long serialVersionUID = -2485622016528439815L;
    private String hierarchyName;

    public LevelExp() {
    }

    public LevelExp(Level level) {
        super(level);
    }

    public LevelExp(String name, String uniqueName, String hierarchyName) {
        super(name, uniqueName);
        this.hierarchyName = hierarchyName;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    @Override
    public void setMetadata(Level element) {
        super.setMetadata(element);
        this.hierarchyName = element == null ? null : element.getHierarchy().getName();
    }

    @Override
    protected Level lookupMetadata(Cube cube) {
        Hierarchy hierarchy = (Hierarchy)cube.getHierarchies().get(this.hierarchyName);
        return (Level)hierarchy.getLevels().get(this.getName());
    }

    @Override
    public void accept(ExpVisitor visitor) {
        if (visitor instanceof MetadataExpVisitor) {
            ((MetadataExpVisitor)visitor).visitLevel(this);
        }
    }

    @Override
    public LevelExp copy() {
        return new LevelExp(this.getName(), this.getUniqueName(), this.getHierarchyName());
    }
}

