/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.ExpVisitor;

public class CompoundId
extends AbstractExp {
    private static final long serialVersionUID = 697157412160301933L;
    private List<NamePart> names = new ArrayList<NamePart>();

    public CompoundId() {
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public List<NamePart> getNames() {
        return this.names;
    }

    public CompoundId append(String name) {
        this.names.add(new NamePart(name, false));
        return this;
    }

    public CompoundId append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
        return this;
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart part : this.names) {
            ret[i++] = part.name;
        }
        return ret;
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        boolean isFollow = false;
        for (NamePart part : this.names) {
            if (isFollow) {
                sb.append('.');
            } else {
                isFollow = true;
            }
            if (part.key) {
                sb.append('&');
            }
            sb.append(part.name);
        }
        return sb.toString();
    }

    @Override
    public CompoundId copy() {
        CompoundId cloned = new CompoundId();
        for (NamePart part : this.names) {
            cloned.append(part.name, part.key);
        }
        return cloned;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitCompoundId(this);
    }

    public static class NamePart
    implements Serializable {
        private static final long serialVersionUID = 8583427269370241977L;
        private String name;
        private boolean key;

        protected NamePart(String name, boolean key) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getQuotedName() {
            if (this.name == null || this.isQuoted()) {
                return this.name;
            }
            this.name = "[" + this.name + "]";
            return this.name;
        }

        public String getUnquotedName() {
            if (this.name == null || !this.isQuoted()) {
                return this.name;
            }
            return this.name.substring(1, this.name.length() - 1);
        }

        public boolean isKey() {
            return this.key;
        }

        public void setKey(boolean key) {
            this.key = key;
        }

        public boolean isQuoted() {
            return this.name != null && this.name.startsWith("[") && this.name.endsWith("]");
        }
    }
}

