/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.impl;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.logging.LogFactory;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDataSource;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.Scenario;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Schema;
import org.pivot4j.ModelChangeEvent;
import org.pivot4j.ModelChangeListener;
import org.pivot4j.NotInitializedException;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.QueryEvent;
import org.pivot4j.QueryListener;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.el.ExpressionEvaluatorFactory;
import org.pivot4j.el.freemarker.FreeMarkerExpressionEvaluatorFactory;
import org.pivot4j.impl.Quax;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.impl.QueryChangeEvent;
import org.pivot4j.impl.QueryChangeListener;
import org.pivot4j.sort.SortCriteria;
import org.pivot4j.transform.Transform;
import org.pivot4j.transform.TransformFactory;
import org.pivot4j.transform.impl.TransformFactoryImpl;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.OlapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PivotModelImpl
implements PivotModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private OlapDataSource dataSource;
    private OlapConnection connection;
    private String roleName;
    private Locale locale;
    private boolean initialized = false;
    private Boolean scenarioSupported;
    private Collection<ModelChangeListener> modelListeners = new LinkedList<ModelChangeListener>();
    private Collection<QueryListener> queryListeners = new LinkedList<QueryListener>();
    private QueryAdapter queryAdapter;
    private TransformFactory transformFactory = new TransformFactoryImpl();
    private ExpressionEvaluatorFactory expressionEvaluatorFactory = new FreeMarkerExpressionEvaluatorFactory();
    private int topBottomCount = 10;
    private SortCriteria sortCriteria = SortCriteria.ASC;
    private boolean sorting = false;
    private boolean defaultNonEmpty = false;
    private List<Member> sortPosMembers;
    private String mdxQuery;
    private CellSet cellSet;
    private ExpressionContext expressionContext;
    private MemberHierarchyCache memberHierarchyCache;
    private QueryChangeListener queryChangeListener = new QueryChangeListener(){

        @Override
        public void queryChanged(QueryChangeEvent e) {
            PivotModelImpl.this.fireStructureChanged();
        }
    };

    public PivotModelImpl(OlapDataSource dataSource) {
        if (dataSource == null) {
            throw new NullArgumentException("dataSource");
        }
        this.dataSource = dataSource;
        this.expressionContext = this.createExpressionContext();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.connection != null) {
            this.connection.setLocale(locale);
        }
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void setRoleName(String roleName) {
        this.roleName = roleName;
        if (this.connection != null) {
            try {
                this.connection.setRoleName(roleName);
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
    }

    @Override
    public synchronized void initialize() {
        if (this.isInitialized()) {
            this.destroy();
        }
        if (this.mdxQuery == null) {
            throw new PivotException("Initial MDX query is null.");
        }
        try {
            this.connection = this.createConnection(this.dataSource);
        }
        catch (SQLException e) {
            throw new PivotException(e);
        }
        this.initialized = true;
        Logger log = LoggerFactory.getLogger(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("Initializing model with MDX : {}", (Object)this.mdxQuery);
        }
        this.queryAdapter = this.createQueryAdapter();
        this.queryAdapter.initialize();
        this.queryAdapter.updateQuery();
        this.queryAdapter.addChangeListener(this.queryChangeListener);
        this.initializeCache();
        this.fireModelInitialized();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void checkInitialization() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Model has not been initialized yet.");
        }
    }

    private void initializeCache() {
        if (!this.isInitialized()) {
            return;
        }
        Cube cube = this.getCube();
        if (cube == null) {
            this.memberHierarchyCache = null;
        } else if (this.memberHierarchyCache == null || !OlapUtils.equals((MetadataElement)this.memberHierarchyCache.getCube(), (MetadataElement)cube)) {
            this.memberHierarchyCache = new MemberHierarchyCache(cube);
        }
    }

    protected OlapConnection createConnection(OlapDataSource dataSource) throws SQLException {
        OlapConnection con = dataSource.getConnection();
        if (this.roleName != null) {
            con.setRoleName(this.roleName);
        }
        if (this.locale != null) {
            con.setLocale(this.locale);
        }
        return con;
    }

    @Override
    public synchronized void destroy() {
        this.checkInitialization();
        if (this.queryAdapter != null) {
            this.queryAdapter.removeChangeListener(this.queryChangeListener);
            this.queryAdapter = null;
        }
        if (this.connection != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing OLAP connection {}", (Object)this.connection);
            }
            try {
                this.closeConnection(this.connection);
            }
            catch (SQLException e) {
                throw new PivotException(e);
            }
            this.connection = null;
        }
        this.sortPosMembers = null;
        this.sortCriteria = SortCriteria.ASC;
        this.sorting = false;
        this.cellSet = null;
        this.initialized = false;
        this.memberHierarchyCache = null;
        this.fireModelDestroyed();
    }

    protected void closeConnection(OlapConnection connection) throws SQLException {
        connection.close();
    }

    protected ExpressionContext createExpressionContext() {
        ExpressionContext context = new ExpressionContext();
        context.put("locale", new ExpressionContext.ValueBinding<Locale>(){

            @Override
            public Locale getValue() {
                return PivotModelImpl.this.getLocale();
            }
        });
        context.put("roleName", new ExpressionContext.ValueBinding<String>(){

            @Override
            public String getValue() {
                return PivotModelImpl.this.getRoleName();
            }
        });
        context.put("cube", new ExpressionContext.ValueBinding<Cube>(){

            @Override
            public Cube getValue() {
                if (!PivotModelImpl.this.isInitialized()) {
                    return null;
                }
                return PivotModelImpl.this.getCube();
            }
        });
        context.put("catalog", new ExpressionContext.ValueBinding<Catalog>(){

            @Override
            public Catalog getValue() {
                if (!PivotModelImpl.this.isInitialized()) {
                    return null;
                }
                return PivotModelImpl.this.getCatalog();
            }
        });
        context.put("cellSet", new ExpressionContext.ValueBinding<CellSet>(){

            @Override
            public CellSet getValue() {
                return PivotModelImpl.this.cellSet;
            }
        });
        context.put("memberUtils", new ExpressionContext.ValueBinding<OlapUtils>(){

            @Override
            public OlapUtils getValue() {
                Cube cube = PivotModelImpl.this.getCube();
                if (cube == null) {
                    return null;
                }
                OlapUtils utils = new OlapUtils(cube);
                utils.setMemberHierarchyCache(PivotModelImpl.this.memberHierarchyCache);
                return utils;
            }
        });
        return context;
    }

    protected OlapConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isScenarioSupported() {
        if (this.scenarioSupported == null) {
            Cube cube = this.getCube();
            Schema schema = cube.getSchema();
            Catalog catalog = schema.getCatalog();
            OlapDatabaseMetaData metadata = cube.getSchema().getCatalog().getMetaData();
            ResultSet rs = null;
            try {
                if (metadata.getDriverName().startsWith("Mondrian")) {
                    Dimension dimension = (Dimension)cube.getDimensions().get("Scenario");
                    this.scenarioSupported = dimension != null && dimension.isVisible();
                } else {
                    rs = metadata.getCubes(catalog.getName(), schema.getName(), cube.getName());
                    if (rs.next()) {
                        this.scenarioSupported = rs.getBoolean("IS_WRITE_ENABLED");
                    }
                }
            }
            catch (SQLException e) {
                throw new PivotException(e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return Boolean.TRUE.equals(this.scenarioSupported);
    }

    @Override
    public Scenario createScenario() {
        this.checkInitialization();
        try {
            return this.connection.createScenario();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public Scenario getScenario() {
        this.checkInitialization();
        try {
            return this.connection.getScenario();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.checkInitialization();
        try {
            this.connection.setScenario(scenario);
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        this.refresh();
        this.fireModelChanged();
    }

    public OlapDataSource getDataSource() {
        return this.dataSource;
    }

    public Catalog getCatalog() {
        this.checkInitialization();
        try {
            return this.connection.getOlapCatalog();
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public OlapDatabaseMetaData getMetadata() {
        boolean initialized = this.connection != null;
        try {
            if (!initialized) {
                this.connection = this.createConnection(this.dataSource);
            }
            OlapDatabaseMetaData olapDatabaseMetaData = this.connection.getMetaData();
            return olapDatabaseMetaData;
        }
        catch (SQLException e) {
            throw new PivotException(e);
        }
        finally {
            if (!initialized) {
                try {
                    this.closeConnection(this.connection);
                }
                catch (SQLException e) {
                    throw new PivotException(e);
                }
            }
        }
    }

    @Override
    public Cube getCube() {
        this.checkInitialization();
        Cube cube = null;
        try {
            if (this.cellSet != null) {
                cube = this.cellSet.getMetaData().getCube();
            } else {
                String cubeName = this.queryAdapter.getCubeName();
                Schema schema = this.connection.getOlapSchema();
                cube = (Cube)schema.getCubes().get(cubeName);
                if (cube == null && cubeName != null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Cube with the specified name cannot be found : " + cubeName);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("List of cubes in schema : " + schema.getName());
                        for (Cube c : schema.getCubes()) {
                            this.logger.debug(c.getCaption() + " - " + c.getUniqueName());
                        }
                    }
                }
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        return cube;
    }

    @Override
    public synchronized CellSet getCellSet() {
        this.checkInitialization();
        if (this.cellSet != null) {
            return this.cellSet;
        }
        if (this.queryAdapter == null) {
            throw new IllegalStateException("Initial MDX is not specified.");
        }
        if (this.expressionEvaluatorFactory != null) {
            this.queryAdapter.evaluate(this.expressionEvaluatorFactory.createEvaluator());
        }
        String mdx = this.normalizeMdx(this.getCurrentMdx(true));
        if (!this.queryAdapter.isValid()) {
            return null;
        }
        try {
            this.cellSet = this.executeMdx(this.connection, mdx);
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        this.expressionContext.put("cellSet", this.cellSet);
        this.queryAdapter.afterExecute(this.cellSet);
        return this.cellSet;
    }

    @Override
    public void refresh() {
        this.cellSet = null;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public MemberHierarchyCache getMemberHierarchyCache() {
        return this.memberHierarchyCache;
    }

    protected CellSet executeMdx(OlapConnection connection, String mdx) throws OlapException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(mdx);
        }
        Date start = new Date(System.currentTimeMillis());
        OlapStatement stmt = connection.createStatement();
        CellSet result = stmt.executeOlapQuery(mdx);
        long duration = System.currentTimeMillis() - start.getTime();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Query execution time : %d ms", duration));
        }
        this.fireQueryExecuted(start, duration, mdx);
        return result;
    }

    protected String normalizeMdx(String mdx) {
        if (mdx == null) {
            return null;
        }
        return mdx.replaceAll("\r", "");
    }

    @Override
    public String getCurrentMdx() {
        return this.getCurrentMdx(false);
    }

    @Override
    public String getEvaluatedMdx() {
        return this.getCurrentMdx(true);
    }

    protected String getCurrentMdx(boolean evaluated) {
        if (this.queryAdapter == null) {
            return null;
        }
        return this.queryAdapter.getCurrentMdx(evaluated);
    }

    @Override
    public String getMdx() {
        return this.mdxQuery;
    }

    @Override
    public void setMdx(String mdxQuery) {
        if (mdxQuery == null) {
            throw new NullArgumentException("mdxQuery");
        }
        this.mdxQuery = mdxQuery;
        String mdx = this.normalizeMdx(mdxQuery);
        if (!mdx.equals(this.normalizeMdx(this.getCurrentMdx()))) {
            this.onMdxChanged(mdx);
        }
    }

    protected void onMdxChanged(String mdx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("MDX has been changed : {}", (Object)mdx);
        }
        this.cellSet = null;
        this.scenarioSupported = null;
        this.topBottomCount = 10;
        this.sortCriteria = SortCriteria.ASC;
        this.sorting = false;
        this.sortPosMembers = null;
        if (this.queryAdapter != null) {
            this.queryAdapter.initialize();
            this.queryAdapter.updateQuery();
        }
        this.initializeCache();
        this.fireStructureChanged();
    }

    protected QueryAdapter createQueryAdapter() {
        return new QueryAdapter(this);
    }

    protected QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    public TransformFactory getTransformFactory() {
        return this.transformFactory;
    }

    public void setTransformFactory(TransformFactory factory) {
        this.transformFactory = factory;
    }

    @Override
    public ExpressionEvaluatorFactory getExpressionEvaluatorFactory() {
        return this.expressionEvaluatorFactory;
    }

    public void setExpressionEvaluatorFactory(ExpressionEvaluatorFactory factory) {
        this.expressionEvaluatorFactory = factory;
    }

    @Override
    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelListeners.add(listener);
    }

    @Override
    public void removeModelChangeListener(ModelChangeListener listener) {
        this.modelListeners.remove(listener);
    }

    protected void fireModelInitialized() {
        ModelChangeEvent e = new ModelChangeEvent(this);
        ArrayList<ModelChangeListener> copiedListeners = new ArrayList<ModelChangeListener>(this.modelListeners);
        for (ModelChangeListener listener : copiedListeners) {
            listener.modelInitialized(e);
        }
    }

    protected void fireModelChanged() {
        this.cellSet = null;
        ModelChangeEvent e = new ModelChangeEvent(this);
        ArrayList<ModelChangeListener> copiedListeners = new ArrayList<ModelChangeListener>(this.modelListeners);
        for (ModelChangeListener listener : copiedListeners) {
            listener.modelChanged(e);
        }
    }

    protected void fireStructureChanged() {
        this.cellSet = null;
        ModelChangeEvent e = new ModelChangeEvent(this);
        ArrayList<ModelChangeListener> copiedListeners = new ArrayList<ModelChangeListener>(this.modelListeners);
        for (ModelChangeListener listener : copiedListeners) {
            listener.structureChanged(e);
        }
    }

    protected void fireModelDestroyed() {
        ModelChangeEvent e = new ModelChangeEvent(this);
        ArrayList<ModelChangeListener> copiedListeners = new ArrayList<ModelChangeListener>(this.modelListeners);
        for (ModelChangeListener listener : copiedListeners) {
            listener.modelDestroyed(e);
        }
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.queryListeners.add(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.queryListeners.remove(listener);
    }

    protected void fireQueryExecuted(Date start, long duration, String mdx) {
        QueryEvent e = new QueryEvent(this, start, duration, mdx, this.cellSet);
        ArrayList<QueryListener> copiedListeners = new ArrayList<QueryListener>(this.queryListeners);
        for (QueryListener listener : copiedListeners) {
            listener.queryExecuted(e);
        }
    }

    @Override
    public <T extends Transform> T getTransform(Class<T> type) {
        if (this.transformFactory == null) {
            throw new IllegalStateException("No transform factory instance is available.");
        }
        return this.transformFactory.createTransform(type, this.queryAdapter, this.connection);
    }

    @Override
    public boolean isSorting() {
        return this.sorting;
    }

    @Override
    public boolean isSorting(Position position) {
        if (!this.isSortOnQuery()) {
            return false;
        }
        if (this.sortPosMembers.size() != position.getMembers().size()) {
            return false;
        }
        for (int i = 0; i < this.sortPosMembers.size(); ++i) {
            Member member1 = this.sortPosMembers.get(i);
            Member member2 = (Member)position.getMembers().get(i);
            if (member1 == null) {
                return false;
            }
            if (OlapUtils.equals((MetadataElement)member1, (MetadataElement)member2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSorting(boolean sorting) {
        if (sorting == this.sorting) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Change sorting to {}", (Object)sorting);
        }
        this.sorting = sorting;
        this.fireModelChanged();
    }

    @Override
    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public void setSortCriteria(SortCriteria sortCriteria) {
        if (this.sortCriteria == sortCriteria) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Change sort mode from {} to {}", (Object)this.sortCriteria, (Object)sortCriteria);
        }
        this.sortCriteria = sortCriteria;
        if (this.isSortOnQuery()) {
            this.fireModelChanged();
        }
    }

    @Override
    public boolean isSortable(Position position) {
        try {
            List members = position.getMembers();
            for (Member member : members) {
                if (member.getLevel().getHierarchy().getDimension().getDimensionType() != Dimension.Type.MEASURE) continue;
                return true;
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        return false;
    }

    protected boolean isSortOnQuery() {
        return this.sorting && this.sortPosMembers != null && !this.sortPosMembers.isEmpty();
    }

    @Override
    public List<Member> getSortPosMembers() {
        return Collections.unmodifiableList(this.sortPosMembers);
    }

    @Override
    public int getTopBottomCount() {
        return this.topBottomCount;
    }

    @Override
    public void setTopBottomCount(int topBottomCount) {
        if (this.topBottomCount == topBottomCount) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Change topBottomCount from {} to {}", (Object)this.topBottomCount, (Object)topBottomCount);
        }
        this.topBottomCount = topBottomCount;
        if (this.sorting && this.sortPosMembers != null && (this.sortCriteria == SortCriteria.TOPCOUNT || this.sortCriteria == SortCriteria.BOTTOMCOUNT)) {
            this.fireModelChanged();
        }
    }

    @Override
    public void sort(CellSetAxis axisToSort, Position position) {
        List positions = axisToSort.getPositions();
        if (positions.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reject sort, the axis to be sorted is empty.");
            }
            this.sorting = false;
            return;
        }
        this.sortPosMembers = position.getMembers();
        Dimension dim = ((Member)((Position)positions.get(0)).getMembers().get(0)).getDimension();
        Quax quaxToSort = this.getQueryAdapter().findQuax(dim);
        if (quaxToSort == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reject sort, the Quax is null");
            }
            this.sorting = false;
            return;
        }
        this.getQueryAdapter().setQuaxToSort(quaxToSort);
        if (this.logger.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Change Sort Position ");
            boolean first = true;
            List members = position.getMembers();
            for (Member member : members) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" ");
                }
                builder.append(member.getUniqueName());
            }
            builder.append(" iAxisToSort=");
            builder.append(Integer.toString(quaxToSort.getOrdinal()));
            this.logger.info(builder.toString());
        }
        this.fireModelChanged();
    }

    @Override
    public boolean getDefaultNonEmpty() {
        return this.defaultNonEmpty;
    }

    @Override
    public void setDefaultNonEmpty(boolean defaultNonEmpty) {
        this.defaultNonEmpty = defaultNonEmpty;
    }

    @Override
    public synchronized Serializable saveState() {
        Serializable[] state = new Serializable[4];
        state[0] = this.isInitialized() ? this.getCurrentMdx(false) : this.mdxQuery;
        if (this.sortPosMembers == null) {
            state[1] = null;
        } else {
            Serializable[] sortState = new Serializable[4];
            String[] uniqueNames = new String[this.sortPosMembers.size()];
            for (int i = 0; i < uniqueNames.length; ++i) {
                uniqueNames[i] = this.sortPosMembers.get(i).getUniqueName();
            }
            sortState[0] = uniqueNames;
            sortState[1] = Integer.valueOf(this.getTopBottomCount());
            sortState[2] = this.getSortCriteria();
            sortState[3] = Boolean.valueOf(this.isSorting());
            state[1] = sortState;
        }
        state[2] = this.getQueryAdapter().saveState();
        state[3] = Boolean.valueOf(this.defaultNonEmpty);
        return state;
    }

    @Override
    public synchronized void restoreState(Serializable state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        Serializable[] states = (Serializable[])state;
        this.setMdx((String)((Object)states[0]));
        if (!this.isInitialized()) {
            this.initialize();
        }
        if (states[1] == null) {
            this.sortPosMembers = null;
        } else {
            try {
                Cube cube = this.getCube();
                Serializable[] sortStates = (Serializable[])states[1];
                String[] sortPosUniqueNames = (String[])sortStates[0];
                if (sortPosUniqueNames == null) {
                    this.sortPosMembers = null;
                } else {
                    this.sortPosMembers = new ArrayList<Member>(sortPosUniqueNames.length);
                    for (int i = 0; i < sortPosUniqueNames.length; ++i) {
                        Member member = cube.lookupMember(IdentifierNode.parseIdentifier((String)sortPosUniqueNames[i]).getSegmentList());
                        if (member == null) {
                            if (!this.logger.isWarnEnabled()) break;
                            this.logger.warn("Sort position member not found {}", (Object)sortPosUniqueNames[i]);
                            break;
                        }
                        this.sortPosMembers.add(member);
                    }
                    this.topBottomCount = (Integer)sortStates[1];
                    this.sortCriteria = (SortCriteria)((Object)sortStates[2]);
                    this.sorting = (Boolean)sortStates[3];
                }
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
        this.cellSet = null;
        this.queryAdapter.restoreState(states[2]);
        this.defaultNonEmpty = (Boolean)states[3];
    }

    @Override
    public synchronized void saveSettings(HierarchicalConfiguration configuration) {
        if (configuration == null) {
            throw new NullArgumentException("configuration");
        }
        if (configuration.getLogger() == null) {
            configuration.setLogger(LogFactory.getLog(this.getClass()));
        }
        if (this.isInitialized()) {
            configuration.addProperty("mdx", (Object)this.getCurrentMdx());
        } else {
            configuration.addProperty("mdx", (Object)this.mdxQuery);
        }
        if (this.sorting) {
            configuration.addProperty("sort[@enabled]", (Object)this.sorting);
            if (this.queryAdapter.getQuaxToSort() != null) {
                configuration.addProperty("sort[@ordinal]", (Object)this.queryAdapter.getQuaxToSort().getOrdinal());
            }
            if (this.sortCriteria != null) {
                configuration.addProperty("sort[@criteria]", (Object)this.sortCriteria.name());
                configuration.addProperty("sort[@topBottomCount]", (Object)this.topBottomCount);
                if (this.isSorting() && this.sortPosMembers != null) {
                    int index = 0;
                    for (Member member : this.sortPosMembers) {
                        configuration.addProperty(String.format("sort.member(%s)", index++), (Object)member.getUniqueName());
                    }
                }
            }
        }
        if (this.queryAdapter.isAxesSwapped()) {
            configuration.addProperty("axesSwapped", (Object)true);
        }
    }

    @Override
    public synchronized void restoreSettings(HierarchicalConfiguration configuration) {
        if (configuration == null) {
            throw new NullArgumentException("configuration");
        }
        this.defaultNonEmpty = configuration.getBoolean("nonEmpty[@default]", false);
        String mdx = configuration.getString("mdx");
        this.setMdx(mdx);
        if (mdx == null) {
            return;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.sorting = configuration.getBoolean("sort[@enabled]", false);
        this.sortPosMembers = null;
        this.sortCriteria = SortCriteria.ASC;
        this.topBottomCount = 10;
        Quax quaxToSort = null;
        if (this.sorting) {
            int ordinal;
            List sortPosUniqueNames = configuration.getList("sort.member");
            if (sortPosUniqueNames != null && !sortPosUniqueNames.isEmpty()) {
                try {
                    Cube cube = this.getCube();
                    this.sortPosMembers = new ArrayList<Member>(sortPosUniqueNames.size());
                    for (Object uniqueName : sortPosUniqueNames) {
                        Member member = cube.lookupMember(IdentifierNode.parseIdentifier((String)uniqueName.toString()).getSegmentList());
                        if (member == null) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Sort position member not found " + uniqueName);
                            }
                            break;
                        }
                        this.sortPosMembers.add(member);
                    }
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
            }
            this.topBottomCount = configuration.getInt("sort[@topBottomCount]", 10);
            String sortName = configuration.getString("sort[@criteria]");
            if (sortName != null) {
                this.sortCriteria = SortCriteria.valueOf(sortName);
            }
            if ((ordinal = configuration.getInt("sort[@ordinal]", -1)) > 0) {
                for (Axis axis : this.queryAdapter.getAxes()) {
                    Quax quax = this.queryAdapter.getQuax(axis);
                    if (quax.getOrdinal() != ordinal) continue;
                    quaxToSort = quax;
                    break;
                }
            }
        }
        this.queryAdapter.setQuaxToSort(quaxToSort);
        boolean axesSwapped = configuration.getBoolean("axesSwapped", false);
        this.queryAdapter.setAxesSwapped(axesSwapped);
        this.cellSet = null;
    }
}

