/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.el.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.pivot4j.el.AbstractExpressionEvaluator;
import org.pivot4j.el.ExpressionContext;

public class FreeMarkerExpressionEvaluator
extends AbstractExpressionEvaluator {
    private Configuration configuration;
    private Map<String, Template> cache = new HashMap<String, Template>();

    public FreeMarkerExpressionEvaluator(Configuration configuration) {
        if (configuration == null) {
            throw new NullArgumentException("configuration");
        }
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void clearTemplateCache() {
        this.cache.clear();
    }

    protected Template getTemplateFromCache(String expression) {
        return this.cache.get(expression);
    }

    protected void removeTemplateFromCache(String expression) {
        this.cache.remove(expression);
    }

    protected void putTemplateInCache(String expression, Template template) {
        this.cache.put(expression, template);
    }

    protected Template createTemplate(String expression) throws IOException {
        Template template = new Template(expression, (Reader)new StringReader(expression), this.configuration);
        this.putTemplateInCache(expression, template);
        return template;
    }

    @Override
    protected Object doEvaluate(String expression, ExpressionContext context) throws Exception {
        Locale locale;
        Template template = this.getTemplateFromCache(expression);
        if (template == null) {
            template = this.createTemplate(expression);
        }
        if ((locale = (Locale)context.get("locale")) != null) {
            template.setLocale(locale);
        }
        StringWriter writer = new StringWriter();
        template.process((Object)context, (Writer)writer);
        writer.flush();
        return writer.toString();
    }
}

