/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.datasource;

import java.sql.SQLException;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDataSource;
import org.pivot4j.PivotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapConnectionFactory
extends BasePoolableObjectFactory<OlapConnection> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private OlapDataSource dataSource;
    private String userName;
    private String password;
    private int timeout = 30;

    public OlapConnectionFactory(OlapDataSource dataSource) {
        if (dataSource == null) {
            throw new NullArgumentException("dataSource");
        }
        this.dataSource = dataSource;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OlapConnection makeObject() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating a new OLAP connection.");
        }
        try {
            return this.dataSource.getConnection(this.userName, this.password);
        }
        catch (SQLException e) {
            throw new PivotException(e);
        }
    }

    public void destroyObject(OlapConnection con) {
        try {
            super.destroyObject((Object)con);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing a returned OLAP connection.");
            }
            con.close();
        }
        catch (Exception e) {
            throw new PivotException(e);
        }
    }

    public boolean validateObject(OlapConnection con) {
        try {
            return super.validateObject((Object)con) && con.isValid(this.timeout);
        }
        catch (SQLException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to validate an OLAP connection.", (Throwable)e);
            }
            return false;
        }
    }
}

