/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.context;

import java.util.Stack;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionContextHolder {
    protected static ThreadLocal<Stack<ExecutionContext>> executionContextStackThreadLocal = new ThreadLocal();

    public static ExecutionContext getExecutionContext() {
        return (ExecutionContext)ExecutionContextHolder.getStack(executionContextStackThreadLocal).peek();
    }

    public static boolean isExecutionContextActive() {
        Stack<ExecutionContext> stack = executionContextStackThreadLocal.get();
        return stack != null && !stack.isEmpty();
    }

    public static void setExecutionContext(ExecutionEntity execution) {
        ExecutionContextHolder.getStack(executionContextStackThreadLocal).push(new ExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        ExecutionContextHolder.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

