/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.sql.SqlQuery;
import mondrian.util.Pair;

class DrillThroughQuerySpec
extends AbstractQuerySpec {
    private final DrillThroughCellRequest request;
    private final List<StarPredicate> listOfStarPredicates;
    private final List<String> columnNames;
    private final int maxColumnNameLength;
    private final List<OlapElement> fields;

    public DrillThroughQuerySpec(DrillThroughCellRequest request, StarPredicate starPredicateSlicer, List<OlapElement> fields, boolean countOnly) {
        super(request.getMeasure().getStar(), countOnly);
        this.request = request;
        this.listOfStarPredicates = starPredicateSlicer != null ? Collections.singletonList(starPredicateSlicer) : Collections.emptyList();
        int tmpMaxColumnNameLength = this.getStar().getSqlQueryDialect().getMaxColumnNameLength();
        this.maxColumnNameLength = tmpMaxColumnNameLength == 0 ? Integer.MAX_VALUE : tmpMaxColumnNameLength;
        this.columnNames = this.computeDistinctColumnNames();
        this.fields = fields;
    }

    private List<String> computeDistinctColumnNames() {
        RolapStar.Column[] columns;
        ArrayList<String> columnNames = new ArrayList<String>();
        HashSet<String> columnNameSet = new HashSet<String>();
        for (RolapStar.Column column : columns = this.getColumns()) {
            this.addColumnName(column, columnNames, columnNameSet);
        }
        this.addColumnName(this.request.getMeasure(), columnNames, columnNameSet);
        return columnNames;
    }

    private void addColumnName(RolapStar.Column column, List<String> columnNames, Set<String> columnNameSet) {
        String columnName = this.makeAlias(column, columnNames, columnNameSet);
        columnNames.add(columnName);
    }

    private String makeAlias(RolapStar.Column column, List<String> columnNames, Set<String> columnNameSet) {
        String columnName = column.getName();
        if (columnName == null) {
            columnName = column.getExpression() instanceof MondrianDef.Column ? ((MondrianDef.Column)column.getExpression()).name : "c" + Integer.toString(columnNames.size());
        }
        String originalColumnName = columnName;
        if (columnName.length() > this.maxColumnNameLength) {
            columnName = columnName.substring(0, this.maxColumnNameLength);
        }
        int j = 0;
        while (!columnNameSet.add(columnName)) {
            String suffix = "_" + Integer.toString(j);
            columnName = originalColumnName;
            if (originalColumnName.length() + suffix.length() > this.maxColumnNameLength) {
                columnName = originalColumnName.substring(0, this.maxColumnNameLength - suffix.length());
            }
            columnName = columnName + suffix;
            ++j;
        }
        return columnName;
    }

    @Override
    protected boolean isPartOfSelect(RolapStar.Column col) {
        return this.request.includeInSelect(col);
    }

    @Override
    protected boolean isPartOfSelect(RolapStar.Measure measure) {
        return this.request.includeInSelect(measure);
    }

    @Override
    public int getMeasureCount() {
        return this.request.getDrillThroughMeasures().size() > 0 ? this.request.getDrillThroughMeasures().size() : 1;
    }

    @Override
    public RolapStar.Measure getMeasure(int i) {
        return this.request.getDrillThroughMeasures().size() > 0 ? this.request.getDrillThroughMeasures().get(i) : this.request.getMeasure();
    }

    @Override
    public String getMeasureAlias(int i) {
        return this.request.getDrillThroughMeasures().size() > 0 ? this.request.getDrillThroughMeasures().get(i).getName() : this.columnNames.get(this.columnNames.size() - 1);
    }

    @Override
    public RolapStar.Column[] getColumns() {
        return this.request.getConstrainedColumns();
    }

    @Override
    public String getColumnAlias(int i) {
        return this.columnNames.get(i);
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        StarColumnPredicate constr = this.request.getValueAt(i);
        return constr == null ? LiteralStarPredicate.TRUE : constr;
    }

    @Override
    public Pair<String, List<SqlStatement.Type>> generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        this.nonDistinctGenerateSql(sqlQuery);
        this.appendInapplicableFields(sqlQuery);
        return sqlQuery.toSqlAndTypes();
    }

    private void appendInapplicableFields(SqlQuery sqlQuery) {
        for (OlapElement member : this.request.getNonApplicableMembers()) {
            sqlQuery.addSelect("NULL", SqlStatement.Type.STRING, member.getName());
        }
    }

    @Override
    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        if (!this.isPartOfSelect(measure)) {
            return;
        }
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        if (!this.countOnly) {
            String expr = measure.generateExprString(sqlQuery);
            sqlQuery.addSelect(expr, null, this.getMeasureAlias(i));
        }
    }

    @Override
    protected boolean isAggregate() {
        return false;
    }

    @Override
    protected boolean isOrdered() {
        return true;
    }

    @Override
    protected List<StarPredicate> getPredicateList() {
        return this.listOfStarPredicates;
    }

    @Override
    protected void extraPredicates(SqlQuery sqlQuery) {
        super.extraPredicates(sqlQuery);
        if (this.countOnly) {
            return;
        }
        HashSet<String> columnNameSet = new HashSet<String>();
        columnNameSet.addAll(this.columnNames);
        List<StarPredicate> predicateList = this.getPredicateList();
        for (StarPredicate predicate : predicateList) {
            for (RolapStar.Column column : predicate.getConstrainedColumnList()) {
                sqlQuery.addSelect(column.generateExprString(sqlQuery), column.getInternalType(), this.makeAlias(column, this.columnNames, columnNameSet));
            }
        }
    }
}

