/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.Access;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberExcludeConstraint;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger(RolapNativeSet.class);
    private SmartCache<Object, TupleList> cache = new SoftSmartCache<Object, TupleList>();

    protected abstract boolean restrictMemberTypes();

    protected CrossJoinArgFactory crossJoinArgFactory() {
        return new CrossJoinArgFactory(this.restrictMemberTypes());
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args, boolean joinArg) {
        for (CrossJoinArg arg : args) {
            if (arg.isPreferInterpreter(joinArg)) continue;
            return false;
        }
        return true;
    }

    @Override
    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache<Object, TupleList>() : new SoftSmartCache<Object, TupleList>();
    }

    protected void overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        for (CrossJoinArg carg : cargs) {
            RolapLevel level = carg.getLevel();
            if (level == null) continue;
            RolapHierarchy hierarchy = level.getHierarchy();
            Member contextMember = hierarchy.hasAll() || schemaReader.getRole().getAccess(hierarchy) == Access.ALL ? schemaReader.substitute(hierarchy.getAllMember()) : new RestrictedMemberReader.MultiCardinalityDefaultMember(hierarchy.getMemberReader().getRootMembers().get(0));
            evaluator.setContext(contextMember);
        }
        if (storedMeasure != null) {
            evaluator.setContext(storedMeasure);
        }
    }

    public void flushCache() {
        this.cache.clear();
    }

    private static class SchemaReaderWithMemberReaderCache
    extends DelegatingSchemaReader
    implements SchemaReaderWithMemberReaderAvailable {
        private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();

        SchemaReaderWithMemberReaderCache(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
            MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
            if (memberReader == null) {
                memberReader = ((RolapHierarchy)hierarchy).createMemberReader(this.schemaReader.getRole());
                this.hierarchyReaders.put(hierarchy, memberReader);
            }
            return memberReader;
        }
    }

    public static interface SchemaReaderWithMemberReaderAvailable
    extends SchemaReader {
        public MemberReader getMemberReader(Hierarchy var1);
    }

    protected class SetEvaluator
    implements NativeEvaluator {
        private final CrossJoinArg[] args;
        private final SchemaReaderWithMemberReaderAvailable schemaReader;
        private final TupleConstraint constraint;
        private int maxRows = 0;
        private boolean completeWithNullValues;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader instanceof SchemaReaderWithMemberReaderAvailable ? (SchemaReaderWithMemberReaderAvailable)schemaReader : new SchemaReaderWithMemberReaderCache(schemaReader);
            this.constraint = constraint;
        }

        public void setCompleteWithNullValues(boolean completeWithNullValues) {
            this.completeWithNullValues = completeWithNullValues;
        }

        @Override
        public Object execute(ResultStyle desiredResultStyle) {
            switch (desiredResultStyle) {
                case ITERABLE: {
                    CrossJoinArg[] arr$ = this.args;
                    int len$ = arr$.length;
                    int i$ = 0;
                    if (i$ < len$) {
                        CrossJoinArg arg = arr$[i$];
                        if (arg.getLevel().getDimension().isHighCardinality()) {
                            return this.executeList(new HighCardSqlTupleReader(this.constraint));
                        }
                        return this.executeList(new SqlTupleReader(this.constraint));
                    }
                }
                case MUTABLE_LIST: 
                case LIST: {
                    return this.executeList(new SqlTupleReader(this.constraint));
                }
            }
            throw ResultStyleException.generate(ResultStyle.ITERABLE_MUTABLELIST_LIST, Collections.singletonList(desiredResultStyle));
        }

        protected TupleList executeList(SqlTupleReader tr) {
            RolapNative.TupleEvent e;
            boolean hasEnumTargets;
            tr.setMaxRows(this.maxRows);
            for (CrossJoinArg arg : this.args) {
                this.addLevel(tr, arg);
            }
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(tr.getCacheKey());
            key.addAll(Arrays.asList(this.args));
            key.add(this.maxRows);
            key.add(this.schemaReader.getRole());
            TupleList result = (TupleList)RolapNativeSet.this.cache.get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return new DelegatingTupleList(this.args.length, Util.cast(result));
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.executingSql(e);
            }
            TupleList partialResult = result;
            ArrayList<List<RolapMember>> newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList<List<RolapMember>>();
            }
            DataSource dataSource = this.schemaReader.getDataSource();
            result = this.args.length == 1 ? tr.readMembers(dataSource, partialResult, newPartialResult) : tr.readTuples(dataSource, partialResult, newPartialResult);
            if (this.completeWithNullValues && result.size() < this.maxRows) {
                RolapLevel l = this.args[0].getLevel();
                ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                for (List lm : result) {
                    for (Member m : lm) {
                        list.add((RolapMember)m);
                    }
                }
                SqlTupleReader str = new SqlTupleReader(new MemberExcludeConstraint(list, l, this.constraint instanceof SetConstraint ? (SetConstraint)this.constraint : null));
                str.setAllowHints(false);
                for (CrossJoinArg arg : this.args) {
                    this.addLevel(str, arg);
                }
                str.setMaxRows(this.maxRows - result.size());
                result.addAll(str.readMembers(dataSource, null, new ArrayList<List<RolapMember>>()));
            }
            if (!MondrianProperties.instance().DisableCaching.get()) {
                if (hasEnumTargets) {
                    if (newPartialResult != null) {
                        RolapNativeSet.this.cache.put(key, new DelegatingTupleList(this.args.length, Util.cast(newPartialResult)));
                    }
                } else {
                    RolapNativeSet.this.cache.put(key, result);
                }
            }
            return this.filterInaccessibleTuples(result);
        }

        private TupleList filterInaccessibleTuples(TupleList tupleList) {
            if (this.needsFiltering(tupleList)) {
                Predicate memberInaccessible = this.memberInaccessiblePredicate();
                CollectionUtils.filter((Collection)tupleList, (Predicate)this.tupleAccessiblePredicate(memberInaccessible));
            }
            return tupleList;
        }

        private boolean needsFiltering(TupleList tupleList) {
            return tupleList.size() > 0 && CollectionUtils.exists((Collection)((Collection)tupleList.get(0)), (Predicate)this.needsFilterPredicate());
        }

        private Predicate needsFilterPredicate() {
            return new Predicate(){

                public boolean evaluate(Object o) {
                    Member member = (Member)o;
                    return SetEvaluator.this.isRaggedLevel(member.getLevel()) || SetEvaluator.this.isCustomAccess(member.getHierarchy());
                }
            };
        }

        private boolean isRaggedLevel(Level level) {
            if (level instanceof RolapLevel) {
                return ((RolapLevel)level).getHideMemberCondition() != RolapLevel.HideMemberCondition.Never;
            }
            return true;
        }

        private boolean isCustomAccess(Hierarchy hierarchy) {
            if (this.constraint.getEvaluator() == null) {
                return false;
            }
            Access access = this.constraint.getEvaluator().getSchemaReader().getRole().getAccess(hierarchy);
            return access == Access.CUSTOM;
        }

        private Predicate memberInaccessiblePredicate() {
            if (this.constraint.getEvaluator() != null) {
                return new Predicate(){

                    public boolean evaluate(Object o) {
                        Role role = SetEvaluator.this.constraint.getEvaluator().getSchemaReader().getRole();
                        Member member = (Member)o;
                        return member.isHidden() || !role.canAccess(member);
                    }
                };
            }
            return new Predicate(){

                public boolean evaluate(Object o) {
                    return ((Member)o).isHidden();
                }
            };
        }

        private Predicate tupleAccessiblePredicate(final Predicate memberInaccessible) {
            return new Predicate(){

                public boolean evaluate(Object o) {
                    return !CollectionUtils.exists((Collection)((List)o), (Predicate)memberInaccessible);
                }
            };
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            if (level == null) {
                tr.incrementEmptySets();
                return;
            }
            RolapHierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        @Override
        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            super.addConstraint(sqlQuery, baseCube, aggStar);
            for (CrossJoinArg arg : this.args) {
                RolapLevel level;
                if (!this.canApplyCrossJoinArgConstraint(arg) || (level = arg.getLevel()) != null && !this.levelIsOnBaseCube(baseCube, level)) continue;
                arg.addConstraint(sqlQuery, baseCube, aggStar);
            }
        }

        protected boolean canApplyCrossJoinArgConstraint(CrossJoinArg arg) {
            return !(arg instanceof MemberListCrossJoinArg) || !((MemberListCrossJoinArg)arg).hasCalcMembers();
        }

        private boolean levelIsOnBaseCube(RolapCube baseCube, RolapLevel level) {
            return baseCube.findBaseCubeHierarchy(level.getHierarchy()) != null;
        }

        @Override
        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            for (CrossJoinArg arg : this.args) {
                if (!this.canApplyCrossJoinArgConstraint(arg)) continue;
                key.add(arg);
            }
            return key;
        }
    }
}

