/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.UelExpressionCondition;
import org.apache.commons.lang3.StringUtils;

public class ConditionUtil {
    public static boolean hasTrueCondition(SequenceFlow sequenceFlow, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlow.getId(), execution.getProcessDefinitionId());
            conditionExpression = ConditionUtil.getActiveValue(sequenceFlow.getConditionExpression(), "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = sequenceFlow.getConditionExpression();
        }
        if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
            Expression expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
            UelExpressionCondition condition = new UelExpressionCondition(expression);
            return condition.evaluate(sequenceFlow.getId(), execution);
        }
        return true;
    }

    protected static String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

