/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDeadLetterJobToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MoveDeadLetterJobToExecutableJobCmd.class);
    protected String jobId;
    protected int retries;

    public MoveDeadLetterJobToExecutableJobCmd(String jobId, int retries) {
        this.jobId = jobId;
        this.retries = retries;
    }

    @Override
    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        DeadLetterJobEntity job = (DeadLetterJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving deadletter job to executable job table {}", (Object)job.getId());
        }
        return commandContext.getJobManager().moveDeadLetterJobToExecutableJob(job, this.retries);
    }

    public String getJobId() {
        return this.jobId;
    }
}

