/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.pvm.runtime;

import java.util.List;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.activiti5.engine.impl.pvm.process.TransitionImpl;
import org.activiti5.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti5.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationTransitionDestroyScope
implements AtomicOperation {
    private static Logger log = LoggerFactory.getLogger(AtomicOperationTransitionDestroyScope.class);

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        InterpretableExecution propagatingExecution = null;
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity.isScope()) {
            InterpretableExecution parentScopeInstance = null;
            if (execution.isConcurrent() && !execution.isScope()) {
                InterpretableExecution concurrentRoot = (InterpretableExecution)execution.getParent();
                parentScopeInstance = (InterpretableExecution)execution.getParent().getParent();
                log.debug("moving concurrent {} one scope up under {}", (Object)execution, (Object)parentScopeInstance);
                List<? extends ActivityExecution> parentScopeInstanceExecutions = parentScopeInstance.getExecutions();
                List<? extends ActivityExecution> concurrentRootExecutions = concurrentRoot.getExecutions();
                if (parentScopeInstanceExecutions.size() == 1) {
                    ((InterpretableExecution)parentScopeInstanceExecutions.get(0)).setConcurrent(true);
                }
                concurrentRootExecutions.remove(execution);
                parentScopeInstanceExecutions.add(execution);
                execution.setParent(parentScopeInstance);
                execution.setActivity(activity);
                propagatingExecution = execution;
                if (concurrentRootExecutions.size() == 1) {
                    InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRootExecutions.get(0);
                    if (lastConcurrent.isScope()) {
                        lastConcurrent.setConcurrent(false);
                    } else {
                        log.debug("merging last concurrent {} into concurrent root {}", (Object)lastConcurrent, (Object)concurrentRoot);
                        concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                        concurrentRoot.setActive(lastConcurrent.isActive());
                        lastConcurrent.setReplacedBy(concurrentRoot);
                        lastConcurrent.remove();
                    }
                }
            } else if (execution.isConcurrent() && execution.isScope()) {
                log.debug("scoped concurrent {} becomes concurrent and remains under {}", (Object)execution, (Object)execution.getParent());
                execution.destroy();
                propagatingExecution = execution;
            } else {
                propagatingExecution = (InterpretableExecution)execution.getParent();
                propagatingExecution.setActivity((ActivityImpl)execution.getActivity());
                propagatingExecution.setTransition(execution.getTransition());
                propagatingExecution.setActive(true);
                log.debug("destroy scope: scoped {} continues as parent scope {}", (Object)execution, (Object)propagatingExecution);
                execution.destroy();
                execution.remove();
            }
        } else {
            propagatingExecution = execution;
        }
        ScopeImpl nextOuterScopeElement = activity.getParent();
        TransitionImpl transition = propagatingExecution.getTransition();
        ActivityImpl destination = transition.getDestination();
        if (this.transitionLeavesNextOuterScope(nextOuterScopeElement, destination)) {
            propagatingExecution.setActivity((ActivityImpl)nextOuterScopeElement);
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_END);
        } else {
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_TAKE);
        }
    }

    public boolean transitionLeavesNextOuterScope(ScopeImpl nextScopeElement, ActivityImpl destination) {
        return !nextScopeElement.contains(destination);
    }
}

