/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.pvm.runtime;

import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.activiti5.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti5.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationProcessEnd
extends AbstractEventAtomicOperation {
    private static Logger log = LoggerFactory.getLogger(AtomicOperationProcessEnd.class);

    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        InterpretableExecution superExecution = execution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            ActivityImpl activity = (ActivityImpl)superExecution.getActivity();
            subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, execution);
            }
            catch (RuntimeException e) {
                log.error("Error while completing sub process of execution {}", (Object)execution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Error while completing sub process of execution {}", (Object)execution, (Object)e);
                throw new ActivitiException("Error while completing sub process of execution " + execution, e);
            }
        }
        execution.destroy();
        execution.remove();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                log.error("Error while completing sub process of execution {}", (Object)execution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Error while completing sub process of execution {}", (Object)execution, (Object)e);
                throw new ActivitiException("Error while completing sub process of execution " + execution, e);
            }
        }
    }
}

