/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.event.logger.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.activiti.engine.delegate.event.ActivitiVariableEvent;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti5.engine.impl.event.logger.handler.AbstractDatabaseEventLoggerEventHandler;
import org.activiti5.engine.impl.variable.BooleanType;
import org.activiti5.engine.impl.variable.DateType;
import org.activiti5.engine.impl.variable.DoubleType;
import org.activiti5.engine.impl.variable.IntegerType;
import org.activiti5.engine.impl.variable.LongStringType;
import org.activiti5.engine.impl.variable.LongType;
import org.activiti5.engine.impl.variable.SerializableType;
import org.activiti5.engine.impl.variable.ShortType;
import org.activiti5.engine.impl.variable.StringType;
import org.activiti5.engine.impl.variable.UUIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VariableEventHandler
extends AbstractDatabaseEventLoggerEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(VariableEventHandler.class);
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_UUID = "uuid";
    public static final String TYPE_JSON = "json";

    protected Map<String, Object> createData(ActivitiVariableEvent variableEvent) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.putInMapIfNotNull(data, "name", variableEvent.getVariableName());
        this.putInMapIfNotNull(data, "processDefinitionId", variableEvent.getProcessDefinitionId());
        this.putInMapIfNotNull(data, "processInstanceId", variableEvent.getProcessInstanceId());
        this.putInMapIfNotNull(data, "executionId", variableEvent.getExecutionId());
        this.putInMapIfNotNull(data, "value", variableEvent.getVariableValue());
        VariableType variableType = variableEvent.getVariableType();
        if (variableType instanceof BooleanType) {
            this.putInMapIfNotNull(data, "booleanValue", (Boolean)variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "value", variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "variableType", TYPE_BOOLEAN);
        } else if (variableType instanceof StringType || variableType instanceof LongStringType) {
            this.putInMapIfNotNull(data, "stringValue", (String)variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "variableType", TYPE_STRING);
        } else if (variableType instanceof ShortType) {
            Short value = (Short)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "shortValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_SHORT);
            if (value != null) {
                this.putInMapIfNotNull(data, "integerValue", value.intValue());
                this.putInMapIfNotNull(data, "longValue", value.longValue());
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof IntegerType) {
            Integer value = (Integer)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "integerValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_INTEGER);
            if (value != null) {
                this.putInMapIfNotNull(data, "longValue", value.longValue());
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof LongType) {
            Long value = (Long)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "longValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_LONG);
            if (value != null) {
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof DoubleType) {
            Double value = (Double)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "doubleValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_DOUBLE);
            if (value != null) {
                this.putInMapIfNotNull(data, "integerValue", value.intValue());
                this.putInMapIfNotNull(data, "longValue", value.longValue());
            }
        } else if (variableType instanceof DateType) {
            Date value = (Date)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "dateValue", value != null ? Long.valueOf(value.getTime()) : null);
            this.putInMapIfNotNull(data, "variableType", TYPE_DATE);
        } else if (variableType instanceof UUIDType) {
            String value = null;
            value = variableEvent.getVariableValue() instanceof UUID ? ((UUID)variableEvent.getVariableValue()).toString() : (String)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "uuidValue", value);
            this.putInMapIfNotNull(data, "stringValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_UUID);
        } else if (variableType instanceof SerializableType || variableEvent.getVariableValue() != null && variableEvent.getVariableValue() instanceof Object) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String value = objectMapper.writeValueAsString(variableEvent.getVariableValue());
                this.putInMapIfNotNull(data, "jsonValue", value);
                this.putInMapIfNotNull(data, "variableType", TYPE_JSON);
                this.putInMapIfNotNull(data, "value", value);
            }
            catch (JsonProcessingException e) {
                logger.debug("Could not serialize variable value " + variableEvent.getVariableValue());
            }
        }
        return data;
    }
}

