/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.ActivitiVariableEvent;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiOptimisticLockingException;
import org.activiti5.engine.ActivitiWrongDbException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.DeploymentQueryImpl;
import org.activiti5.engine.impl.ExecutionQueryImpl;
import org.activiti5.engine.impl.GroupQueryImpl;
import org.activiti5.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti5.engine.impl.HistoricDetailQueryImpl;
import org.activiti5.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti5.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti5.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti5.engine.impl.JobQueryImpl;
import org.activiti5.engine.impl.ModelQueryImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti5.engine.impl.ProcessInstanceQueryImpl;
import org.activiti5.engine.impl.TaskQueryImpl;
import org.activiti5.engine.impl.UserQueryImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.db.ActivitiVersion;
import org.activiti5.engine.impl.db.DbSqlSessionFactory;
import org.activiti5.engine.impl.db.EntityDependencyOrder;
import org.activiti5.engine.impl.db.HasRevision;
import org.activiti5.engine.impl.db.ListQueryParameterObject;
import org.activiti5.engine.impl.db.PersistentObject;
import org.activiti5.engine.impl.interceptor.Session;
import org.activiti5.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti5.engine.impl.variable.DeserializedObject;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final List<ActivitiVersion> ACTIVITI_VERSIONS = new ArrayList<ActivitiVersion>();
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<? extends PersistentObject>, List<PersistentObject>> insertedObjects = new HashMap<Class<? extends PersistentObject>, List<PersistentObject>>();
    protected Map<Class<?>, Map<String, CachedObject>> cachedObjects = new HashMap();
    protected List<DeleteOperation> deleteOperations = new ArrayList<DeleteOperation>();
    protected List<DeserializedObject> deserializedObjects = new ArrayList<DeserializedObject>();
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(PersistentObject persistentObject) {
        Class<?> clazz;
        if (persistentObject.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            persistentObject.setId(id);
        }
        if (!this.insertedObjects.containsKey(clazz = persistentObject.getClass())) {
            this.insertedObjects.put(clazz, new ArrayList());
        }
        this.insertedObjects.get(clazz).add(persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void update(PersistentObject persistentObject) {
        this.cachePut(persistentObject, false);
    }

    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.getSqlSession().update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter) {
        this.deleteOperations.add(new BulkDeleteOperation(statement, parameter));
    }

    public void delete(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            log.debug("skipping redundant delete: {}", (Object)persistentObject);
            return;
        }
        this.deleteOperations.add(new CheckedDeleteOperation(persistentObject));
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        if (page != null) {
            parameter.setFirstResult(page.getFirstResult());
            parameter.setMaxResults(page.getMaxResults());
        }
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof PersistentObject) {
            PersistentObject loadedObject = (PersistentObject)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public <T extends PersistentObject> T selectById(Class<T> entityClass, String id) {
        PersistentObject persistentObject = (PersistentObject)this.cacheGet(entityClass, id);
        if (persistentObject != null) {
            return (T)persistentObject;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        persistentObject = (PersistentObject)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (persistentObject == null) {
            return null;
        }
        this.cachePut(persistentObject, true);
        return (T)persistentObject;
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!(loadedObjects.get(0) instanceof PersistentObject)) {
            return loadedObjects;
        }
        ArrayList<PersistentObject> filteredObjects = new ArrayList<PersistentObject>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            PersistentObject cachedPersistentObject = this.cacheFilter((PersistentObject)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected CachedObject cachePut(PersistentObject persistentObject, boolean storeState) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObject.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedObject>();
            this.cachedObjects.put(persistentObject.getClass(), classCache);
        }
        CachedObject cachedObject = new CachedObject(persistentObject, storeState);
        classCache.put(persistentObject.getId(), cachedObject);
        return cachedObject;
    }

    protected PersistentObject cacheFilter(PersistentObject persistentObject) {
        PersistentObject cachedPersistentObject = (PersistentObject)this.cacheGet(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.cachePut(persistentObject, true);
        return persistentObject;
    }

    protected <T> T cacheGet(Class<T> entityClass, String id) {
        CachedObject cachedObject = null;
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getPersistentObject();
        }
        return null;
    }

    protected void cacheRemove(Class<?> persistentObjectClass, String persistentObjectId) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObjectClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(persistentObjectId);
    }

    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<PersistentObject> entities = new ArrayList<PersistentObject>(classCache.size());
            for (CachedObject cachedObject : classCache.values()) {
                entities.add(cachedObject.getPersistentObject());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public <T> T findInCache(Class<T> entityClass, String id) {
        return this.cacheGet(entityClass, id);
    }

    public void addDeserializedObject(DeserializedObject deserializedObject) {
        this.deserializedObjects.add(deserializedObject);
    }

    @Override
    public void flush() {
        List<DeleteOperation> removedOperations = this.removeUnnecessaryOperations();
        this.flushDeserializedObjects();
        List<PersistentObject> updatedObjects = this.getUpdatedObjects();
        if (log.isDebugEnabled()) {
            Collection<List<PersistentObject>> insertedObjectLists = this.insertedObjects.values();
            int nrOfInserts = 0;
            int nrOfUpdates = 0;
            int nrOfDeletes = 0;
            for (List<PersistentObject> insertedObjectList : insertedObjectLists) {
                for (PersistentObject insertedObject : insertedObjectList) {
                    log.debug("  insert {}", (Object)insertedObject);
                    ++nrOfInserts;
                }
            }
            for (PersistentObject updatedObject : updatedObjects) {
                log.debug("  update {}", (Object)updatedObject);
                ++nrOfUpdates;
            }
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                log.debug("  {}", (Object)deleteOperation);
                ++nrOfDeletes;
            }
            log.debug("flush summary: {} insert, {} update, {} delete.", new Object[]{nrOfInserts, nrOfUpdates, nrOfDeletes});
            log.debug("now executing flush...");
        }
        this.flushInserts();
        this.flushUpdates(updatedObjects);
        this.flushDeletes(removedOperations);
    }

    protected List<DeleteOperation> removeUnnecessaryOperations() {
        ArrayList<DeleteOperation> removedDeleteOperations = new ArrayList<DeleteOperation>();
        Iterator<DeleteOperation> deleteIterator = this.deleteOperations.iterator();
        while (deleteIterator.hasNext()) {
            DeleteOperation deleteOperation = deleteIterator.next();
            Class<? extends PersistentObject> deletedPersistentObjectClass = deleteOperation.getPersistentObjectClass();
            List<PersistentObject> insertedObjectsOfSameClass = this.insertedObjects.get(deletedPersistentObjectClass);
            if (insertedObjectsOfSameClass != null && insertedObjectsOfSameClass.size() > 0) {
                Iterator<PersistentObject> insertIterator = insertedObjectsOfSameClass.iterator();
                while (insertIterator.hasNext()) {
                    PersistentObject insertedObject = insertIterator.next();
                    if (!deleteOperation.sameIdentity(insertedObject)) continue;
                    insertIterator.remove();
                    deleteIterator.remove();
                    removedDeleteOperations.add(deleteOperation);
                }
                if (this.insertedObjects.get(deletedPersistentObjectClass).size() == 0) {
                    this.insertedObjects.remove(deletedPersistentObjectClass);
                }
            }
            deleteOperation.clearCache();
        }
        for (Class<? extends PersistentObject> persistentObjectClass : this.insertedObjects.keySet()) {
            for (PersistentObject insertedObject : this.insertedObjects.get(persistentObjectClass)) {
                this.cacheRemove(insertedObject.getClass(), insertedObject.getId());
            }
        }
        return removedDeleteOperations;
    }

    protected void flushDeserializedObjects() {
        for (DeserializedObject deserializedObject : this.deserializedObjects) {
            deserializedObject.flush();
        }
    }

    public List<PersistentObject> getUpdatedObjects() {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        for (Class<?> clazz : this.cachedObjects.keySet()) {
            Map<String, CachedObject> classCache = this.cachedObjects.get(clazz);
            for (CachedObject cachedObject : classCache.values()) {
                PersistentObject persistentObject = cachedObject.getPersistentObject();
                if (this.isPersistentObjectDeleted(persistentObject)) continue;
                Object originalState = cachedObject.getPersistentObjectState();
                if (persistentObject.getPersistentState() != null && !persistentObject.getPersistentState().equals(originalState)) {
                    updatedObjects.add(persistentObject);
                    continue;
                }
                log.trace("loaded object '{}' was not updated", (Object)persistentObject);
            }
        }
        return updatedObjects;
    }

    protected boolean isPersistentObjectDeleted(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            return true;
        }
        return false;
    }

    public <T extends PersistentObject> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<T> prunedList = new ArrayList<T>(listToPrune);
        for (PersistentObject potentiallyDeleted : listToPrune) {
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                if (!deleteOperation.sameIdentity(potentiallyDeleted)) continue;
                prunedList.remove(potentiallyDeleted);
            }
        }
        return prunedList;
    }

    protected void flushInserts() {
        for (Class<? extends PersistentObject> persistentObjectClass : EntityDependencyOrder.INSERT_ORDER) {
            if (!this.insertedObjects.containsKey(persistentObjectClass)) continue;
            this.flushPersistentObjects(persistentObjectClass, this.insertedObjects.get(persistentObjectClass));
        }
        if (this.insertedObjects.size() > 0) {
            for (Class<? extends PersistentObject> persistentObjectClass : this.insertedObjects.keySet()) {
                this.flushPersistentObjects(persistentObjectClass, this.insertedObjects.get(persistentObjectClass));
            }
        }
        this.insertedObjects.clear();
    }

    protected void flushPersistentObjects(Class<? extends PersistentObject> persistentObjectClass, List<PersistentObject> persistentObjectsToInsert) {
        if (persistentObjectsToInsert.size() == 1) {
            this.flushRegularInsert(persistentObjectsToInsert.get(0), persistentObjectClass);
        } else if (Boolean.FALSE.equals(this.dbSqlSessionFactory.isBulkInsertable(persistentObjectClass))) {
            for (PersistentObject persistentObject : persistentObjectsToInsert) {
                this.flushRegularInsert(persistentObject, persistentObjectClass);
            }
        } else {
            this.flushBulkInsert(this.insertedObjects.get(persistentObjectClass), persistentObjectClass);
        }
        this.insertedObjects.remove(persistentObjectClass);
    }

    protected void flushRegularInsert(PersistentObject persistentObject, Class<? extends PersistentObject> clazz) {
        HasRevision revisionEntity;
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(persistentObject);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + persistentObject.getClass() + " in the ibatis mapping files");
        }
        log.debug("inserting: {}", (Object)persistentObject);
        this.sqlSession.insert(insertStatement, (Object)persistentObject);
        if (persistentObject instanceof HasRevision && (revisionEntity = (HasRevision)((Object)persistentObject)).getRevision() == 0) {
            revisionEntity.setRevision(revisionEntity.getRevisionNext());
        }
    }

    protected void flushBulkInsert(List<PersistentObject> persistentObjectList, Class<? extends PersistentObject> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getBulkInsertStatement(clazz);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + persistentObjectList.get(0).getClass() + " in the ibatis mapping files");
        }
        if (persistentObjectList.size() <= this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert()) {
            this.sqlSession.insert(insertStatement, persistentObjectList);
        } else {
            for (int start = 0; start < persistentObjectList.size(); start += this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert()) {
                List<PersistentObject> subList = persistentObjectList.subList(start, Math.min(start + this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert(), persistentObjectList.size()));
                this.sqlSession.insert(insertStatement, subList);
            }
        }
        if (persistentObjectList.get(0) instanceof HasRevision) {
            for (PersistentObject insertedObject : persistentObjectList) {
                HasRevision revisionEntity = (HasRevision)((Object)insertedObject);
                if (revisionEntity.getRevision() != 0) continue;
                revisionEntity.setRevision(revisionEntity.getRevisionNext());
            }
        }
    }

    protected void flushUpdates(List<PersistentObject> updatedObjects) {
        for (PersistentObject updatedObject : updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ActivitiException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            log.debug("updating: {}", (Object)updatedObject);
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords != 1) {
                throw new ActivitiOptimisticLockingException(updatedObject + " was updated by another transaction concurrently");
            }
            if (!(updatedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        updatedObjects.clear();
    }

    protected void flushDeletes(List<DeleteOperation> removedOperations) {
        boolean dispatchEvent = false;
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            dispatchEvent = eventDispatcher.isEnabled();
        }
        this.flushRegularDeletes(dispatchEvent);
        if (dispatchEvent) {
            this.dispatchEventsForRemovedOperations(removedOperations);
        }
        this.deleteOperations.clear();
    }

    protected void dispatchEventsForRemovedOperations(List<DeleteOperation> removedOperations) {
        for (DeleteOperation delete : removedOperations) {
            CheckedDeleteOperation checkedDeleteOperation;
            PersistentObject persistentObject;
            if (!(delete instanceof CheckedDeleteOperation) || !((persistentObject = (checkedDeleteOperation = (CheckedDeleteOperation)delete).getPersistentObject()) instanceof VariableInstanceEntity)) continue;
            VariableInstanceEntity variableInstance = (VariableInstanceEntity)persistentObject;
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)DbSqlSession.createVariableDeleteEvent(variableInstance));
        }
    }

    protected static ActivitiVariableEvent createVariableDeleteEvent(VariableInstanceEntity variableInstance) {
        return ActivitiEventBuilder.createVariableEvent(ActivitiEventType.VARIABLE_DELETED, variableInstance.getName(), null, variableInstance.getType(), variableInstance.getTaskId(), variableInstance.getExecutionId(), variableInstance.getProcessInstanceId(), null);
    }

    protected void flushRegularDeletes(boolean dispatchEvent) {
        for (DeleteOperation delete : this.deleteOperations) {
            BulkCheckedDeleteOperation bulkCheckedDeleteOperation;
            log.debug("executing: {}", (Object)delete);
            delete.execute();
            if (!dispatchEvent) continue;
            if (delete instanceof CheckedDeleteOperation) {
                CheckedDeleteOperation checkedDeleteOperation = (CheckedDeleteOperation)delete;
                PersistentObject persistentObject = checkedDeleteOperation.getPersistentObject();
                if (!(persistentObject instanceof VariableInstanceEntity)) continue;
                VariableInstanceEntity variableInstance = (VariableInstanceEntity)persistentObject;
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)DbSqlSession.createVariableDeleteEvent(variableInstance));
                continue;
            }
            if (!(delete instanceof BulkCheckedDeleteOperation) || !VariableInstanceEntity.class.isAssignableFrom((bulkCheckedDeleteOperation = (BulkCheckedDeleteOperation)delete).getPersistentObjectClass())) continue;
            for (PersistentObject persistentObject : bulkCheckedDeleteOperation.getPersistentObjects()) {
                VariableInstanceEntity variableInstance = (VariableInstanceEntity)persistentObject;
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)DbSqlSession.createVariableDeleteEvent(variableInstance));
            }
        }
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"6.0.0.3".equals(dbVersion)) {
                throw new ActivitiWrongDbException("6.0.0.3", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (errorMessage != null) {
                throw new ActivitiException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ActivitiException("no activiti tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in activiti.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ActivitiException("couldn't get db schema version", e);
        }
        log.debug("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        if (!this.dbSqlSessionFactory.isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String catalog = this.connectionMetadataDefaultCatalog;
        if (this.dbSqlSessionFactory.getDatabaseCatalog() != null && this.dbSqlSessionFactory.getDatabaseCatalog().length() > 0) {
            catalog = this.dbSqlSessionFactory.getDatabaseCatalog();
        }
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null && this.dbSqlSessionFactory.getDatabaseSchema().length() > 0) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        try {
            tables = databaseMetaData.getTables(catalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tables.close();
                }
                catch (Exception e) {
                    log.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ActivitiException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        try {
            tables.close();
        }
        catch (Exception e) {
            log.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("6.0.0.3".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("6.0.0.3");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new ActivitiException("Version of activiti database (" + versionInDatabase + ") is more recent than the engine (" + "6.0.0.3" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            log.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"6.0.0.3");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/activiti/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ModelQueryImpl createModelQueryImpl() {
        return new ModelQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new UserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new GroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public static class CachedObject {
        protected PersistentObject persistentObject;
        protected Object persistentObjectState;

        public CachedObject(PersistentObject persistentObject, boolean storeState) {
            this.persistentObject = persistentObject;
            if (storeState) {
                this.persistentObjectState = persistentObject.getPersistentState();
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public Object getPersistentObjectState() {
            return this.persistentObjectState;
        }
    }

    public class BulkCheckedDeleteOperation
    implements DeleteOperation {
        protected Class<? extends PersistentObject> persistentObjectClass;
        protected List<PersistentObject> persistentObjects = new ArrayList<PersistentObject>();

        public BulkCheckedDeleteOperation(Class<? extends PersistentObject> persistentObjectClass) {
            this.persistentObjectClass = persistentObjectClass;
        }

        public void addPersistentObject(PersistentObject persistentObject) {
            this.persistentObjects.add(persistentObject);
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            for (PersistentObject persistentObject : this.persistentObjects) {
                if (!persistentObject.getClass().equals(other.getClass()) || !persistentObject.getId().equals(other.getId())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clearCache() {
            for (PersistentObject persistentObject : this.persistentObjects) {
                DbSqlSession.this.cacheRemove(persistentObject.getClass(), persistentObject.getId());
            }
        }

        @Override
        public void execute() {
            if (this.persistentObjects.isEmpty()) {
                return;
            }
            String bulkDeleteStatement = DbSqlSession.this.dbSqlSessionFactory.getBulkDeleteStatement(this.persistentObjectClass);
            if ((bulkDeleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(bulkDeleteStatement)) == null) {
                throw new ActivitiException("no bulk delete statement for " + this.persistentObjectClass + " in the mapping files");
            }
            if (this.persistentObjects.get(0) instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(bulkDeleteStatement, this.persistentObjects);
                if (nrOfRowsDeleted < this.persistentObjects.size()) {
                    throw new ActivitiOptimisticLockingException("One of the entities " + this.persistentObjectClass + " was updated by another transaction concurrently while trying to do a bulk delete");
                }
            } else {
                DbSqlSession.this.sqlSession.delete(bulkDeleteStatement, this.persistentObjects);
            }
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return this.persistentObjectClass;
        }

        public void setPersistentObjectClass(Class<? extends PersistentObject> persistentObjectClass) {
            this.persistentObjectClass = persistentObjectClass;
        }

        public List<PersistentObject> getPersistentObjects() {
            return this.persistentObjects;
        }

        public void setPersistentObjects(List<PersistentObject> persistentObjects) {
            this.persistentObjects = persistentObjects;
        }

        public String toString() {
            return "bulk delete of " + this.persistentObjects.size() + (!this.persistentObjects.isEmpty() ? " entities of " + this.persistentObjects.get(0).getClass() : Integer.valueOf(0));
        }
    }

    public class CheckedDeleteOperation
    implements DeleteOperation {
        protected final PersistentObject persistentObject;

        public CheckedDeleteOperation(PersistentObject persistentObject) {
            this.persistentObject = persistentObject;
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return this.persistentObject.getClass();
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return this.persistentObject.getClass().equals(other.getClass()) && this.persistentObject.getId().equals(other.getId());
        }

        @Override
        public void clearCache() {
            DbSqlSession.this.cacheRemove(this.persistentObject.getClass(), this.persistentObject.getId());
        }

        @Override
        public void execute() {
            String deleteStatement = DbSqlSession.this.dbSqlSessionFactory.getDeleteStatement(this.persistentObject.getClass());
            if ((deleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ActivitiException("no delete statement for " + this.persistentObject.getClass() + " in the ibatis mapping files");
            }
            if (this.persistentObject instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
                if (nrOfRowsDeleted == 0) {
                    throw new ActivitiOptimisticLockingException(this.persistentObject + " was updated by another transaction concurrently");
                }
            } else {
                DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public String toString() {
            return "delete " + this.persistentObject;
        }
    }

    public class BulkDeleteOperation
    implements DeleteOperation {
        private String statement;
        private Object parameter;

        public BulkDeleteOperation(String statement, Object parameter) {
            this.statement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(statement);
            this.parameter = parameter;
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return null;
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return false;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void execute() {
            DbSqlSession.this.sqlSession.delete(this.statement, this.parameter);
        }

        public String toString() {
            return "bulk delete: " + this.statement + "(" + this.parameter + ")";
        }
    }

    public static interface DeleteOperation {
        public Class<? extends PersistentObject> getPersistentObjectClass();

        public boolean sameIdentity(PersistentObject var1);

        public void clearCache();

        public void execute();
    }
}

